function onUpdate(context) {
	if (context.state.noParent)
	{
		return { visible: true, enabled: false };
	}

	var isEnabled = false;

	context.selectedItems.forEach(function(item)
	{
		if ((item.wstype === 'document' || item.wstype === 'email') && !item.is_checked_out)
		{
			isEnabled = true;
			return;
		}

		if (item.wstype === 'folder' && (item.has_documents || item.has_subfolders))
		{
			isEnabled = true;
			return;
		}
	});

	return { visible: true, enabled: isEnabled };
}