'ProFX Axcess File Importer Script
'Modified: 20150204 (TR-RXP)    2014US Sclientnum acct v1.pdf
'B1Y received from Pro Svc January 2019

'********************************************************
'* Values set by immGFRTaxInfo Application
'* -----------------------------------------------------
'* strGFRDrawerID - GFRDrawerID from INI file
'* strDelimiter - Delimiter from INI file
'* strErrorName - name to set filename on error
'* strDSN - ODBC DSN from INI file
'* strDBUser - DB username from INI file
'* strDBPWD - db password from INI file
'* strQuery - query to retrieve client name from INI
'* strClientNameField - field name of ClientName from INI
'* sGFRLookupURL - URL to do lookup values
'********************************************************
'Sub UpdateFileName(objFile)

CONST DEBUG_MODE = 0    'Valid options: 1 (log to file)
CONST TEST_MODE = 0     'Valid options: 0 (off) / 1 (on)

Function GenIdxXML(strIN_Path, strIN_FileName)
    On Error Resume Next   

    'VARIABLE DECLARATION
    Dim strFileName, strFilePath
    Dim strClientID, strClientName, strFileSection, strDocumentType 'Used to declare index strings
    Dim strDescription, strPeriodEnd, strYear, strDocumentDate      'Used to declare index strings
    Dim filenamearray

    'get the name and path from the objFile object
    strFileName = strIN_FileName	'objFile.Name
    strSaveFileName = strIN_FileName	'objFile.Name
    strFilePath = strIN_Path		'objFile.Path

    filenamearray = split(strFileName, " ")

    'FILE VALIDITY CHECK
    'If UBound(filenamearray) < 2 Then
	'DebugPrint "Invalid File Name. Not enough array elements."
	'GenIdxXML = BuildErrorXML (1, "Not enough array elements.")
	'Exit function
    'End If


    'VARIABLE ASSIGNMENT
    strDocumentType =   "TAX RETURN"
    strPeriodEnd =      "12/31"
    strDocumentDate =   Date



    'CLIENT NUMBER ASSIGNMENT
    'LOGIC: Everything after the first character of array element 1
    strClientID = Mid(filenamearray(1), 2)
    
    'CLIENT NAME ASSIGNMENT
    'LOGIC: Returned from GoFileRoom
    strCustomerName = GetCustomerName(strClientID)

    'FILE SECTION ASSGINMENT
    'Logic: First character of array element 1
    strFileSection = left(filenamearray(1), 1)
    strFileSection = GetFileSection(strFileSection)

    'DOCUMENT TYPE ASSIGNMENT
    'Static - See Variable Assignment

    'DESCRIPTION ASSIGNMENT
    'Logic: Rebuild Array elements 2 through end of file.

	for x = 2 to ubound(filenamearray)
	  strDescription = strDescription + " " + filenamearray(x)
    next

	strDescription = left(strDescription, InStrRev(strDescription, ".")-1)
	strDescription = Trim(strDescription)

	if InStr(strDescription, "Organizer") > 0 Then
		strdocumentType = "WORKPAPERS"
	end if

    'YEAR ASSIGNMENT
    'Logic: Left 4 characters of array element 0
    strYear = left(filenamearray(0), 4)
 
    'PERIOD END ASSIGNMENT
    'Static - See Variable Assignment

    'DOCUMENT DATE ASSIGNMENT
    'Static - See Variable Assignment

            
    If Trim(strClientID) <> "" Then
        'XML file name
        strNewFileName = Cstr(strGFRDrawerID) & strDelimiter & strcustomername & strDelimiter & strclientid & strDelimiter & strFileSection & strDelimiter & strDocumentType & strDelimiter & strDescription & strDelimiter & strYear & strDelimiter & strPeriodEnd & strDelimiter & strDocumentDate
        		
        'Assign indexing to XML file
        strIdxXML = "<indexes><retcode>0</retcode><retmsg><![CDATA[]]></retmsg><index id=""" & 1 & """>"
	    strIdxXML = strIdxXML & BuildFieldNd("CLIENT NAME", strCustomerName) 
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NUMBER", strClientID) 
        strIdxXML = strIdxXML & BuildFieldNd("File Section", strFileSection) 
        strIdxXML = strIdxXML & BuildFieldNd("Document Type", strDocumentType) 
        strIdxXML = strIdxXML & BuildFieldNd("Description", strDescription)
        strIdxXML = strIdxXML & BuildFieldNd("Year", strYear) 
        strIdxXML = strIdxXML & BuildFieldNd("Period End", strPeriodEnd)
        strIdxXML = strIdxXML & BuildFieldNd("Document Date", strDocumentDate)
		strIdxXML = strIdxXML & "</index></indexes>"
        
        'DEBUG INFO
        DebugPrint "**********************************************************************"
        DebugPrint "File Path = "       & strIN_Path
        DebugPrint "Customer Name = "   & strCustomerName
        DebugPrint "Client Number = "   & strClientID
        DebugPrint "File Section = "    & strFileSection
        DebugPrint "Document Type = "   & strDocumentType
        DebugPrint "Description = "     & strDescription
        DebugPrint "Year = "            & strYear
        DebugPrint "Period End = "      & strPeriodEnd
        DebugPrint "Document Date = "   & strDocumentDate
        DebugPrint "Index XML = "       & strIdxXML
        DebugPrint "New File Name = "   & strNewFileName
	
	If TEST_MODE <> 1 then
		GenIdxXML = strIdxXML
	End If
End If

End function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function BuildErrorXML(ErrNumber, ErrDescription)
	BuildErrorXML = "<indexes><retcode>" & ErrNumber & "</retcode><retmsg><![CDATA[" & ErrDescription & "]]></retmsg><index/></indexes>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function GetFileSection(strPrefix)

   On Error Resume Next
   
   Dim strAbbrev

   if len(strPrefix) > 1 then
    strAbbrev = Mid(strPrefix, 3, 1)
   else
    strAbbrev = strPrefix
   end if

   Select Case UCase(strAbbrev)
    Case "I"
        GetFileSection = "1040 INDIVIDUAL TAX"    
    Case "C"
        GetFileSection = "1120 BUSINESS TAX"
    Case "K"
        GetFileSection = "5500 BUSINESS TAX"
    Case "P"
        GetFileSection = "1065 BUSINESS TAX"
    Case "S"
        GetFileSection = "1120S BUSINESS TAX"
    Case "Y"
        GetFileSection = "706 ESTATE TAX"
    Case "F"
        GetFileSection = "1041 FIDUCIARY TAX"
    Case "X"
        GetFileSection = "990 BUSINESS TAX"
   End Select

End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function GetCustomerName(sClientID)
On Error Resume Next
Dim objXMLHTTP
Dim objXML
Dim sXml
Dim objNode
Dim objNodes


    Set objXMLHTTP = CreateObject("MSXML2.XMLHTTP.6.0")
    sXml = "<gfr_lookup>" & _
        "<uid><![CDATA[" & sUserName & "]]></uid>" & _
        "<pwd><![CDATA[" & sPassword & "]]></pwd>" & _
        "<drawer_id>" & strGFRDrawerID & "</drawer_id>" & _
        "<fields multi_value='0' count='1'>" & _
            "<field>" & _
                "<name><![CDATA[Client Number]]></name>" & _
                "<value><![CDATA[" & sClientID & "]]> </value>" & _
            "</field>" & _
            "<field>" & _
                "<name><![CDATA[Client Name]]></name>" & _
                "<value><![CDATA[*]]> </value>" & _
            "</field>" & _
        "</fields>" & _
    "</gfr_lookup>"
    DebugPrint "Sending XML: " & sXml
    
    Set objXML = CreateObject("MSXML2.DOMDocument.6.0")
    objXML.loadXML (sXml)
    
    objXMLHTTP.open "POST", sGFRLookupURL, False
    DebugPrint "Posting XML to " & sGFRLookupURL
    objXMLHTTP.send objXML
    DebugPrint "response: " & objXMLHTTP.responseText
    
    objXML.loadXML (objXMLHTTP.responseText)
    If objXML.parseError.errorCode <> 0 Then
        DebugPrint "Error in return XML, " & objXMLHTTP.responseText
        Exit Function
    End If
    
    Set objNode = objXML.firstChild.selectSingleNode("ret_code")
    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (ret_code), " & objXML.xml
        Exit Function
    End If
    If objNode.Text <> 0 Then
        Set objNode = objXML.firstChild.selectSingleNode("ret_message")
        If objNode Is Nothing Then
            DebugPrint "Lookup list values returned invalid XML (ret_message), " & objXML.xml
        Else
            DebugPrint "Error occured in retrieving lookup value, " & objNode.Text
        End If
        Exit Function
    End If
    
    Set objNodes = objXML.firstChild.selectNodes("values")
    If objNodes Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (values), " & objXML.xml
        Exit Function
    End If
    Debug.Print objNodes.length
    Set objNode = objXML.firstChild.selectSingleNode("./values/row/field/name[. = 'Client Name']").parentNode.selectSingleNode("value")
    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (value), " & objXML.xml
        Exit Function
    End If
    GetCustomerName = objNode.Text
    
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub DebugPrint(strMessage)

    If (DEBUG_MODE XOr 1) = (DEBUG_MODE - 1) Then
	LogToFile strMessage
    End If

    If (DEBUG_MODE XOr 2) = (DEBUG_MODE - 2) Then
	MsgBox strMessage
	'LogToFile strMessage
    End If

End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub LogToFile(strMessage)

    Dim objFSO, objTStream

    On Error Resume Next

    Set objFSO = CreateObject("Scripting.FileSystemObject")
    Set objTStream = objFSO.OpenTextFile("C:\Program Files\GoFileRoom\GFRFileImporter\Log\immGFRPDFImport " & year(now) & "-" & month(now) & ".log", 8, True)
    Call objTStream.WriteLine(Now & ": " & strMessage)
    objTStream.Close

    Err.Clear
	
End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Function CData(ByVal strValue)	'As String
	CData = "<![CDATA[" & strValue & "]]>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function Quotes(ByVal strValue)	'As String
	Quotes = """" & strValue & """"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function BuildFieldNd(ByVal strIdx, ByVal strValue)	'As String
	BuildFieldNd = "<field name=" & Quotes(strIdx) & ">" & cData(strValue) & "</field>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************