' Lacerte FileImporter Script

CONST DEBUG_MODE = 1    'Valid options: 1 (log to file)
CONST TEST_MODE = 0     'Valid options: 0 (off) / 1 (on)

Function GenIdxXML(strIN_Path, strIN_FileName)
    On Error Resume Next   

    'VARIABLE DECLARATION
    Dim strFileName, strFilePath 'used to pull FileName and Directory
    Dim strClientID, strClientName 'Used to declare index strings
    Dim strDescription, strPeriodEnd, strYear, strFileSection, strDocumentDate, strDocumentType 'Used to declare index strings

    'VARIABLE ASSIGNMENT
    strFileName = strIN_FileName		'objFile.Name
    strFilePath = strIN_Path			'objFile.Path
    strDocumentDate = Date
    arrFilePath = Split(strFilePath, "\")
    arrFileName = Split(strFileName, " for ")
    strDocumentType = "TAX RETURN"
    strPeriodEnd = "12/31"

    'CLIENT NUMBER ASSIGNMENT
    strClientID = arrFileName(UBound(arrFileName))
    strClientID = Left(strClientID, InStr(strClientID, ".")-1)

    'CLIENT NAME ASSIGNMENT
    strCustomerName = GetCustomerName(strClientID)

    'FILE SECTION ASSGINMENT
    'LOGIC: Pull File Section from the Folder the file resides in 
    strFileSection = arrFilePath(UBound(arrFilePath)-1)

    'DOCUMENT TYPE ASSIGNMENT
    'Static - See Variable Assignment

    'DESCRIPTION ASSIGNMENT
    'Pull the description from part of the File Name - Anything before "for"
    for x = 0 to (UBound(arrFileName)-1)
        strDescription = strDescription + arrFileName(x)
    next

    'YEAR ASSIGNMENT
    'Determines the Year from the FileName
    strYear = arrFilePath(UBound(arrFilePath)-2)

    'PERIOD END ASSIGNMENT
    'Static - See Variable Assignment

    'DOCUMENT DATE ASSIGNMENT
    'Static - See Variable Assignment


    'XML	
    If Trim(strClientID) <> "" Then
        'XML file name
        strNewFileName = Cstr(strGFRDrawerID) & strDelimiter & strcustomername & strDelimiter & strclientid & strDelimiter & strFileSection & strDelimiter & strDocumentType & strDelimiter & strDescription & strDelimiter & strYear & strDelimiter & strPeriodEnd & strDelimiter & strDocumentDate

        'Assign indexing to XML file
        strIdxXML = "<indexes><retcode>0</retcode><retmsg><![CDATA[]]></retmsg><index id=""" & 1 & """>"
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NAME", strCustomerName) 
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NUMBER", strClientID) 
        strIdxXML = strIdxXML & BuildFieldNd("File Section", strFileSection) 
        strIdxXML = strIdxXML & BuildFieldNd("Document Type", strDocumentType) 
        strIdxXML = strIdxXML & BuildFieldNd("Description", strDescription)
        strIdxXML = strIdxXML & BuildFieldNd("Year", strYear) 
        strIdxXML = strIdxXML & BuildFieldNd("Period End", strPeriodEnd)
        strIdxXML = strIdxXML & BuildFieldNd("Document Date", strDocumentDate)
        strIdxXML = strIdxXML & "</index></indexes>"

        'DEBUG INFO
        DebugPrint "**********************************************************************"
        DebugPrint "Customer Name = " & strCustomerName
        DebugPrint "Client ID = " & strClientID
        DebugPrint "File Section = " & strFileSection
        DebugPrint "Document Type = " & strDocumentType
        DebugPrint "Description = " & strDescription
        DebugPrint "Year = " & strYear
        DebugPrint "Period End = " & strPeriodEnd
        DebugPrint "Document Date = " & strDocumentDate
        DebugPrint "New File Name = " & strNewFileName
        DebugPrint "Index XML = " & strIdxXML

        if TEST_MODE <> 1 then
            GenIdxXML = strIdxXML
        end if
    End If

End function	
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function BuildErrorXML(ErrNumber, ErrDescription)
    BuildErrorXML = "<indexes><retcode>" & ErrNumber & "</retcode><retmsg><![CDATA[" & ErrDescription & "]]></retmsg><index/></indexes>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function GetCustomerName(sClientID)
    On Error Resume Next

    Dim objXMLHTTP
    Dim objXML
    Dim sXml
    Dim objNode
    Dim objNodes

    Set objXMLHTTP = CreateObject("MSXML2.XMLHTTP.6.0")
    sXml = "<gfr_lookup>" & _
    "<uid><![CDATA[" & sUserName & "]]></uid>" & _
    "<pwd><![CDATA[" & sPassword & "]]></pwd>" & _
    "<drawer_id>" & strGFRDrawerID & "</drawer_id>" & _
    "<fields multi_value='0' count='1'>" & _
    "<field>" & _
    "<name><![CDATA[Client Number]]></name>" & _
    "<value><![CDATA[" & sClientID & "]]> </value>" & _
    "</field>" & _
    "<field>" & _
    "<name><![CDATA[Client Name]]></name>" & _
    "<value><![CDATA[*]]> </value>" & _
    "</field>" & _
    "</fields>" & _
    "</gfr_lookup>"
    DebugPrint "Sending XML: " & sXml
    
    Set objXML = CreateObject("MSXML2.DOMDocument.6.0")
    objXML.loadXML (sXml)
    
    objXMLHTTP.open "POST", sGFRLookupURL, False
    DebugPrint "Posting XML to " & sGFRLookupURL
    objXMLHTTP.send objXML
    DebugPrint "response: " & objXMLHTTP.responseText
    
    objXML.loadXML (objXMLHTTP.responseText)
    
    If objXML.parseError.errorCode <> 0 Then
        DebugPrint "Error in return XML, " & objXMLHTTP.responseText
        Exit Function
    End If
    
    Set objNode = objXML.firstChild.selectSingleNode("ret_code")
    
    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (ret_code), " & objXML.xml
        Exit Function
    End If

    If objNode.Text <> 0 Then
        Set objNode = objXML.firstChild.selectSingleNode("ret_message")

        If objNode Is Nothing Then
            DebugPrint "Lookup list values returned invalid XML (ret_message), " & objXML.xml
        Else
            DebugPrint "Error occured in retrieving lookup value, " & objNode.Text
        End If
        Exit Function
    End If
    
    Set objNodes = objXML.firstChild.selectNodes("values")
    
    If objNodes Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (values), " & objXML.xml
        Exit Function
    End If
    
    Debug.Print objNodes.length
    
    Set objNode = objXML.firstChild.selectSingleNode("./values/row/field/name[. = 'Client Name']").parentNode.selectSingleNode("value")

    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (value), " & objXML.xml
        Exit Function
    End If
    GetCustomerName = objNode.Text

End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub DebugPrint(strMessage)

    If (DEBUG_MODE XOr 1) = (DEBUG_MODE - 1) Then
        LogToFile strMessage
    End If

    If (DEBUG_MODE XOr 2) = (DEBUG_MODE - 2) Then
        MsgBox strMessage
        'LogToFile strMessage
    End If

End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub LogToFile(strMessage)

    Dim objFSO, objTStream

    On Error Resume Next

    Set objFSO = CreateObject("Scripting.FileSystemObject")
    Set objTStream = objFSO.OpenTextFile("C:\Program Files (x86)\GoFileRoom\GFRFileImporter\Log\immGFRPDFImport " & year(now) & "-" & month(now) & ".log", 8, True)
    Call objTStream.WriteLine(Now & ": " & strMessage)
    objTStream.Close

    Err.Clear
	
End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Function CData(ByVal strValue)	'As String
    CData = "<![CDATA[" & strValue & "]]>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function Quotes(ByVal strValue)	'As String
    Quotes = """" & strValue & """"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function BuildFieldNd(ByVal strIdx, ByVal strValue)	'As String
    BuildFieldNd = "<field name=" & Quotes(strIdx) & ">" & cData(strValue) & "</field>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************