CONST DEBUG_MODE = 1    'Valid options: 1 (log to file)
CONST TEST_MODE = 0     'Valid options: 0 (off) / 1 (on)

Function GenIdxXML(strIN_Path, strIN_FileName)
On Error Resume Next  

    'VARIABLE DECLARATION
    Dim strClientID, strClientName, strFileSection, strDocumentType, strDescrip, strPeriodEnd, strYear, strDocDate
    Dim strFileName

    'VARIABLE ASSIGNMENT
    strDocumentType = "TAX RETURNS"
    strPeriodEnd = "12-31"
    strFileName = strIN_FileName
    arrFileName = split(strFileName, "_")


    'VALID FILE CHECK
    If ubound(arrFileName) < 2 Then
        DebugPrint "**********************************************************************"
        DebugPrint "Invalid File Name: " & strFileName & ". Not enough parameters."
        DebugPrint "**********************************************************************"
        GenIdxXML = BuildErrorXML (3, "Invalid File Name. Not enough parameters.")
        Exit function
    End If

    If len(arrFileName(0)) <> 3 Then
        DebugPrint "**********************************************************************"
        DebugPrint "Invalid File Name: " & strFileName & ". Underscore missing at 4th position."
        DebugPrint "**********************************************************************"
        GenIdxXML = BuildErrorXML (1, "Invalid File Name. '_' missing at 4th position.")
        Exit function
    End If
    
    If Not IsNumeric(Left(strFilename, 2)) Then
        DebugPrint "**********************************************************************"
        DebugPrint "Invalid File Name: " & strFileName & ". First two characters should be numeric."
        DebugPrint "**********************************************************************"
        GenIdxXML = BuildErrorXML (2, "Invalid File Name. First two characters should be numeric.")
        Exit function
    End If 

    'FILE SECTION ASSGINMENT
    strFileSection = GetFileSection(UCase(right(arrFileName(0), 1)))

    If strFileSection = "" Then
        DebugPrint "**********************************************************************"
        DebugPrint "Invalid File Name: " & strFileName & ". File Section is invalid."
        DebugPrint "**********************************************************************"
        GenIdxXML = BuildErrorXML (4, "Invalid File Name. File Section is invalid.")
        Exit function
    End If



    'DOCUMENT TYPE ASSIGNMENT
    'Static - See Variable Assignment

    'CLIENT NUMBER & DESCRIPTION ASSIGNMENT
    if (((left(arrFileName(1), 4) = right(arrFileName(1), 4)) and len(arrFileName(1)) = 4) or ((left(arrFileName(1), 2) = right(arrFileName(1), 2)) and len(arrFileName(1)) = 2)) then
        DebugPrint "**********************************************************************"
        DebugPrint "Invalid File Name: " & strFileName & ". Client number is missing."
        DebugPrint "**********************************************************************"
        GenIdxXML = BuildErrorXML (5, "Invalid File Name. Client number is missing.")
        Exit function
     end if

    
    if (UCase(right(arrFileName(1), 4)) = "ACCT") then
       	strDescripPre = "ACCT "
    elseif (UCase(right(arrFileName(1), 4)) = "GOVT") then
        strDescripPre = "GOVT " 
    elseif (UCase(right(arrFileName(1), 4)) = "CLNT") then
        strDescripPre = "CLNT "
    elseif (UCase(right(arrFileName(1), 2)) = "K1") then
        strDescripPre = "K1 "
    end if

    for x = 2 to (UBound(arrFileName))
        strDescrip = strDescrip + arrFileName(x)
        if x < UBound(arrFileName) then
            strDescrip = strDescrip + "_"
        end if
    next

    if (len(strDescrip) - instrrev(strDescrip, ".") <= 4) then
	strDescrip = left(strDescrip, instrrev(strDescrip, ".")-1)
    end if

    strClientID = left(arrFileName(1), (len(arrFileName(1))-len(trim(strDescripPre))))
    strDescrip = UCase(strDescripPre) + UCase(strDescrip)
   
    'CLIENT NAME ASSIGNMENT
    strCustomerName = GetCustomerName(strClientID)
    
    'PERIOD END ASSIGNMENT
    'Static - See Variable Assignment

    'DOCUMENT DATE ASSIGNMENT
    'Static - See Variable Assignment

    'YEAR ASSIGNMENT
    strYear = "20" + left(arrFileName(0), 2)
 
  
        
    If Trim(strClientID) <> "" Then
                 
        'DEBUG INFO
        DebugPrint "File Name = " & strIN_FileName 'objFile.Name
        DebugPrint "Client ID = " & strClientID
        DebugPrint "Customer Name = " & strCustomerName
        DebugPrint "File Section = " & strFileSection
        DebugPrint "Document Type = " & strDocumentType
        DebugPrint "Description = " & strDescrip
        DebugPrint "Period End = " & strPeriodEnd
        DebugPrint "Year = " & strYear
       
        strIdxXML = "<indexes><retcode>0</retcode><retmsg><![CDATA[]]></retmsg><index id=" & Quotes("1") & ">"
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NUMBER", strClientID) 
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NAME", strCustomerName) 
        strIdxXML = strIdxXML & BuildFieldNd("FILE SECTION", strFileSection)
        strIdxXML = strIdxXML & BuildFieldNd("DOCUMENT TYPE", strDocumentType) 
        strIdxXML = strIdxXML & BuildFieldNd("DESCRIPTION", strDescrip)
        strIdxXML = strIdxXML & BuildFieldNd("YEAR", strYear)
        strIdxXML = strIdxXML & BuildFieldNd("PERIOD END", strPeriodEnd)
        strIdxXML = strIdxXML & BuildFieldNd("DOCUMENT DATE", Replace(Date, "/", "-"))
        strIdxXML = strIdxXML & "</index></indexes>"

        DebugPrint "Index XML = " & strIdxXML

        If TEST_MODE <> 1 Then
            GenIdxXML = strIdxXML
        End If
    End If
End function
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function BuildErrorXML(ErrNumber, ErrDescription)
    BuildErrorXML = "<indexes><retcode>" & ErrNumber & "</retcode><retmsg><![CDATA[" & ErrDescription & "]]></retmsg><index/></indexes>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function GetFileSection(strPrefix)
    On Error Resume Next

    Select Case UCase(strPrefix)
    Case "I"
        GetFileSection = "1040 INDIVIDUAL TAX"    
    Case "C"
        GetFileSection = "1120 CORPORATE TAX"
    Case "S"
        GetFileSection = "1120S CORPORATE TAX"
    Case "P"
        GetFileSection = "1065 PARTNERSHIP TAX"
    Case "Y"
        GetFileSection = "709 GIFT TAX"
    Case "F"
        GetFileSection = "1041 FIDUCIARY TAX"
    Case "X"
        GetFileSection = "990 NOT-FOR-PROFIT"
    'Case "Z"
        'GetFileSection = "5500 EMPLOYEE BENEFIT PLAN"
    End Select
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function GetCustomerName(sClientID)
On Error Resume Next

    Dim objXMLHTTP, objXML, sXml, objNode, objNodes

    Set objXMLHTTP = CreateObject("MSXML2.XMLHTTP.6.0")
    sXml = "<gfr_lookup>" & _
           "<uid><![CDATA[" & sUserName & "]]></uid>" & _
           "<pwd><![CDATA[" & sPassword & "]]></pwd>" & _
           "<drawer_id>" & strGFRDrawerID & "</drawer_id>" & _
           "<fields multi_value='0' count='1'>" & _
           "<field>" & _
           "<name><![CDATA[Client Number]]></name>" & _
           "<value><![CDATA[" & sClientID & "]]> </value>" & _
           "</field>" & _
           "<field>" & _
           "<name><![CDATA[Client Name]]></name>" & _
           "<value><![CDATA[*]]> </value>" & _
           "</field>" & _
           "</fields>" & _
           "</gfr_lookup>"

    DebugPrint "**********************************************************************"
    DebugPrint "**********************************************************************"
    DebugPrint "Sending XML: " & sXml
    
    Set objXML = CreateObject("MSXML2.DOMDocument.6.0")

    objXML.loadXML (sXml)
    objXMLHTTP.open "POST", sGFRLookupURL, False

    DebugPrint "Posting XML to " & sGFRLookupURL

    objXMLHTTP.send objXML

    DebugPrint "response: " & objXMLHTTP.responseText
    
    objXML.loadXML (objXMLHTTP.responseText)

    If objXML.parseError.errorCode <> 0 Then
        DebugPrint "Error in return XML, " & objXMLHTTP.responseText
        Exit Function
    End If
    
    Set objNode = objXML.firstChild.selectSingleNode("ret_code")

    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (ret_code), " & objXML.xml
        Exit Function
    End If

    If objNode.Text <> 0 Then
        Set objNode = objXML.firstChild.selectSingleNode("ret_message")

        If objNode Is Nothing Then
            DebugPrint "Lookup list values returned invalid XML (ret_message), " & objXML.xml
        Else
            DebugPrint "Error occured in retrieving lookup value, " & objNode.Text
        End If
        Exit Function
    End If
    
    Set objNodes = objXML.firstChild.selectNodes("values")

    If objNodes Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (values), " & objXML.xml
        Exit Function
    End If

    Debug.Print objNodes.length

    Set objNode = objXML.firstChild.selectSingleNode("./values/row/field/name[. = 'Client Name']").parentNode.selectSingleNode("value")

    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (value), " & objXML.xml
        Exit Function
    End If

    GetCustomerName = objNode.Text
    
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************	
Sub DebugPrint(strMessage)
    If (DEBUG_MODE XOr 1) = (DEBUG_MODE - 1) Then
        LogToFile strMessage
    End If

    If (DEBUG_MODE XOr 2) = (DEBUG_MODE - 2) Then
        MsgBox strMessage
    End If
End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************	
Sub LogToFile(strMessage)
    Dim objFSO, objTStream

    On Error Resume Next

    Set objFSO = CreateObject("Scripting.FileSystemObject")
    Set objTStream = objFSO.OpenTextFile("C:\Program Files\GoFileRoom\GFRFileImporter\Log\immGFRPDFImport " & year(now) & "-" & month(now) & ".log", 8, True)
    Call objTStream.WriteLine(Now & ": " & strMessage)
    objTStream.Close

    Err.Clear
End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Function CData(ByVal strValue)	'As String
    CData = "<![CDATA[" & strValue & "]]>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function Quotes(ByVal strValue)	'As String
    Quotes = """" & strValue & """"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function BuildFieldNd(ByVal strIdx, ByVal strValue)	'As String
    BuildFieldNd = "<field name=" & Quotes(strIdx) & ">" & cData(strValue) & "</field>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************