'UltraTax FileImporter Script 2015
'1/19/2015 Date Correction 
'3/21/2016 Added ArchiveParticipantPackage for 5500 returns C7L
'2/5/2019 Addedd ActionRequiredK1Package,TaxSourceDocuments,InputScreens DYT
'8/14/2019 Added PreparerCopyParticipantPackage for 5500 V4J
'11/1/2019 Added GovernmentCopyK1Package and GovernmentCopyTaxReturn for UT19 updates V4J
'1/22/2020 Added 1040SR entity for UT19 update V4J
'2/9/2022 Added 5500EZ entity for UT2021 update V4J

CONST DEBUG_MODE = 1    'Valid options: 1 (log to file)
CONST TEST_MODE = 0     'Valid options: 0 (off) / 1 (on)


Function GenIdxXML(strIN_Path, strIN_FileName)
    On Error Resume Next   

    'VARIABLE DECLARATION
    Dim strFileName, strFilePath
    Dim strClientID, strClientName, strFileSection, strDocumentType 'Used to declare index strings
    Dim strDescription, strPeriodEnd, strYear, strDocumentDate      'Used to declare index strings
    Dim filenamearray,validatecitycty,amendedflag, datearray

    '***********************************************************************************************
    'Set this based on what firm has in Setup>Office Configuration>Print options>PDF file opitons
    'X to mark as not used
    'Must have at least 1-4 
        '***********************************************************************************************
    'Required
    CLIENT_ID_POSITION = "1"
    CLIENT_NAME_POSITION = "2"
    'Required
    ENTITY_TYPE_POSITION = "3"
    'Required
    DOCUMENT_NAME_POSITION = "4"
    'or get from client year end
    TAX_YEAR_POSITION = "5"
    'Required
    CLIENT_YEAR_END_POSITION = "6"
    'current date created
    DATE_PRINTED_POSITION = "7"
    'K1_RECIPIENT_NAME= After Client Year End
    'Y=box checked N =Box not checked
    'If checked set to After Entity type
    SEPARATE_PDF_FED_STATE= "Y"
    '***********************************************************************************************
    'End Updates needed from user
    '***********************************************************************************************

    'This is will Validate that the required positions are set
    If CLIENT_ID_POSITION= "X" or ENTITY_TYPE_POSITION= "X" or DOCUMENT_NAME_POSITION= "X" or  CLIENT_YEAR_END_POSITION = "X" then
            DebugPrint "**********************************************************************"
            DebugPrint "Please verify all required items have a position"
            DebugPrint "**********************************************************************"
            WScript.Quit        
   End if
      
    If SEPARATE_PDF_FED_STATE = "Y" and (Instr(strIN_FileName,"Organizer") = 0 and Instr(strIN_FileName,"K1Package")=0 and Instr(strIN_FileName,"ParticipantPackage")=0 )then
       DOCUMENT_NAME_POSITION =     DOCUMENT_NAME_POSITION + 1
       TAX_YEAR_POSITION = TAX_YEAR_POSITION + 1
       CLIENT_YEAR_END_POSITION = CLIENT_YEAR_END_POSITION + 1
       DATE_PRINTED_POSITION = DATE_PRINTED_POSITION +1
    End if


    'VARIABLE ASSIGNMENT
    strDocumentType = "TAX RETURN"
    
    strFileName = left(strIN_FileName, instrrev(strIN_FileName,".") -1 )

    'strFileName =       strIN_FileName		'objFile.Name - get the name and path from the objFile object
    strFilePath =       strIN_Path			'objFile.Path - get the name and path from the objFile object
    'This will create an array of the filename
	filenamearray = split(strFileName, "_")
    
    '****************************************************************************************
    'Required  Assignments
    '****************************************************************************************
    'CLIENT NUMBER ASSIGNMENT
    strClientID = filenamearray(CLIENT_ID_POSITION-1)
     'FILE SECTION ASSGINMENT
    strFileSection= filenamearray(ENTITY_TYPE_POSITION-1)
    strFileSection = GetFileSection(strFileSection)
    'Document Name ASSIGNMENT
	strDocumentNAME =   filenamearray(DOCUMENT_NAME_POSITION - 1)
    'Period End ASSIGNMENT
    strPeriodEnd =      Left(replace(filenamearray(CLIENT_YEAR_END_POSITION-1),"-","/"),5)

    
    '****************************************************************************************
    'Optional Assignments
    '****************************************************************************************
    If DATE_PRINTED_POSITION = "X" then
            strDocumentDate =   Date
    Else
            strDocumentDate =  filenamearray(DATE_PRINTED_POSITION-1)
            datearray=split(strDocumentDate, "-")
            strDocumentDate= datearray(0) & "/" & datearray(1) & "/20" & datearray(2)
                 
   end if
  
     'YEAR ASSIGNMENT
     If TAX_YEAR_POSITION = "X" then
     'Check date for year
             stryear= "20" & right(filenamearray(CLIENT_YEAR_END_POSITION-1),2)
     else
    		stryear= Right(filenamearray(TAX_YEAR_POSITION-1),4)
     End if

     d= Instr(strDocumentNAME,"Amended")
     Amendedflag="FALSE"
     IF d = 1 then
     Amendedflag="TRUE"
     Strdocumentname=replace(strdocumentname,"Amended","")
     ENd if
'    'DESCRIPTION ASSIGNMENT
		If strDocumentName= "ArchiveTaxReturn" Then
        'Combined 
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription= "Client Copy"
                 If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            ElseIf SEPARATE_PDF_FED_STATE= "Y" then 
                If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Client Copy"
                Else
                    strDescription= "Client Copy - " & filenamearray(ENTITY_TYPE_POSITION)
                End if
                If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
                end if
            End if
		ElseIf strDocumentName= "PreparerCopyK1Package"  Then
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription = "Preparer Copy - K1 Package for " & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then


                strDescription = "Preparer Copy - K1 Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            End if
		ElseIf strDocumentName= "PreparerCopyTaxReturn" Then
            If SEPARATE_PDF_FED_STATE= "N" then
			    strDescription= "Preparer Copy"
                     If Amendedflag="TRUE" then
                         strDescription= strDescription & " - Amended"
                     End if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                 If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Preparer Copy"
                Else
                    strDescription= "Preparer Copy - " & filenamearray(ENTITY_TYPE_POSITION)
                End if
               If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
                End if
             End if
          ElseIf strDocumentName= "Extension" Then
            If SEPARATE_PDF_FED_STATE= "N" then
			    strDescription= "Extension"
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                 If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Extension"
                Else
                    strDescription= "Extension - " & filenamearray(ENTITY_TYPE_POSITION)
                End if
           End if
		ElseIf strDocumentName= "ArchiveK1Package"  Then
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription = "Client Copy - K1 Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                strDescription = "Client Copy - K1 Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            End if
	'added 3/21/2016
            ElseIf strDocumentName= "ArchiveParticipantPackage"  Then
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription = "Client Copy - Participant Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                strDescription = "Client Copy - Participant Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            End if
    'added 8/14/2019
            ElseIf strDocumentName= "PreparerCopyParticipantPackage"  Then
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription = "Preparer Copy - Participant Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                strDescription = "Preparer Copy - Participant Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            End if
	'added 11/01/2019
		ElseIf strDocumentName= "GovernmentCopyK1Package"  Then
            If SEPARATE_PDF_FED_STATE= "N" then
                strDescription = "Government Copy - K1 Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                strDescription = "Government Copy - K1 Package for "  & filenamearray(ubound(filenamearray)) 
                If Amendedflag="TRUE" then
                     strDescription= strDescription & " - Amended"
                 end if
            End if
            		ElseIf strDocumentName= "GovernmentCopyTaxReturn" Then
            If SEPARATE_PDF_FED_STATE= "N" then
			    strDescription= "Government Copy"
                     If Amendedflag="TRUE" then
                         strDescription= strDescription & " - Amended"
                     End if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                 If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Government Copy"
                Else
                    strDescription= "Government Copy - " & filenamearray(ENTITY_TYPE_POSITION)
                End if
               If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
                End if
             End if
          ElseIf strDocumentName= "Extension" Then
            If SEPARATE_PDF_FED_STATE= "N" then
			    strDescription= "Extension"
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                 If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Extension"
                Else
                    strDescription= "Extension - " & filenamearray(ENTITY_TYPE_POSITION)
                End if
           End if
        ElseIf strDocumentName= "TaxReturn-ActionRequired" Then
            If SEPARATE_PDF_FED_STATE= "N" then
			    strDescription= "Client Copy - Action Required"
                     If Amendedflag="TRUE" then
                         strDescription= strDescription & " - Amended"
                     End if
            Elseif SEPARATE_PDF_FED_STATE= "Y"  Then
                 If Checkcityorstate(filenamearray(ENTITY_TYPE_POSITION)) = "Fail" Then
                strDescription= "Client Copy - Action Required"
                Else
                    strDescription= "Client Copy - " & filenamearray(ENTITY_TYPE_POSITION) & "  - Action Required"
                End if
                If Amendedflag="TRUE"  then
                strDescription= strDescription & " - Amended"
                End if
            end if
        ElseIf strDocumentName= "Organizer" Then
			strDescription= "Organizer"
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
        ElseIf strDocumentName= "Organizer-ActionRequired" Then
			strDescription= "Organizer - Action Required"
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
        ElseIf strDocumentName= "ActionRequiredK1Package" Then
			strDescription= "K1 Package - " & filenamearray(ubound(filenamearray))
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
         ElseIf strDocumentName= "TaxSourceDocuments" Then
			strDescription= "Tax Source Documents"
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
           ElseIf strDocumentName= "InputScreens" Then
			strDescription= "Input Screens"
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
           ElseIf strDocumentName= "PublicInspectionTaxDocuments" Then
			strDescription= "Public Inspection"
            If Amendedflag="TRUE" then
                strDescription= strDescription & " - Amended"
            End if
		End if
	

  'CLIENT NAME ASSIGNMENT
    'LOGIC: Returned from GoFileRoom
    strCustomerName = GetCustomerName(strClientID)


    If Trim(strClientID) <> "" Then
        'XML file name
        strNewFileName = Cstr(strGFRDrawerID) & strDelimiter & strcustomername & strDelimiter & strclientid & strDelimiter & strFileSection & strDelimiter & strDocumentType & strDelimiter & strDescription & strDelimiter & strYear & strDelimiter & strPeriodEnd & strDelimiter & strDocumentDate
        		
        'Assign indexing to XML file
        strIdxXML = "<indexes><retcode>0</retcode><retmsg><![CDATA[]]></retmsg><index id=""" & 1 & """>"
		strIdxXML = strIdxXML & BuildFieldNd("CLIENT NAME", strCustomerName) 
        strIdxXML = strIdxXML & BuildFieldNd("CLIENT NUMBER", strClientID) 
        strIdxXML = strIdxXML & BuildFieldNd("File Section", strFileSection) 
        strIdxXML = strIdxXML & BuildFieldNd("Document Type", strDocumentType) 
        strIdxXML = strIdxXML & BuildFieldNd("Description", strDescription)
        strIdxXML = strIdxXML & BuildFieldNd("Year", strYear) 
        strIdxXML = strIdxXML & BuildFieldNd("Period End", strPeriodEnd)
        strIdxXML = strIdxXML & BuildFieldNd("Document Date", strDocumentDate)
		strIdxXML = strIdxXML & "</index></indexes>"
        
        'DEBUG INFO
        DebugPrint "**********************************************************************"
        DebugPrint "File Path = "       & strIN_Path
        DebugPrint "Customer Name = "   & strCustomerName
        DebugPrint "Client Number = "   & strClientID
        DebugPrint "File Section = "    & strFileSection
        DebugPrint "Document Type = "   & strDocumentType
        DebugPrint "Description = "     & strDescription
        DebugPrint "Year = "            & strYear
        DebugPrint "Period End = "      & strPeriodEnd
        DebugPrint "Document Date = "   & strDocumentDate
        DebugPrint "Index XML = "       & strIdxXML
        DebugPrint "New File Name = "   & strNewFileName

        If TEST_MODE <> 1 then
		    GenIdxXML = strIdxXML
		End If
    End If

End function	
'*****************************************************************************************************************
'*****************************************************************************************************************	
Function BuildErrorXML(ErrNumber, ErrDescription)
    BuildErrorXML = "<indexes><retcode>" & ErrNumber & "</retcode><retmsg><![CDATA[" & ErrDescription & "]]></retmsg><index/></indexes>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function Checkcityorstate(Vaildatecitystate)

If Vaildatecitystate <> "ArchiveTaxReturn" or Vaildatecitystate <> "PreparerCopyK1Package" or Vaildatecitystate <> "PreparerCopyTaxReturn" or Vaildatecitystate <> "ArchiveK1Package" or Vaildatecitystate <> "TaxReturn-ActionRequired" or Vaildatecitystate <> "Organizer"  or Validatecitystate <> "Extension" then

Else 
  Checkcityorstate="Fail"  
 End if

End function

Function GetCustomerName(sClientID)
    On Error Resume Next
    Dim objXMLHTTP
    Dim objXML
    Dim sXml
    Dim objNode
    Dim objNodes

    Set objXMLHTTP = CreateObject("MSXML2.XMLHTTP.6.0")
    sXml = "<gfr_lookup>" & _
                "<uid><![CDATA[" & sUserName & "]]></uid>" & _
                "<pwd><![CDATA[" & sPassword & "]]></pwd>" & _
                "<drawer_id>" & strGFRDrawerID & "</drawer_id>" & _
                "<fields multi_value='0' count='1'>" & _
                    "<field>" & _
                        "<name><![CDATA[Client Number]]></name>" & _
                        "<value><![CDATA[" & sClientID & "]]> </value>" & _
                    "</field>" & _
                    "<field>" & _
                        "<name><![CDATA[Client Name]]></name>" & _
                        "<value><![CDATA[*]]> </value>" & _
                    "</field>" & _
                "</fields>" & _
            "</gfr_lookup>"

    DebugPrint "Sending XML: " & sXml
    
    Set objXML = CreateObject("MSXML2.DOMDocument.6.0")
    objXML.loadXML (sXml)
    
    objXMLHTTP.open "POST", sGFRLookupURL, False
    DebugPrint "Posting XML to " & sGFRLookupURL
    objXMLHTTP.send objXML
    DebugPrint "response: " & objXMLHTTP.responseText
    
    objXML.loadXML (objXMLHTTP.responseText)

    If objXML.parseError.errorCode <> 0 Then
        DebugPrint "Error in return XML, " & objXMLHTTP.responseText
        Exit Function
    End If
    
    Set objNode = objXML.firstChild.selectSingleNode("ret_code")
    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (ret_code), " & objXML.xml
        Exit Function
    End If

    If objNode.Text <> 0 Then
        Set objNode = objXML.firstChild.selectSingleNode("ret_message")
        If objNode Is Nothing Then
            DebugPrint "Lookup list values returned invalid XML (ret_message), " & objXML.xml
        Else
            DebugPrint "Error occured in retrieving lookup value, " & objNode.Text
        End If
    
        Exit Function
    End If
    
    Set objNodes = objXML.firstChild.selectNodes("values")

    If objNodes Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (values), " & objXML.xml
        Exit Function
    End If

    Debug.Print objNodes.length

    Set objNode = objXML.firstChild.selectSingleNode("./values/row/field/name[. = 'Client Name']").parentNode.selectSingleNode("value")
    If objNode Is Nothing Then
        DebugPrint "Lookup list values returned invalid XML (value), " & objXML.xml
        Exit Function
    End If

    GetCustomerName = objNode.Text
	
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub DebugPrint(strMessage)

    If (DEBUG_MODE XOr 1) = (DEBUG_MODE - 1) Then
        LogToFile strMessage
    End If

    If (DEBUG_MODE XOr 2) = (DEBUG_MODE - 2) Then
        MsgBox strMessage
        'LogToFile strMessage
    End If

End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Sub LogToFile(strMessage)

    Dim objFSO, objTStream

    On Error Resume Next

    Set objFSO = CreateObject("Scripting.FileSystemObject")
    Set objTStream = objFSO.OpenTextFile("C:\Program Files (x86)\GoFileRoom\GFRFileImporter\Log\immGFRPDFImport " & year(now) & "-" & month(now) & ".log", 8, True)
    Call objTStream.WriteLine(Now & ": " & strMessage)
    objTStream.Close

    Err.Clear
	
End Sub
'*****************************************************************************************************************
'*****************************************************************************************************************
Function CData(ByVal strValue)	'As String
    CData = "<![CDATA[" & strValue & "]]>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function Quotes(ByVal strValue)	'As String
    Quotes = """" & strValue & """"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function BuildFieldNd(ByVal strIdx, ByVal strValue)	'As String
    BuildFieldNd = "<field name=" & Quotes(strIdx) & ">" & cData(strValue) & "</field>"
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************
Function GetFileSection(strPrefix)

   On Error Resume Next
   
     Select Case strPrefix
    Case "1040"
        GetFileSection = "1040 INDIVIDUAL TAX"    
    Case "1120"
        GetFileSection = "1120 CORPORATE TAX"
    Case "1065"
        GetFileSection = "1065 PARTNERSHIP TAX"
    Case "1041"
        GetFileSection = "1041 FIDUCIARY TAX"
    Case "990"
        GetFileSection = "990 NOT-FOR-PROFIT"
    Case "5500"
        GetFileSection = "5500 EMPLOYEE BENEFIT PLAN"
    Case "709"
        GetFileSection = "709 GIFT TAX"
    Case "706"
        GetFileSection = "706 ESTATE TAX"
	Case "1040PR"
		GetFileSection = "1040 INDIVIDUAL TAX"  
	Case "1040SS"
		GetFileSection = "1040 INDIVIDUAL TAX"  
    Case "1040SR"
		GetFileSection = "1040 INDIVIDUAL TAX"
	Case "1040NR"
		GetFileSection = "1040 INDIVIDUAL TAX" 
	Case "1120C"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120S"
		GetFileSection = "1120S CORPORATE TAX"
	Case "1120COOP"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120F"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120H"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120DISC"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120POL"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120PC"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120REIT"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120SF"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120CCON"
		GetFileSection = "1120 CORPORATE TAX"
	Case "1120SCON"
		GetFileSection = "1120S CORPORATE TAX"
	Case "1065B"
		GetFileSection = "1065 PARTNERSHIP TAX"
	Case "8865"
		GetFileSection = "1065 PARTNERSHIP TAX" 
	Case "990E"
		GetFileSection = "990 NOT-FOR-PROFIT"
	Case "990PF"
		GetFileSection = "990 NOT-FOR-PROFIT"
	Case "5500EZ"
		GetFileSection = "5500 EMPLOYEE BENEFIT PLAN"
    Case "5500SF"
		GetFileSection = "5500 EMPLOYEE BENEFIT PLAN"
	Case "2290"
		GetFileSection = "1120S CORPORATE TAX"
    End Select
End Function
'*****************************************************************************************************************
'*****************************************************************************************************************