@echo off
REM Renaming/Deleting the Digita and Thomson Reuters Profile folders. 2022-01-26 v1.1
REM This Tool is for clearing Digita profile data
REM Created by Rob Freemantle BSc(Hons), Digita IT Support
: - - - - - CHANGE SETTINGS HERE - - - - -
REM showCommentary applies to information only messages. When the script does something, it still shows it.
REM Useful for tracking the path through the script.
SET showCommentary=0
: - - - - - DO NOT EDIT ANYTHING BELOW THIS LINE - - - - -

FOR /f "tokens=2 delims= " %%D in ('echo %DATE:/=%') do SET DATEN=%%D
set todaysdate=%DATE:/=%
set changesMade=0

echo.
echo    Renaming/Deleting the Digita and Thomson Reuters Profile folders
echo    ================================================================
echo.
echo    Script will rename the profile folder on first run, on subsequent runs
echo    on the same day will delete the folders. 
echo.
Echo    Local User PT and CT Registry keys also deleted. 
echo.   
echo    Ensure all Digita and Thomson Reuters applications are closed
echo    before running this.
echo.
Pause
echo.

IF EXIST "%appdata%\Digita-%todaysdate%\" (
	 if %showCommentary%==1 Echo  - Todays Backup Folder Exists "%appdata%\Digita-%todaysdate%\"
	 IF EXIST "%appdata%\Digita" (
		Echo  * Deleting "%appdata%\Digita\"
		cd %appdata%
		del "Digita" /Q 
		rd "Digita" /Q /S
		IF NOT EXIST "%appdata%\Digita" set changesMade=1
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%appdata%\Digita\"
	)
) ELSE IF NOT EXIST "%appdata%\Digita-%todaysdate%\" (
	if %showCommentary%==1 Echo  - Todays Backup Folder DOES NOT Exist "%appdata%\Digita-%todaysdate%\"
    IF EXIST "%appdata%\Digita" (
		cd %appdata%
		Echo  * Renaming "%appdata%\Digita\"
		ren "Digita" "Digita-%todaysdate%"
		IF NOT EXIST "%appdata%\Digita" set changesMade=1
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%appdata%\Digita\"
	)
)
IF EXIST "%appdata%\Thomson Reuters-%todaysdate%\" (
	if %showCommentary%==1 Echo  - Todays Backup Folder Exists "%appdata%\Thomson Reuters-%todaysdate%\"
	IF EXIST "%appdata%\Thomson Reuters" (
		Echo  * Deleting "%appdata%\Thomson Reuters\"
		cd %appdata%
		del "Thomson Reuters" /Q
		rd "Thomson Reuters" /Q /S
		IF NOT EXIST "%appdata%\Thomson Reuters" set changesMade=1
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%appdata%\Thomson Reuters\"
	)
) ELSE IF NOT EXIST "%appdata%\Thomson Reuters-%todaysdate%\" (
	if %showCommentary%==1 Echo  - Todays Backup Folder DOES NOT Exist "%appdata%\Thomson Reuters-%todaysdate%\"
	IF EXIST "%appdata%\Thomson Reuters" (
		Echo  * Renaming "%appdata%\Thomson Reuters\"
		cd %appdata%
		ren "Thomson Reuters" "Thomson Reuters-%todaysdate%"
		IF NOT EXIST "%appdata%\Thomson Reuters" set changesMade=1 
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%appdata%\Thomson Reuters\"
	)
)

IF EXIST "%localappdata%\Digita-%todaysdate%\" (
	if %showCommentary%==1 ECHO  - Todays Backup Folder Exists "%localappdata%\Digita-%todaysdate%\" 
	IF EXIST "%localappdata%\Digita\" (
		Echo  * Deleting "%localappdata%\Digita\"
		cd %localappdata%
		del "Digita" /Q
		rd "Digita" /Q /S
		IF NOT EXIST "%localappdata%\Digita\" set changesMade=1
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%localappdata%\Digita\"
	)
) ELSE IF NOT EXIST "%localappdata%\Digita-%todaysdate%\" (
	if %showCommentary%==1 ECHO  - Todays Backup Folder DOES NOT Exist "%localappdata%\Digita-%todaysdate%\"
	IF EXIST "%localappdata%\Digita\" (
		Echo  * Renaming "%localappdata%\Digita\"
		cd %localappdata%
		ren "Digita" "Digita-%todaysdate%" 
		IF NOT EXIST "%localappdata%\Digita\" set changesMade=1	
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%localappdata%\Digita\"
	)
)
IF EXIST "%localappdata%\Thomson Reuters-%todaysdate%\" (
	if %showCommentary%==1 ECHO  - Todays Backup Folder Exists "%localappdata%\Thomson Reuters-%todaysdate%\" 
	IF EXIST "%localappdata%\Thomson Reuters" (
		Echo  * Deleting "%localappdata%\Thomson Reuters\"
		cd %localappdata%
		del "Thomson Reuters" /Q
		rd "Thomson Reuters" /Q /S
		IF NOT EXIST "%localappdata%\Thomson Reuters" set changesMade=1
	)
) ELSE IF NOT EXIST "%localappdata%\Thomson Reuters-%todaysdate%\" (
	if %showCommentary%==1 ECHO  - Todays Backup Folder DOES NOT Exist "%localappdata%\Thomson Reuters-%todaysdate%\" 
	IF EXIST "%localappdata%\Thomson Reuters" (
		Echo  * Renaming "%localappdata%\Thomson Reuters\"
		cd %localappdata%
		ren "Thomson Reuters" "Thomson Reuters-%todaysdate%" 
		IF NOT EXIST "%localappdata%\Thomson Reuters" set changesMade=1	
	) ELSE (
		if %showCommentary%==1 Echo  - Profile Folder DOES NOT Exist "%localappdata%\Thomson Reuters\"
	)
)	
rem Clearing Digita Profile Data

rem Deleting User Digita Registry

reg query "HKCU\SOFTWARE\Digita Open Systems" >nul 2>nul
if %ERRORLEVEL% EQU 0 (
	echo  * Deleting HKCU Digita Registry Key.
	reg delete "HKCU\SOFTWARE\Digita Open Systems" /f
	reg query "HKCU\SOFTWARE\Digita Open Systems" >nul 2>nul
	if %ERRORLEVEL% EQU 1 set changesMade=1
) else (
	if %showCommentary%==1 echo  - HKCU Digita Registry Key does not exist.
)


@echo off
echo.
echo    ************
echo    Profile and Registry clean-up completed. 
call :changesMade
echo    Please press a key to continue, then try the applications again.
echo    ************
echo.
pause
exit

:changesMade
IF %changesMade%==0 (
	echo.
	echo    * No changes have been made.
	echo.
) else (
	echo.
	echo    * Changes have been made
	echo.
)
exit /b
