<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:tmc="http://www.deloitte.co.uk/tmc/xslt" xmlns:ns1="http://www.ros.ie/schemas/formct1/v24/" xmlns="http://www.w3.org/1999/xhtml">

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>

  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <style type="text/css">
          x {} /* This line is required for some unknown reason otherwise IE does not correctly apply the first style when in a CDATA block*/
          body { font-family: Verdana, Helvetica, Arial, san-serif; font-size: 10pt; }
          h1 { font-size: 9pt; }
          table.header th  { font-weight: bold; text-align: left; }
          table.calculation { width: 100%; }
          table.calculation th { background-color: #99D9EA; font-weight: bold; text-align: left; }
          table.calculation td.subtotal  { font-weight: bold; }
          table.calculation td { padding: 5px; }
          table.calculation td.total  { font-weight: bold; }
          table.calculation td.title { font-weight: bold; text-align: left; }
          td.amount { text-align: right; }
          table.taxatrate { width: 100%; }
        </style>
        <!-- <title>
          <xsl:choose>
             <xsl:when test="ns1:Acknowledgement/ns1:SummaryCalculation">
              CT1 - Return Summary From <xsl:value-of select="ns1:Acknowledgement/ns1:SummaryCalculation/@periodstart"/> to <xsl:value-of select="/ns1:SummaryCalculation/@periodend"/>
            </xsl:when>
            <xsl:otherwise>
              CT1 - Validation Errors
            </xsl:otherwise>
          </xsl:choose>
        </title> -->
      </head>
      <body>
        <xsl:apply-templates select="ns1:Acknowledgement" />
        <xsl:apply-templates select="ns1:Errors" />
      </body>
    </html>
  </xsl:template>

  <!-- Template to use if there is an error -->
  <xsl:template match="ns1:Errors">
    <h1>
      Validation Results on <xsl:value-of select="tmc:CurrentDateTime()" />
    </h1>
    <p>One or more errors were found when validating your submission. The error(s) are displayed below for you to review.</p>
    <table class="calculation">
      <tr>
        <th>Description</th>
      </tr>
      <xsl:for-each select="ns1:Error">
        <tr>
          <td>
            <xsl:value-of select="@message" />
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <!-- Template to use for a successful response -->
  <xsl:template match="ns1:Acknowledgement[ns1:SummaryCalculation]">
    <h1>
      CT1 - Return Summary From <xsl:value-of select="ns1:SummaryCalculation/@periodstart"/> to <xsl:value-of select="ns1:SummaryCalculation/@periodend"/>
    </h1>
    <table class="header">
      <tr>
        <th>Reference Number:</th>
        <td>
          <xsl:value-of select="ns1:SummaryCalculation/@referencenumber"/>
        </td>
      </tr>
      <tr>
        <th>Company Name:</th>
        <td>
          <xsl:value-of select="ns1:SummaryCalculation/@companyname"/>
        </td>
      </tr>
      <tr>
        <th>Date:</th>
        <td>
          <xsl:value-of select="tmc:CurrentDateTime()"/>
        </td>
      </tr>
      <tr>
        <th>Currency:</th>
        <td>
          <xsl:choose>
            <xsl:when test="ns1:SummaryCalculation/@currency = 'E'">Euro</xsl:when>
            <xsl:when test="not(ns1:SummaryCalculation/@currency)">Euro</xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="ns1:SummaryCalculation/@currency"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
	  <tr>
        <th>Notice Number:</th>
        <td>
          <xsl:value-of select="NoticeNumber"/>
        </td>
      </tr>
    </table>
    <!-- Assessable to Corporation Tax - Amounts Accessible -->
    <table class="calculation">
      <tr>
        <th colspan="2">Assessment to Corporation tax - Amounts Assessable</th>
      </tr>
      <tr>
        <td>Trading Income</td>
        <td class="amount">
          <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@tradingIncome)"/>
        </td>
      </tr>
      <tr>
        <td>Excepted Trade Income</td>
        <td class="amount">
          <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@exceptedTradeIncome)"/>
        </td>
      </tr>
      <tr>
        <td>Shipping Income</td>
        <td class="amount">
          <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@shippingIncome)"/>
        </td>
      </tr>
      <xsl:if test="ns1:SummaryCalculation/@tonnageIncome">
        <tr>
          <td>Tonnage Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@tonnageIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@rentalIncome">
        <tr>
          <td>Rental Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@rentalIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@interestIncome">
        <tr>
          <td>Interest Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@interestIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@foreignIncome">
        <tr>
          <td>Foreign Dividend Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@foreignIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@otherForeignIncome">
        <tr>
          <td>Other Foreign Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@otherForeignIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@foreignLifePolicyPayment">
        <tr>
          <td>Foreign Life Policy Payment</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@foreignLifePolicyPayment)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@foreignLifePolicyGain">
        <tr>
          <td>Foreign Life Policy Gain</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@foreignLifePolicyGain)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@offshoreFundIncome">
        <tr>
          <td>Offshore Fund Income</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@offshoreFundIncome)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@offshoreFundGain">
        <tr>
          <td>Offshore Fund Gain</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@offshoreFundGain)" />
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="ns1:SummaryCalculation/@capitalGains">
        <tr>
          <td>Capital Gains</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@capitalGains)"/>
          </td>
        </tr>
      </xsl:if>
      <tr>
        <td class="total">Total Income</td>
        <td class="amount">
          <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalIncome)"/>
        </td>
      </tr>
    </table>
    <!-- Deductions - Amounts Allowed -->
    <xsl:if test="ns1:SummaryCalculation/@totalDeductions">
      <table class="calculation">
        <tr>
          <th colspan="2">Deductions - Amounts Allowed</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@losses">
          <tr>
            <td>Losses</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@losses)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@charges">
          <tr>
            <td>Charges</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@charges)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@groupRelief">
          <tr>
            <td>Group Relief</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@groupRelief)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@managementExpenses">
          <tr>
            <td>Management Expenses</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@managementExpenses)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@otherDeductions">
          <tr>
            <td>Other Deductions</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@otherDeductions)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@excessCapitalAllowances">
          <tr>
            <td>Excess Capital Allowances</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@excessCapitalAllowances)" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td class="total">Total Deductions</td>
          <td class="total amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalDeductions)" />
          </td>
        </tr>
      </table>
    </xsl:if>
    <!-- Taxable Income after deductions-->
    <xsl:if test="ns1:SummaryCalculation/@total">
      <table class="calculation" >
        <tr>
          <th colspan="2">Taxable Income after Deductions</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@taxableIncome">
          <tr>
            <td>Taxable Income</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@taxableIncome)"/>
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td colspan="2" style="padding: 0px;">
            <table class="calculation">
              <xsl:for-each select="ns1:SummaryCalculation/ns1:TaxableIncomeAtRate">
                <xsl:if test="@taxIdentifier != 'NOA'">
                  <tr>
                    <td>
                      <xsl:choose>
                        <xsl:when test="@taxIdentifier='19069'">Corporation Tax @</xsl:when>
                        <xsl:when test="@taxIdentifier='19070'">Tonnage Tax @</xsl:when>
                        <xsl:when test="@taxIdentifier='19071'">Tax on Chargeable Gain @</xsl:when>
                        <xsl:when test="@taxIdentifier='19073'">Tax on Invested Gain @</xsl:when>
                        <xsl:otherwise>Other Tax @</xsl:otherwise>
                      </xsl:choose>
                      <xsl:value-of select="@percentageRate" />%
                    </td>
                    <td class="amount">
                      <xsl:value-of select="tmc:FormatAmount(@amountChargeableAtRate)" /> @ <xsl:value-of select="@percentageRate" />% =
                    </td>
                    <td class="amount">
                      <xsl:value-of select="tmc:FormatAmount(@amountPayableAtRate)" />
                    </td>
                  </tr>
                </xsl:if>
              </xsl:for-each>
            </table>
          </td>
        </tr>
        <tr>
          <td class="total">Total</td>
          <td class="total amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@total)"/>
          </td>
        </tr>
      </table>
    </xsl:if>
    <!-- Reliefs - Amounts Allowed -->
    <xsl:if test="ns1:SummaryCalculation/@totalReliefs">
      <table class="calculation">
        <tr>
          <th colspan="2">Reliefs - Amounts Allowed</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@manufacturingRelief">
          <tr>
            <td>Manufacturing Relief</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@manufacturingRelief)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@manufactTradeDeductions">
          <tr>
            <td>Manufacturing Trade Deductions</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@manufactTradeDeductions)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@otherTradeDeductions">
          <tr>
            <td>Other Trade Deductions</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@otherTradeDeductions)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@doubleTaxationRelief">
          <tr>
            <td>Double Taxation Relief</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@doubleTaxationRelief)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@otherReliefs">
          <tr>
            <td>Other Reliefs</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@otherReliefs)" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td>Total Reliefs</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalReliefs)" />
          </td>
        </tr>
      </table>
    </xsl:if>
    <!-- Surcharges -->
    <xsl:if test="ns1:SummaryCalculation/@totalSurcharges">
      <table class="calculation">
        <tr>
          <th colspan="2">Surcharges</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@surchargesSection440">
          <tr>
            <td>Surcharge Section 440</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@surchargesSection440)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@surchargesSection441">
          <tr>
            <td>Surcharge Section 441</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@surchargesSection441)" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td>Total Surcharges</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalSurcharges)" />
          </td>
        </tr>
      </table>
    </xsl:if>
    <!-- Total Credits - Amounts Allowed -->
    <xsl:if test="ns1:SummaryCalculation/@totalCredits">
      <table class="calculation">
        <tr>
          <th colspan="2">Total credits - Amounts Allowed</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@grossWithholdingTax">
          <tr>
            <td>Gross Withholding Tax</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@grossWithholdingTax)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@otherIncTaxBorneIncRec">
          <tr>
            <td>Other Income Tax Bourne on Income Received</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@otherIncTaxBorneIncRec)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@rAndDCredit">
          <tr>
            <td>R&amp;D Credit</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@rAndDCredit)" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td class="total">Total Credits</td>
          <td class="total amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalCredits)" />
          </td>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@rAndDRepayableCredits">
          <tr>
            <td class="total">R&amp;D Repayable Credits</td>
            <td class="total amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@rAndDRepayableCredits)" />
            </td>
          </tr>
        </xsl:if>
      </table>
    </xsl:if>
    <!-- Payable Under Deduction of Tax - Amounts Allowed -->
    <xsl:if test="ns1:SummaryCalculation/@totalTax">
      <table class="calculation">
        <tr>
          <th colspan="2">Payable Under Deduction of Tax - Amounts Allowed</th>
        </tr>
        <xsl:if test="ns1:SummaryCalculation/@amtPayUnderDeductOfTax">
          <tr>
            <td>Amount Payable Under Deduction of Tax</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@amtPayUnderDeductOfTax)" />
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@taxReliefAtSource">
          <tr>
            <td>Tax Relief at Source</td>
            <td class="amount">
              <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@taxReliefAtSource)" />
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td>Total Tax</td>
          <td class="amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalTax)" />
          </td>
        </tr>
      </table>
    </xsl:if>
    <!-- Grand Total -->
    <table class="calculation">
      <tr>
        <xsl:if test="ns1:SummaryCalculation/@totalAmountRepayable">
          <td class="total">Total Repayable</td>
          <td class="total amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalAmountRepayable)" />
          </td>
        </xsl:if>
        <xsl:if test="ns1:SummaryCalculation/@totalAmountPayable">
          <td class="total">Total Payable</td>
          <td class="total amount">
            <xsl:value-of select="tmc:FormatAmount(ns1:SummaryCalculation/@totalAmountPayable)"/>
          </td>
        </xsl:if>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
