<?xml version="1.0" encoding="UTF-8"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:ct="http://www.govtalk.gov.uk/taxation/CT/5" xmlns:dsig="http://www.w3.org/2000/09/xmldsig#" xmlns:hd="http://www.govtalk.gov.uk/CM/envelope" xmlns:date="http://exslt.org/dates-and-times" xmlns:dyn="http://exslt.org/dynamic" xmlns:exsl="http://exslt.org/common" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:math="http://exslt.org/math" xmlns:random="http://exslt.org/random" xmlns:regexp="http://exslt.org/regular-expressions" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:set="http://exslt.org/sets" xmlns:str="http://exslt.org/strings" ct:dummy-for-xmlns="" dsig:dummy-for-xmlns="" exclude-result-prefixes="sch iso" extension-element-prefixes="date dyn math random regexp set str exsl" hd:dummy-for-xmlns="" version="1.0">

<!--PHASES-->


<!--PROLOG-->
<dsl-rim:namespaceMappings xmlns:dsl-rim="http://www.decisionsoft.com/rim" xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse">
    <dsl-rim:namespaceMapping prefix="hd" uri="http://www.govtalk.gov.uk/CM/envelope"/>
    <dsl-rim:namespaceMapping prefix="dsig" uri="http://www.w3.org/2000/09/xmldsig#"/>
    <dsl-rim:namespaceMapping prefix="ct" uri="http://www.govtalk.gov.uk/taxation/CT/5"/>
  </dsl-rim:namespaceMappings>
  <axsl:output xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" indent="yes" method="xml" omit-xml-declaration="no" standalone="yes"/>

<!--KEYS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-FULL-PATH-->
<axsl:template match="*" mode="schematron-get-full-path">
    <axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
    <axsl:text>/</axsl:text>
    <axsl:variable name="nsuri" select="namespace-uri()"/>
    <axsl:variable xmlns:dsl-rim="http://www.decisionsoft.com/rim" name="prefix" select="document('')//dsl-rim:namespaceMapping[@uri=$nsuri]/@prefix"/>
    <axsl:if test="$prefix">
      <axsl:value-of select="concat($prefix,':')"/>
    </axsl:if>
    <axsl:value-of select="local-name()"/>
    <axsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
    <axsl:text>[</axsl:text>
    <axsl:value-of select="1+ $preceding"/>
    <axsl:text>]</axsl:text>
  </axsl:template>
  <axsl:template match="@*" mode="schematron-get-full-path">
    <axsl:apply-templates mode="schematron-get-full-path" select="parent::*"/>
    <axsl:text>/@</axsl:text>
    <axsl:variable name="nsuri" select="namespace-uri()"/>
    <axsl:variable xmlns:dsl-rim="http://www.decisionsoft.com/rim" name="prefix" select="document('')//dsl-rim:namespaceMapping[@uri=$nsuri]/@prefix"/>
    <axsl:if test="$prefix">
      <axsl:value-of select="concat($prefix,':')"/>
    </axsl:if>
    <axsl:value-of select="local-name()"/>
  </axsl:template>
  <!--Strip characters-->
  <axsl:template match="text()" priority="-1"/>

<!--SCHEMA METADATA-->
<axsl:template match="/">
    <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errors">
      <axsl:apply-templates mode="M4" select="/"/>
      <axsl:apply-templates mode="M5" select="/"/>
      <axsl:apply-templates mode="M6" select="/"/>
      <axsl:apply-templates mode="M7" select="/"/>
      <axsl:apply-templates mode="M8" select="/"/>
      <axsl:apply-templates mode="M9" select="/"/>
      <axsl:apply-templates mode="M10" select="/"/>
      <axsl:apply-templates mode="M11" select="/"/>
      <axsl:apply-templates mode="M12" select="/"/>
      <axsl:apply-templates mode="M13" select="/"/>
      <axsl:apply-templates mode="M14" select="/"/>
      <axsl:apply-templates mode="M15" select="/"/>
      <axsl:apply-templates mode="M16" select="/"/>
      <axsl:apply-templates mode="M17" select="/"/>
      <axsl:apply-templates mode="M18" select="/"/>
      <axsl:apply-templates mode="M19" select="/"/>
      <axsl:apply-templates mode="M20" select="/"/>
      <axsl:apply-templates mode="M21" select="/"/>
      <axsl:apply-templates mode="M22" select="/"/>
      <axsl:apply-templates mode="M23" select="/"/>
      <axsl:apply-templates mode="M24" select="/"/>
      <axsl:apply-templates mode="M25" select="/"/>
      <axsl:apply-templates mode="M26" select="/"/>
      <axsl:apply-templates mode="M27" select="/"/>
      <axsl:apply-templates mode="M28" select="/"/>
      <axsl:apply-templates mode="M29" select="/"/>
      <axsl:apply-templates mode="M30" select="/"/>
      <axsl:apply-templates mode="M31" select="/"/>
      <axsl:apply-templates mode="M32" select="/"/>
      <axsl:apply-templates mode="M33" select="/"/>
      <axsl:apply-templates mode="M34" select="/"/>
      <axsl:apply-templates mode="M35" select="/"/>
      <axsl:apply-templates mode="M36" select="/"/>
      <axsl:apply-templates mode="M37" select="/"/>
      <axsl:apply-templates mode="M38" select="/"/>
      <axsl:apply-templates mode="M39" select="/"/>
      <axsl:apply-templates mode="M40" select="/"/>
      <axsl:apply-templates mode="M41" select="/"/>
      <axsl:apply-templates mode="M42" select="/"/>
      <axsl:apply-templates mode="M43" select="/"/>
      <axsl:apply-templates mode="M44" select="/"/>
      <axsl:apply-templates mode="M45" select="/"/>
      <axsl:apply-templates mode="M46" select="/"/>
      <axsl:apply-templates mode="M47" select="/"/>
      <axsl:apply-templates mode="M48" select="/"/>
      <axsl:apply-templates mode="M49" select="/"/>
      <axsl:apply-templates mode="M50" select="/"/>
      <axsl:apply-templates mode="M51" select="/"/>
      <axsl:apply-templates mode="M52" select="/"/>
      <axsl:apply-templates mode="M53" select="/"/>
      <axsl:apply-templates mode="M54" select="/"/>
      <axsl:apply-templates mode="M55" select="/"/>
      <axsl:apply-templates mode="M56" select="/"/>
      <axsl:apply-templates mode="M57" select="/"/>
      <axsl:apply-templates mode="M58" select="/"/>
      <axsl:apply-templates mode="M59" select="/"/>
      <axsl:apply-templates mode="M60" select="/"/>
      <axsl:apply-templates mode="M61" select="/"/>
      <axsl:apply-templates mode="M62" select="/"/>
      <axsl:apply-templates mode="M63" select="/"/>
      <axsl:apply-templates mode="M64" select="/"/>
      <axsl:apply-templates mode="M65" select="/"/>
      <axsl:apply-templates mode="M66" select="/"/>
      <axsl:apply-templates mode="M67" select="/"/>
      <axsl:apply-templates mode="M68" select="/"/>
      <axsl:apply-templates mode="M69" select="/"/>
      <axsl:apply-templates mode="M70" select="/"/>
      <axsl:apply-templates mode="M71" select="/"/>
      <axsl:apply-templates mode="M72" select="/"/>
      <axsl:apply-templates mode="M73" select="/"/>
      <axsl:apply-templates mode="M74" select="/"/>
      <axsl:apply-templates mode="M75" select="/"/>
      <axsl:apply-templates mode="M76" select="/"/>
      <axsl:apply-templates mode="M77" select="/"/>
      <axsl:apply-templates mode="M78" select="/"/>
      <axsl:apply-templates mode="M79" select="/"/>
      <axsl:apply-templates mode="M80" select="/"/>
      <axsl:apply-templates mode="M81" select="/"/>
      <axsl:apply-templates mode="M82" select="/"/>
      <axsl:apply-templates mode="M83" select="/"/>
      <axsl:apply-templates mode="M84" select="/"/>
      <axsl:apply-templates mode="M85" select="/"/>
      <axsl:apply-templates mode="M86" select="/"/>
      <axsl:apply-templates mode="M87" select="/"/>
      <axsl:apply-templates mode="M88" select="/"/>
      <axsl:apply-templates mode="M89" select="/"/>
      <axsl:apply-templates mode="M90" select="/"/>
      <axsl:apply-templates mode="M91" select="/"/>
      <axsl:apply-templates mode="M92" select="/"/>
      <axsl:apply-templates mode="M93" select="/"/>
      <axsl:apply-templates mode="M94" select="/"/>
      <axsl:apply-templates mode="M95" select="/"/>
      <axsl:apply-templates mode="M96" select="/"/>
      <axsl:apply-templates mode="M97" select="/"/>
      <axsl:apply-templates mode="M98" select="/"/>
      <axsl:apply-templates mode="M99" select="/"/>
      <axsl:apply-templates mode="M100" select="/"/>
      <axsl:apply-templates mode="M101" select="/"/>
      <axsl:apply-templates mode="M102" select="/"/>
      <axsl:apply-templates mode="M103" select="/"/>
      <axsl:apply-templates mode="M104" select="/"/>
      <axsl:apply-templates mode="M105" select="/"/>
      <axsl:apply-templates mode="M106" select="/"/>
      <axsl:apply-templates mode="M107" select="/"/>
      <axsl:apply-templates mode="M108" select="/"/>
      <axsl:apply-templates mode="M109" select="/"/>
      <axsl:apply-templates mode="M110" select="/"/>
      <axsl:apply-templates mode="M111" select="/"/>
      <axsl:apply-templates mode="M112" select="/"/>
      <axsl:apply-templates mode="M113" select="/"/>
      <axsl:apply-templates mode="M114" select="/"/>
      <axsl:apply-templates mode="M115" select="/"/>
      <axsl:apply-templates mode="M116" select="/"/>
      <axsl:apply-templates mode="M117" select="/"/>
      <axsl:apply-templates mode="M118" select="/"/>
      <axsl:apply-templates mode="M119" select="/"/>
      <axsl:apply-templates mode="M120" select="/"/>
      <axsl:apply-templates mode="M121" select="/"/>
      <axsl:apply-templates mode="M122" select="/"/>
      <axsl:apply-templates mode="M123" select="/"/>
      <axsl:apply-templates mode="M124" select="/"/>
      <axsl:apply-templates mode="M125" select="/"/>
      <axsl:apply-templates mode="M126" select="/"/>
      <axsl:apply-templates mode="M127" select="/"/>
      <axsl:apply-templates mode="M128" select="/"/>
      <axsl:apply-templates mode="M129" select="/"/>
      <axsl:apply-templates mode="M130" select="/"/>
      <axsl:apply-templates mode="M131" select="/"/>
      <axsl:apply-templates mode="M132" select="/"/>
      <axsl:apply-templates mode="M133" select="/"/>
      <axsl:apply-templates mode="M134" select="/"/>
      <axsl:apply-templates mode="M135" select="/"/>
      <axsl:apply-templates mode="M136" select="/"/>
      <axsl:apply-templates mode="M137" select="/"/>
      <axsl:apply-templates mode="M138" select="/"/>
      <axsl:apply-templates mode="M139" select="/"/>
      <axsl:apply-templates mode="M140" select="/"/>
      <axsl:apply-templates mode="M141" select="/"/>
      <axsl:apply-templates mode="M142" select="/"/>
      <axsl:apply-templates mode="M143" select="/"/>
      <axsl:apply-templates mode="M144" select="/"/>
      <axsl:apply-templates mode="M145" select="/"/>
      <axsl:apply-templates mode="M146" select="/"/>
      <axsl:apply-templates mode="M147" select="/"/>
      <axsl:apply-templates mode="M148" select="/"/>
      <axsl:apply-templates mode="M149" select="/"/>
      <axsl:apply-templates mode="M150" select="/"/>
      <axsl:apply-templates mode="M151" select="/"/>
      <axsl:apply-templates mode="M152" select="/"/>
      <axsl:apply-templates mode="M153" select="/"/>
      <axsl:apply-templates mode="M154" select="/"/>
      <axsl:apply-templates mode="M155" select="/"/>
      <axsl:apply-templates mode="M156" select="/"/>
      <axsl:apply-templates mode="M157" select="/"/>
      <axsl:apply-templates mode="M158" select="/"/>
      <axsl:apply-templates mode="M159" select="/"/>
      <axsl:apply-templates mode="M160" select="/"/>
      <axsl:apply-templates mode="M161" select="/"/>
      <axsl:apply-templates mode="M162" select="/"/>
      <axsl:apply-templates mode="M163" select="/"/>
      <axsl:apply-templates mode="M164" select="/"/>
      <axsl:apply-templates mode="M165" select="/"/>
      <axsl:apply-templates mode="M166" select="/"/>
      <axsl:apply-templates mode="M167" select="/"/>
      <axsl:apply-templates mode="M168" select="/"/>
      <axsl:apply-templates mode="M169" select="/"/>
      <axsl:apply-templates mode="M170" select="/"/>
      <axsl:apply-templates mode="M171" select="/"/>
      <axsl:apply-templates mode="M172" select="/"/>
      <axsl:apply-templates mode="M173" select="/"/>
      <axsl:apply-templates mode="M174" select="/"/>
      <axsl:apply-templates mode="M175" select="/"/>
      <axsl:apply-templates mode="M176" select="/"/>
      <axsl:apply-templates mode="M177" select="/"/>
      <axsl:apply-templates mode="M178" select="/"/>
      <axsl:apply-templates mode="M179" select="/"/>
      <axsl:apply-templates mode="M180" select="/"/>
      <axsl:apply-templates mode="M181" select="/"/>
      <axsl:apply-templates mode="M182" select="/"/>
      <axsl:apply-templates mode="M183" select="/"/>
      <axsl:apply-templates mode="M184" select="/"/>
      <axsl:apply-templates mode="M185" select="/"/>
      <axsl:apply-templates mode="M186" select="/"/>
      <axsl:apply-templates mode="M187" select="/"/>
      <axsl:apply-templates mode="M188" select="/"/>
      <axsl:apply-templates mode="M189" select="/"/>
      <axsl:apply-templates mode="M190" select="/"/>
      <axsl:apply-templates mode="M191" select="/"/>
      <axsl:apply-templates mode="M192" select="/"/>
      <axsl:apply-templates mode="M193" select="/"/>
      <axsl:apply-templates mode="M194" select="/"/>
      <axsl:apply-templates mode="M195" select="/"/>
      <axsl:apply-templates mode="M196" select="/"/>
      <axsl:apply-templates mode="M197" select="/"/>
      <axsl:apply-templates mode="M198" select="/"/>
      <axsl:apply-templates mode="M199" select="/"/>
      <axsl:apply-templates mode="M200" select="/"/>
      <axsl:apply-templates mode="M201" select="/"/>
      <axsl:apply-templates mode="M202" select="/"/>
      <axsl:apply-templates mode="M203" select="/"/>
      <axsl:apply-templates mode="M204" select="/"/>
      <axsl:apply-templates mode="M205" select="/"/>
      <axsl:apply-templates mode="M206" select="/"/>
      <axsl:apply-templates mode="M207" select="/"/>
      <axsl:apply-templates mode="M208" select="/"/>
      <axsl:apply-templates mode="M209" select="/"/>
      <axsl:apply-templates mode="M210" select="/"/>
      <axsl:apply-templates mode="M211" select="/"/>
      <axsl:apply-templates mode="M212" select="/"/>
      <axsl:apply-templates mode="M213" select="/"/>
      <axsl:apply-templates mode="M214" select="/"/>
      <axsl:apply-templates mode="M215" select="/"/>
      <axsl:apply-templates mode="M216" select="/"/>
      <axsl:apply-templates mode="M217" select="/"/>
      <axsl:apply-templates mode="M218" select="/"/>
      <axsl:apply-templates mode="M219" select="/"/>
      <axsl:apply-templates mode="M220" select="/"/>
      <axsl:apply-templates mode="M221" select="/"/>
      <axsl:apply-templates mode="M222" select="/"/>
      <axsl:apply-templates mode="M223" select="/"/>
      <axsl:apply-templates mode="M224" select="/"/>
      <axsl:apply-templates mode="M225" select="/"/>
      <axsl:apply-templates mode="M226" select="/"/>
      <axsl:apply-templates mode="M227" select="/"/>
      <axsl:apply-templates mode="M228" select="/"/>
      <axsl:apply-templates mode="M229" select="/"/>
      <axsl:apply-templates mode="M230" select="/"/>
      <axsl:apply-templates mode="M231" select="/"/>
      <axsl:apply-templates mode="M232" select="/"/>
      <axsl:apply-templates mode="M233" select="/"/>
      <axsl:apply-templates mode="M234" select="/"/>
      <axsl:apply-templates mode="M235" select="/"/>
      <axsl:apply-templates mode="M236" select="/"/>
      <axsl:apply-templates mode="M237" select="/"/>
      <axsl:apply-templates mode="M238" select="/"/>
      <axsl:apply-templates mode="M239" select="/"/>
      <axsl:apply-templates mode="M240" select="/"/>
      <axsl:apply-templates mode="M241" select="/"/>
      <axsl:apply-templates mode="M242" select="/"/>
      <axsl:apply-templates mode="M243" select="/"/>
      <axsl:apply-templates mode="M244" select="/"/>
      <axsl:apply-templates mode="M245" select="/"/>
      <axsl:apply-templates mode="M246" select="/"/>
      <axsl:apply-templates mode="M247" select="/"/>
      <axsl:apply-templates mode="M248" select="/"/>
      <axsl:apply-templates mode="M249" select="/"/>
      <axsl:apply-templates mode="M250" select="/"/>
      <axsl:apply-templates mode="M251" select="/"/>
      <axsl:apply-templates mode="M252" select="/"/>
      <axsl:apply-templates mode="M253" select="/"/>
      <axsl:apply-templates mode="M254" select="/"/>
      <axsl:apply-templates mode="M255" select="/"/>
      <axsl:apply-templates mode="M256" select="/"/>
      <axsl:apply-templates mode="M257" select="/"/>
      <axsl:apply-templates mode="M258" select="/"/>
      <axsl:apply-templates mode="M259" select="/"/>
      <axsl:apply-templates mode="M260" select="/"/>
      <axsl:apply-templates mode="M261" select="/"/>
      <axsl:apply-templates mode="M262" select="/"/>
      <axsl:apply-templates mode="M263" select="/"/>
      <axsl:apply-templates mode="M264" select="/"/>
      <axsl:apply-templates mode="M265" select="/"/>
      <axsl:apply-templates mode="M266" select="/"/>
      <axsl:apply-templates mode="M267" select="/"/>
      <axsl:apply-templates mode="M268" select="/"/>
      <axsl:apply-templates mode="M269" select="/"/>
      <axsl:apply-templates mode="M270" select="/"/>
      <axsl:apply-templates mode="M271" select="/"/>
      <axsl:apply-templates mode="M272" select="/"/>
      <axsl:apply-templates mode="M273" select="/"/>
      <axsl:apply-templates mode="M274" select="/"/>
      <axsl:apply-templates mode="M275" select="/"/>
      <axsl:apply-templates mode="M276" select="/"/>
      <axsl:apply-templates mode="M277" select="/"/>
      <axsl:apply-templates mode="M278" select="/"/>
      <axsl:apply-templates mode="M279" select="/"/>
      <axsl:apply-templates mode="M280" select="/"/>
      <axsl:apply-templates mode="M281" select="/"/>
      <axsl:apply-templates mode="M282" select="/"/>
      <axsl:apply-templates mode="M283" select="/"/>
      <axsl:apply-templates mode="M284" select="/"/>
      <axsl:apply-templates mode="M285" select="/"/>
      <axsl:apply-templates mode="M286" select="/"/>
      <axsl:apply-templates mode="M287" select="/"/>
      <axsl:apply-templates mode="M288" select="/"/>
      <axsl:apply-templates mode="M289" select="/"/>
      <axsl:apply-templates mode="M290" select="/"/>
      <axsl:apply-templates mode="M291" select="/"/>
      <axsl:apply-templates mode="M292" select="/"/>
      <axsl:apply-templates mode="M293" select="/"/>
      <axsl:apply-templates mode="M294" select="/"/>
      <axsl:apply-templates mode="M295" select="/"/>
      <axsl:apply-templates mode="M296" select="/"/>
      <axsl:apply-templates mode="M297" select="/"/>
      <axsl:apply-templates mode="M298" select="/"/>
      <axsl:apply-templates mode="M299" select="/"/>
      <axsl:apply-templates mode="M300" select="/"/>
      <axsl:apply-templates mode="M301" select="/"/>
      <axsl:apply-templates mode="M302" select="/"/>
      <axsl:apply-templates mode="M303" select="/"/>
      <axsl:apply-templates mode="M304" select="/"/>
      <axsl:apply-templates mode="M305" select="/"/>
      <axsl:apply-templates mode="M306" select="/"/>
      <axsl:apply-templates mode="M307" select="/"/>
      <axsl:apply-templates mode="M308" select="/"/>
      <axsl:apply-templates mode="M309" select="/"/>
      <axsl:apply-templates mode="M310" select="/"/>
      <axsl:apply-templates mode="M311" select="/"/>
      <axsl:apply-templates mode="M312" select="/"/>
      <axsl:apply-templates mode="M313" select="/"/>
      <axsl:apply-templates mode="M314" select="/"/>
      <axsl:apply-templates mode="M315" select="/"/>
      <axsl:apply-templates mode="M316" select="/"/>
      <axsl:apply-templates mode="M317" select="/"/>
      <axsl:apply-templates mode="M318" select="/"/>
      <axsl:apply-templates mode="M319" select="/"/>
      <axsl:apply-templates mode="M320" select="/"/>
      <axsl:apply-templates mode="M321" select="/"/>
      <axsl:apply-templates mode="M322" select="/"/>
      <axsl:apply-templates mode="M323" select="/"/>
      <axsl:apply-templates mode="M324" select="/"/>
      <axsl:apply-templates mode="M325" select="/"/>
      <axsl:apply-templates mode="M326" select="/"/>
      <axsl:apply-templates mode="M327" select="/"/>
      <axsl:apply-templates mode="M328" select="/"/>
      <axsl:apply-templates mode="M329" select="/"/>
      <axsl:apply-templates mode="M330" select="/"/>
      <axsl:apply-templates mode="M331" select="/"/>
      <axsl:apply-templates mode="M332" select="/"/>
      <axsl:apply-templates mode="M333" select="/"/>
      <axsl:apply-templates mode="M334" select="/"/>
      <axsl:apply-templates mode="M335" select="/"/>
      <axsl:apply-templates mode="M336" select="/"/>
      <axsl:apply-templates mode="M337" select="/"/>
      <axsl:apply-templates mode="M338" select="/"/>
      <axsl:apply-templates mode="M339" select="/"/>
      <axsl:apply-templates mode="M340" select="/"/>
      <axsl:apply-templates mode="M341" select="/"/>
      <axsl:apply-templates mode="M342" select="/"/>
      <axsl:apply-templates mode="M343" select="/"/>
      <axsl:apply-templates mode="M344" select="/"/>
      <axsl:apply-templates mode="M345" select="/"/>
      <axsl:apply-templates mode="M346" select="/"/>
      <axsl:apply-templates mode="M347" select="/"/>
      <axsl:apply-templates mode="M348" select="/"/>
      <axsl:apply-templates mode="M349" select="/"/>
      <axsl:apply-templates mode="M350" select="/"/>
      <axsl:apply-templates mode="M351" select="/"/>
      <axsl:apply-templates mode="M352" select="/"/>
      <axsl:apply-templates mode="M353" select="/"/>
      <axsl:apply-templates mode="M354" select="/"/>
      <axsl:apply-templates mode="M355" select="/"/>
      <axsl:apply-templates mode="M356" select="/"/>
      <axsl:apply-templates mode="M357" select="/"/>
      <axsl:apply-templates mode="M358" select="/"/>
      <axsl:apply-templates mode="M359" select="/"/>
      <axsl:apply-templates mode="M360" select="/"/>
      <axsl:apply-templates mode="M361" select="/"/>
      <axsl:apply-templates mode="M362" select="/"/>
      <axsl:apply-templates mode="M363" select="/"/>
      <axsl:apply-templates mode="M364" select="/"/>
      <axsl:apply-templates mode="M365" select="/"/>
      <axsl:apply-templates mode="M366" select="/"/>
      <axsl:apply-templates mode="M367" select="/"/>
      <axsl:apply-templates mode="M368" select="/"/>
      <axsl:apply-templates mode="M369" select="/"/>
      <axsl:apply-templates mode="M370" select="/"/>
      <axsl:apply-templates mode="M371" select="/"/>
      <axsl:apply-templates mode="M372" select="/"/>
      <axsl:apply-templates mode="M373" select="/"/>
      <axsl:apply-templates mode="M374" select="/"/>
      <axsl:apply-templates mode="M375" select="/"/>
      <axsl:apply-templates mode="M376" select="/"/>
      <axsl:apply-templates mode="M377" select="/"/>
      <axsl:apply-templates mode="M378" select="/"/>
      <axsl:apply-templates mode="M379" select="/"/>
      <axsl:apply-templates mode="M380" select="/"/>
      <axsl:apply-templates mode="M381" select="/"/>
      <axsl:apply-templates mode="M382" select="/"/>
      <axsl:apply-templates mode="M383" select="/"/>
      <axsl:apply-templates mode="M384" select="/"/>
      <axsl:apply-templates mode="M385" select="/"/>
      <axsl:apply-templates mode="M386" select="/"/>
      <axsl:apply-templates mode="M387" select="/"/>
      <axsl:apply-templates mode="M388" select="/"/>
      <axsl:apply-templates mode="M389" select="/"/>
      <axsl:apply-templates mode="M390" select="/"/>
      <axsl:apply-templates mode="M391" select="/"/>
      <axsl:apply-templates mode="M392" select="/"/>
      <axsl:apply-templates mode="M393" select="/"/>
      <axsl:apply-templates mode="M394" select="/"/>
      <axsl:apply-templates mode="M395" select="/"/>
      <axsl:apply-templates mode="M396" select="/"/>
      <axsl:apply-templates mode="M397" select="/"/>
      <axsl:apply-templates mode="M398" select="/"/>
      <axsl:apply-templates mode="M399" select="/"/>
      <axsl:apply-templates mode="M400" select="/"/>
      <axsl:apply-templates mode="M401" select="/"/>
      <axsl:apply-templates mode="M402" select="/"/>
      <axsl:apply-templates mode="M403" select="/"/>
      <axsl:apply-templates mode="M404" select="/"/>
      <axsl:apply-templates mode="M405" select="/"/>
      <axsl:apply-templates mode="M406" select="/"/>
      <axsl:apply-templates mode="M407" select="/"/>
      <axsl:apply-templates mode="M408" select="/"/>
      <axsl:apply-templates mode="M409" select="/"/>
      <axsl:apply-templates mode="M410" select="/"/>
      <axsl:apply-templates mode="M411" select="/"/>
      <axsl:apply-templates mode="M412" select="/"/>
      <axsl:apply-templates mode="M413" select="/"/>
      <axsl:apply-templates mode="M414" select="/"/>
      <axsl:apply-templates mode="M415" select="/"/>
      <axsl:apply-templates mode="M416" select="/"/>
      <axsl:apply-templates mode="M417" select="/"/>
      <axsl:apply-templates mode="M418" select="/"/>
      <axsl:apply-templates mode="M419" select="/"/>
      <axsl:apply-templates mode="M420" select="/"/>
      <axsl:apply-templates mode="M421" select="/"/>
      <axsl:apply-templates mode="M422" select="/"/>
      <axsl:apply-templates mode="M423" select="/"/>
      <axsl:apply-templates mode="M424" select="/"/>
      <axsl:apply-templates mode="M425" select="/"/>
      <axsl:apply-templates mode="M426" select="/"/>
      <axsl:apply-templates mode="M427" select="/"/>
      <axsl:apply-templates mode="M428" select="/"/>
      <axsl:apply-templates mode="M429" select="/"/>
      <axsl:apply-templates mode="M430" select="/"/>
      <axsl:apply-templates mode="M431" select="/"/>
      <axsl:apply-templates mode="M432" select="/"/>
      <axsl:apply-templates mode="M433" select="/"/>
      <axsl:apply-templates mode="M434" select="/"/>
      <axsl:apply-templates mode="M435" select="/"/>
      <axsl:apply-templates mode="M436" select="/"/>
      <axsl:apply-templates mode="M437" select="/"/>
      <axsl:apply-templates mode="M438" select="/"/>
      <axsl:apply-templates mode="M439" select="/"/>
      <axsl:apply-templates mode="M440" select="/"/>
      <axsl:apply-templates mode="M441" select="/"/>
      <axsl:apply-templates mode="M442" select="/"/>
      <axsl:apply-templates mode="M443" select="/"/>
      <axsl:apply-templates mode="M444" select="/"/>
      <axsl:apply-templates mode="M445" select="/"/>
      <axsl:apply-templates mode="M446" select="/"/>
      <axsl:apply-templates mode="M447" select="/"/>
      <axsl:apply-templates mode="M448" select="/"/>
      <axsl:apply-templates mode="M449" select="/"/>
      <axsl:apply-templates mode="M450" select="/"/>
      <axsl:apply-templates mode="M451" select="/"/>
      <axsl:apply-templates mode="M452" select="/"/>
      <axsl:apply-templates mode="M453" select="/"/>
      <axsl:apply-templates mode="M454" select="/"/>
      <axsl:apply-templates mode="M455" select="/"/>
      <axsl:apply-templates mode="M456" select="/"/>
      <axsl:apply-templates mode="M457" select="/"/>
      <axsl:apply-templates mode="M458" select="/"/>
      <axsl:apply-templates mode="M459" select="/"/>
      <axsl:apply-templates mode="M460" select="/"/>
      <axsl:apply-templates mode="M461" select="/"/>
      <axsl:apply-templates mode="M462" select="/"/>
      <axsl:apply-templates mode="M463" select="/"/>
      <axsl:apply-templates mode="M464" select="/"/>
      <axsl:apply-templates mode="M465" select="/"/>
      <axsl:apply-templates mode="M466" select="/"/>
      <axsl:apply-templates mode="M467" select="/"/>
      <axsl:apply-templates mode="M468" select="/"/>
      <axsl:apply-templates mode="M469" select="/"/>
      <axsl:apply-templates mode="M470" select="/"/>
      <axsl:apply-templates mode="M471" select="/"/>
      <axsl:apply-templates mode="M472" select="/"/>
      <axsl:apply-templates mode="M473" select="/"/>
      <axsl:apply-templates mode="M474" select="/"/>
      <axsl:apply-templates mode="M475" select="/"/>
      <axsl:apply-templates mode="M476" select="/"/>
      <axsl:apply-templates mode="M477" select="/"/>
      <axsl:apply-templates mode="M478" select="/"/>
      <axsl:apply-templates mode="M479" select="/"/>
      <axsl:apply-templates mode="M480" select="/"/>
      <axsl:apply-templates mode="M481" select="/"/>
      <axsl:apply-templates mode="M482" select="/"/>
      <axsl:apply-templates mode="M483" select="/"/>
      <axsl:apply-templates mode="M484" select="/"/>
      <axsl:apply-templates mode="M485" select="/"/>
      <axsl:apply-templates mode="M486" select="/"/>
      <axsl:apply-templates mode="M487" select="/"/>
      <axsl:apply-templates mode="M488" select="/"/>
      <axsl:apply-templates mode="M489" select="/"/>
      <axsl:apply-templates mode="M490" select="/"/>
      <axsl:apply-templates mode="M491" select="/"/>
      <axsl:apply-templates mode="M492" select="/"/>
      <axsl:apply-templates mode="M493" select="/"/>
      <axsl:apply-templates mode="M494" select="/"/>
      <axsl:apply-templates mode="M495" select="/"/>
      <axsl:apply-templates mode="M496" select="/"/>
      <axsl:apply-templates mode="M497" select="/"/>
      <axsl:apply-templates mode="M498" select="/"/>
      <axsl:apply-templates mode="M499" select="/"/>
      <axsl:apply-templates mode="M500" select="/"/>
      <axsl:apply-templates mode="M501" select="/"/>
      <axsl:apply-templates mode="M502" select="/"/>
      <axsl:apply-templates mode="M503" select="/"/>
      <axsl:apply-templates mode="M504" select="/"/>
      <axsl:apply-templates mode="M505" select="/"/>
      <axsl:apply-templates mode="M506" select="/"/>
      <axsl:apply-templates mode="M507" select="/"/>
      <axsl:apply-templates mode="M508" select="/"/>
      <axsl:apply-templates mode="M509" select="/"/>
      <axsl:apply-templates mode="M510" select="/"/>
      <axsl:apply-templates mode="M511" select="/"/>
      <axsl:apply-templates mode="M512" select="/"/>
      <axsl:apply-templates mode="M513" select="/"/>
      <axsl:apply-templates mode="M514" select="/"/>
      <axsl:apply-templates mode="M515" select="/"/>
      <axsl:apply-templates mode="M516" select="/"/>
      <axsl:apply-templates mode="M517" select="/"/>
      <axsl:apply-templates mode="M518" select="/"/>
      <axsl:apply-templates mode="M519" select="/"/>
      <axsl:apply-templates mode="M520" select="/"/>
      <axsl:apply-templates mode="M521" select="/"/>
      <axsl:apply-templates mode="M522" select="/"/>
      <axsl:apply-templates mode="M523" select="/"/>
      <axsl:apply-templates mode="M524" select="/"/>
      <axsl:apply-templates mode="M525" select="/"/>
      <axsl:apply-templates mode="M526" select="/"/>
      <axsl:apply-templates mode="M527" select="/"/>
      <axsl:apply-templates mode="M528" select="/"/>
      <axsl:apply-templates mode="M529" select="/"/>
      <axsl:apply-templates mode="M530" select="/"/>
      <axsl:apply-templates mode="M531" select="/"/>
      <axsl:apply-templates mode="M532" select="/"/>
      <axsl:apply-templates mode="M533" select="/"/>
      <axsl:apply-templates mode="M534" select="/"/>
      <axsl:apply-templates mode="M535" select="/"/>
      <axsl:apply-templates mode="M536" select="/"/>
      <axsl:apply-templates mode="M537" select="/"/>
      <axsl:apply-templates mode="M538" select="/"/>
      <axsl:apply-templates mode="M539" select="/"/>
      <axsl:apply-templates mode="M540" select="/"/>
      <axsl:apply-templates mode="M541" select="/"/>
      <axsl:apply-templates mode="M542" select="/"/>
      <axsl:apply-templates mode="M543" select="/"/>
      <axsl:apply-templates mode="M544" select="/"/>
      <axsl:apply-templates mode="M545" select="/"/>
      <axsl:apply-templates mode="M546" select="/"/>
      <axsl:apply-templates mode="M547" select="/"/>
      <axsl:apply-templates mode="M548" select="/"/>
      <axsl:apply-templates mode="M549" select="/"/>
      <axsl:apply-templates mode="M550" select="/"/>
      <axsl:apply-templates mode="M551" select="/"/>
      <axsl:apply-templates mode="M552" select="/"/>
      <axsl:apply-templates mode="M553" select="/"/>
      <axsl:apply-templates mode="M554" select="/"/>
      <axsl:apply-templates mode="M555" select="/"/>
      <axsl:apply-templates mode="M556" select="/"/>
      <axsl:apply-templates mode="M557" select="/"/>
      <axsl:apply-templates mode="M558" select="/"/>
      <axsl:apply-templates mode="M559" select="/"/>
      <axsl:apply-templates mode="M560" select="/"/>
      <axsl:apply-templates mode="M561" select="/"/>
      <axsl:apply-templates mode="M562" select="/"/>
      <axsl:apply-templates mode="M563" select="/"/>
      <axsl:apply-templates mode="M564" select="/"/>
      <axsl:apply-templates mode="M565" select="/"/>
      <axsl:apply-templates mode="M566" select="/"/>
      <axsl:apply-templates mode="M567" select="/"/>
      <axsl:apply-templates mode="M568" select="/"/>
      <axsl:apply-templates mode="M569" select="/"/>
    </axsl:variable>
    <err:ErrorResponse xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension" SchemaVersion="2.0">
      <axsl:copy-of select="$errors"/>
    </err:ErrorResponse>
  </axsl:template>

<!--SCHEMATRON PATTERNS-->


<!--PATTERN p2-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:IRheader/ct:Keys/ct:Key" mode="M4" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(/hd:GovTalkMessage/hd:GovTalkDetails/hd:Keys/hd:Key[@Type = current()/@Type and . = current()]) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">5005</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Keys in the GovTalkDetails do not match those in the IRheader.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Keys in the IR header must also exist in the GovTalk header with the same value</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M4" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M4" priority="-1"/>
  <axsl:template match="@*|node()" mode="M4" priority="-2">
    <axsl:apply-templates mode="M4" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p1-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:IRheader" mode="M5" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(ct:Keys/ct:Key) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">5004</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">At least one key must exist in the IRHeader</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>At least one key must exist</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M5" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M5" priority="-1"/>
  <axsl:template match="@*|node()" mode="M5" priority="-2">
    <axsl:apply-templates mode="M5" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p4-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:Reference" mode="M6" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../ct:IRheader/ct:Keys/ct:Key[@Type = &quot;UTR&quot; and . = current()]) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9100</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">There must be a Key element in the IRheader whose Type attribute is UTR and matches the tax reference in Box 3</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>There must be a Key element in the Irheader whose Type attribute is UTR and whose content is the same as the entry in [3].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M6" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M6" priority="-1"/>
  <axsl:template match="@*|node()" mode="M6" priority="-2">
    <axsl:apply-templates mode="M6" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p6-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer" mode="M7" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:SME"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9107</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 7 is completed then Box 6 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [7] is present then [6] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M7" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M7" priority="-1"/>
  <axsl:template match="@*|node()" mode="M7" priority="-2">
    <axsl:apply-templates mode="M7" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p7-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances" mode="M8" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.)) or ../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600G"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9108</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 125 must be completed if Box 8 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[125] should be present if [8] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M8" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M8" priority="-1"/>
  <axsl:template match="@*|node()" mode="M8" priority="-2">
    <axsl:apply-templates mode="M8" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p5-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:NorthernIreland" mode="M9" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9102</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 5, 6, 7 and 8 can only be completed if the To date in Box 35 is on or after 01 April 2050</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N009] is present then [35] must be on or after '2050-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:NItradingActivity) or ct:SME or ct:NIemployer or ct:SpecialCircumstances or ../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600G"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9014</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 125 must be completed if Box 5 is completed and Boxes 6, 7 and 8 are not completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[125] should be present if [5] is present but all of [6], [7] and [8] are absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M9" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M9" priority="-1"/>
  <axsl:template match="@*|node()" mode="M9" priority="-2">
    <axsl:apply-templates mode="M9" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p9-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:PeriodCovered/ct:From" mode="M10" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt; round(date:seconds(normalize-space(date:date())) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9103</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The return period From date in Box 30 must not be later than yesterday</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[30] cannot be later than yesterday</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M10" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M10" priority="-1"/>
  <axsl:template match="@*|node()" mode="M10" priority="-2">
    <axsl:apply-templates mode="M10" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p10-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:PeriodCovered/ct:To" mode="M11" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate(.,'-','') &gt;= translate(../ct:From,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9105</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The return period To date in Box 35 must be on or after the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[35] should be on or after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(date:date())) div 86400)) or ../../ct:CompanyType = 3"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9106</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The return period To date cannot be later than today unless the type of company is 3 (Company in liquidation which is chargeable at the main rate following the first period after liquidation)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[35] cannot be later than today unless [4] = 3.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M11" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M11" priority="-1"/>
  <axsl:template match="@*|node()" mode="M11" priority="-2">
    <axsl:apply-templates mode="M11" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p8-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyInformation/ct:PeriodCovered" mode="M12" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate(date:add(normalize-space(string(ct:To)),normalize-space('-P12M')),'-','') &lt; translate(ct:From,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9101</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The return period covered in Boxes 30 and 35 must not be longer than 12 months</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[35] should be less than 12 months after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M12" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M12" priority="-1"/>
  <axsl:template match="@*|node()" mode="M12" priority="-2">
    <axsl:apply-templates mode="M12" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p11-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:RegisteredAvoidanceScheme" mode="M13" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not ((.)) or ../../@ReturnType = 'amended' or ../ct:SupplementaryPages/ct:CT600J"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9109</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the return type is New then Box 140 must be completed if Box 65 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[140] must equal 'yes' if [65] equals 'yes' and [N003] does not equal 'amended'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M13" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M13" priority="-1"/>
  <axsl:template match="@*|node()" mode="M13" priority="-2">
    <axsl:apply-templates mode="M13" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p12-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:TransferPricing" mode="M14" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:Adjustment = 'yes' and ct:SME = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9110</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 70 and 75 cannot both be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise> [70] and [75] cannot both be 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M14" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M14" priority="-1"/>
  <axsl:template match="@*|node()" mode="M14" priority="-2">
    <axsl:apply-templates mode="M14" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p14-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:Accounts/ct:NoAccountsReason" mode="M15" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../ct:AttachedFiles/ct:XBRLsubmission/ct:Accounts) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9349</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">iXBRL Accounts are attached so 'No accounts reason' must not be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is present, then there must be no Accounts element as a child of [N107]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'Amendment - a/cs already submitted') or (../../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9115</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Amendment - accounts already submitted' cannot be used if the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] equals 'Amendment - a/cs already submitted' then [N003] must equal 'amended'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = &quot;PDF accounts attached with explanation&quot;) or (count(../../../ct:AttachedFiles/ct:Attachment[@Type='accounts']) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9971</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You must provide a set of PDF Accounts if 'No accounts reason' is completed with 'PDF accounts attached with explanation' </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is "PDF accounts attached with explanation", then there must be at least one instance of [N106] with type = 'accounts'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M15" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M15" priority="-1"/>
  <axsl:template match="@*|node()" mode="M15" priority="-2">
    <axsl:apply-templates mode="M15" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p13-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:Accounts" mode="M16" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:NoAccountsReason = &quot;PDF accounts attached with explanation&quot; or count(../../ct:AttachedFiles/ct:Attachment[@Type='accounts']) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9112</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You can only provide a set of PDF accounts if you also complete the 'No accounts reason' with the value of 'PDF accounts attached with explanation' </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is absent or not "PDF accounts attached with explanation", then there must be no instance of [N106] with a type attribute of 'accounts'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:NoAccountsReason or (count(../../ct:AttachedFiles/ct:XBRLsubmission/ct:Accounts) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9113</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You must provide a set of iXBRL accounts if the 'No accounts reason' is absent</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is absent then the Accounts child of [N107] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not(ct:NoAccountsReason) or ct:NoAccountsReason = &quot;PDF accounts attached with explanation&quot;) or (count(ct:ThisPeriodAccounts) + count(ct:DifferentPeriod)) = 1"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9114</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'No accounts reason' is absent or has been completed with 'PDF accounts attached with explanation' you must complete either 'This period accounts' or 'Different period accounts'</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is absent or "PDF accounts attached with explanation", then exactly one of [80A] or [85A] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:NoAccountsReason) or ct:NoAccountsReason = &quot;PDF accounts attached with explanation&quot; or (count(ct:ThisPeriodAccounts) + count(ct:DifferentPeriod)) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9116</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'No accounts reason' is present and has not been completed with 'PDF accounts attached with Explanation' you must not complete either 'This period accounts' or 'Different period accounts'</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90A] is present and not "PDF accounts attached with explanation", then neither [80A] nor [85A] may be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M16" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M16" priority="-1"/>
  <axsl:template match="@*|node()" mode="M16" priority="-2">
    <axsl:apply-templates mode="M16" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p16-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:Computations/ct:NoComputationsReason" mode="M17" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../ct:AttachedFiles/ct:Attachment[@Type='computations']) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9117</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Computations in PDF format are attached so a reason for no Computations must not be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90B] is present, then there must be no instance of [N106] with a type attribute of 'computations'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../ct:AttachedFiles/ct:XBRLsubmission/ct:Computation) = 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9118</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Computations in iXBRL format are attached so a reason for no Computations must not be provided</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90B] is present, then there must be no Computation element as a child of [N107]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'Amendment - comps already submitted') or (../../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9119</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Amendments - computations already submitted' cannot be used if the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90B] equals 'Amendment - comps already submitted' then [N003] must equal 'amended'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M17" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M17" priority="-1"/>
  <axsl:template match="@*|node()" mode="M17" priority="-2">
    <axsl:apply-templates mode="M17" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p15-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:Computations" mode="M18" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:NoComputationsReason or (count(../../ct:AttachedFiles/ct:Attachment[@Type='computations']) &gt; 0) or (count(../../ct:AttachedFiles/ct:XBRLsubmission/ct:Computation) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9965</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You must provide a Tax Computation with the return unless you provide a valid reason not to supply it</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90B] is absent, then there must be a Computations element as a child of [N107], or at least one instance of [N106] with type = 'computations'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:NoComputationsReason or not((count(../../ct:AttachedFiles/ct:Attachment[@Type='computations']) &gt; 0) and (count(../../ct:AttachedFiles/ct:XBRLsubmission/ct:Computation) &gt; 0))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9966</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You cannot provide both iXBRL and PDF Tax Computations with the return</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [90B] is absent, then there must not be both a Computations element as a child of [N107] and any instances of [N106] with type = 'computations'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M18" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M18" priority="-1"/>
  <axsl:template match="@*|node()" mode="M18" priority="-2">
    <axsl:apply-templates mode="M18" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p17-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600A" mode="M19" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:LoansByCloseCompanies"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9120</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600A must be present if Box 95 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [95] equals 'yes' and [N003] equals 'new', then [N095] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M19" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M19" priority="-1"/>
  <axsl:template match="@*|node()" mode="M19" priority="-2">
    <axsl:apply-templates mode="M19" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p18-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600B" mode="M20" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:ControlledForeignCompanies"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9121</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600B must be present if Box 100 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [100] equals 'yes' and [N003] equals 'new', then there must be a [N096] page present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M20" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M20" priority="-1"/>
  <axsl:template match="@*|node()" mode="M20" priority="-2">
    <axsl:apply-templates mode="M20" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p19-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600C" mode="M21" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:GroupAndConsortium"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9123</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600C must be present if Box 105 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [105] equals 'yes' and [N003] equals 'new', then there must be a [N097] page present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M21" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M21" priority="-1"/>
  <axsl:template match="@*|node()" mode="M21" priority="-2">
    <axsl:apply-templates mode="M21" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p20-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600D" mode="M22" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:Insurance"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9124</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600D must be present if Box 110 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [110] equals 'yes' and [N003] equals 'new', then [N098] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M22" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M22" priority="-1"/>
  <axsl:template match="@*|node()" mode="M22" priority="-2">
    <axsl:apply-templates mode="M22" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p21-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600E" mode="M23" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:Charity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9125</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600E must be present if Box 115 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [115] equals 'yes' and [N003] equals 'new', then [N099] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M23" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M23" priority="-1"/>
  <axsl:template match="@*|node()" mode="M23" priority="-2">
    <axsl:apply-templates mode="M23" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p22-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600F" mode="M24" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:TonnageTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9126</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600F must be present if Box 120 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [120] equals 'yes' and [N003] equals 'new', then [N100] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../../../ct:CompanyTaxCalculation/ct:Income/ct:TonnageTaxProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9127</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 120 is completed then Box 200 must be completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[200] should be present if [120] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M24" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M24" priority="-1"/>
  <axsl:template match="@*|node()" mode="M24" priority="-2">
    <axsl:apply-templates mode="M24" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p23-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600G" mode="M25" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not(../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME or ../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9128</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 125 must not be completed if Boxes 6 or 7 are completed and Box 8 is not completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[125] should not be present if [8] is absent and ( [6] is present or [7] is present )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9131</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 125 must not be completed if Box 5 is not completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[125] should not be present if [5] is absent</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../../../ct:NorthernIreland"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9133</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600G must be present if Box 125 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [125] equals 'yes', [N101] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) and ../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedBack) or ../../../ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLossesCarriedBack"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9135</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G90 must be completed if Boxes 125 and 280 are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G90] must be present if [125] and [280] are present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M25" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M25" priority="-1"/>
  <axsl:template match="@*|node()" mode="M25" priority="-2">
    <axsl:apply-templates mode="M25" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p24-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600H" mode="M26" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:CrossBorderRoyalties"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9129</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600H must be present if Box 130 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [130] equals 'yes' and [N003] equals 'new', then [N102] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../../ct:IndicatorsAndInformation/ct:CrossBorderRoyalty = 'yes') or not((.) = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9130</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 130 is completed then Box 645 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [130] equals 'yes' then [645] must equal 'yes'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M26" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M26" priority="-1"/>
  <axsl:template match="@*|node()" mode="M26" priority="-2">
    <axsl:apply-templates mode="M26" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p25-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I" mode="M27" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:RingFenceTrade"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9132</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600I must be present if Box 135 is completed and the return type is New </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [135] equals 'yes' and [N003] equals 'new', then [N103] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M27" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M27" priority="-1"/>
  <axsl:template match="@*|node()" mode="M27" priority="-2">
    <axsl:apply-templates mode="M27" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p26-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600J" mode="M28" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../ct:RegisteredAvoidanceScheme = 'yes') or not((.) = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9134</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 140 is completed then Box 65 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [140] equals 'yes' then [65] must equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:TaxAvoidanceSchemes"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9136</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600J must be present if Box 140 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [140] equals 'yes' and [N003] equals 'new', then [N104] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M28" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M28" priority="-1"/>
  <axsl:template match="@*|node()" mode="M28" priority="-2">
    <axsl:apply-templates mode="M28" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p27-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600K" mode="M29" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes' and ../../../@ReturnType = 'new') or ../../../ct:RestitutionTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9137</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600K must be present if Box 141 is completed and the return type is New</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [141] = 'yes' and [N003] = 'new', then [N113] should be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M29" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M29" priority="-1"/>
  <axsl:template match="@*|node()" mode="M29" priority="-2">
    <axsl:apply-templates mode="M29" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p28-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600L" mode="M30" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../../../ct:ResearchAndDevelopment"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9380</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600L must be present if Box 142 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [142] = 'yes', then [N115] should be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M30" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M30" priority="-1"/>
  <axsl:template match="@*|node()" mode="M30" priority="-2">
    <axsl:apply-templates mode="M30" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p29-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600M" mode="M31" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(.='yes') or ../../../ct:Freeports"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9600</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600M must be present if Box 143 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [143] is yes, [N117] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M31" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M31" priority="-1"/>
  <axsl:template match="@*|node()" mode="M31" priority="-2">
    <axsl:apply-templates mode="M31" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p30-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600N" mode="M32" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(.='yes') or ../../../ct:ResidentialPropertyDeveloperTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9218</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600N must be present if Box 144 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [144] is yes, [N120] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M32" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M32" priority="-1"/>
  <axsl:template match="@*|node()" mode="M32" priority="-2">
    <axsl:apply-templates mode="M32" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p31-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600P" mode="M33" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(.='yes') or ../../../ct:CreativeIndustries"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9872</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600P must be present if Box 96 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [96] is yes, [N123] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M33" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M33" priority="-1"/>
  <axsl:template match="@*|node()" mode="M33" priority="-2">
    <axsl:apply-templates mode="M33" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p35-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:LossesBroughtForward" mode="M34" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Profits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9149</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 160 must not be greater than Box 155</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[160] should not exceed [155]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Profits) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9150</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 160 is completed then Box 155 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[155] should be greater than 0 if [160] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M34" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M34" priority="-1"/>
  <axsl:template match="@*|node()" mode="M34" priority="-2">
    <axsl:apply-templates mode="M34" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p36-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:NetProfits" mode="M35" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:Profits) - sum(../ct:LossesBroughtForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9151</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 165 must equal Box 155 minus Box 160</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[165] should equal [155] minus [160]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9321</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 165 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [165] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M35" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M35" priority="-1"/>
  <axsl:template match="@*|node()" mode="M35" priority="-2">
    <axsl:apply-templates mode="M35" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p34-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:Trading" mode="M36" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:Profits) &gt; 0) or ct:NetProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9148</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 165 must be completed if Box 155 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[165] should be present if [155] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M36" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M36" priority="-1"/>
  <axsl:template match="@*|node()" mode="M36" priority="-2">
    <axsl:apply-templates mode="M36" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p37-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:NonTradingLoanProfitsAndGains" mode="M37" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9322</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 170 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [170] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M37" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M37" priority="-1"/>
  <axsl:template match="@*|node()" mode="M37" priority="-2">
    <axsl:apply-templates mode="M37" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p38-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:NonLoanAnnuitiesAnnualPaymentsDiscounts" mode="M38" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9323</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 175 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [175] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M38" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M38" priority="-1"/>
  <axsl:template match="@*|node()" mode="M38" priority="-2">
    <axsl:apply-templates mode="M38" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p39-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:NonUKdividends" mode="M39" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9324</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 180 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [180] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M39" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M39" priority="-1"/>
  <axsl:template match="@*|node()" mode="M39" priority="-2">
    <axsl:apply-templates mode="M39" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p40-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:DeductedIncome" mode="M40" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9325</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 185 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [185] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M40" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M40" priority="-1"/>
  <axsl:template match="@*|node()" mode="M40" priority="-2">
    <axsl:apply-templates mode="M40" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p41-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:PropertyBusinessIncome" mode="M41" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9326</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 190 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [190] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M41" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M41" priority="-1"/>
  <axsl:template match="@*|node()" mode="M41" priority="-2">
    <axsl:apply-templates mode="M41" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p42-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income/ct:TonnageTaxProfits" mode="M42" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600F = 'yes') or (../../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9154</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 200 can only be completed if Box 120 is completed or the return type is Amended</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[120] should equal 'yes' or [N003] should equal 'amended' if [200] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../ct:TonnageTax/ct:TonnageTax/ct:QualifyingShips/ct:Total) or (. = sum(../../../ct:TonnageTax/ct:TonnageTax/ct:QualifyingShips/ct:Total))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9155</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box F70 is completed then Box 200 must equal Box F70</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[200] must equal [F70] if [F70] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M42" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M42" priority="-1"/>
  <axsl:template match="@*|node()" mode="M42" priority="-2">
    <axsl:apply-templates mode="M42" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p33-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:Income" mode="M43" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ProfitsBeforeOtherDeductions or not((sum(ct:NonTradingGainsIntangibles) + sum(ct:TonnageTaxProfits) + sum(ct:OtherIncome)) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9327</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if (the sum of Boxes 195, 200 and 205) is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if the sum of [195], [200] and [205] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M43" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M43" priority="-1"/>
  <axsl:template match="@*|node()" mode="M43" priority="-2">
    <axsl:apply-templates mode="M43" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p43-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargeableGains/ct:AllowableLosses" mode="M44" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:GrossGains)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9157</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 215 must not be greater than Box 210</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[215] should not exceed [210]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:GrossGains) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9158</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 215 is completed then Box 210 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[210] should be greater than 0 if [215] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M44" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M44" priority="-1"/>
  <axsl:template match="@*|node()" mode="M44" priority="-2">
    <axsl:apply-templates mode="M44" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p44-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargeableGains/ct:NetChargeableGains" mode="M45" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:GrossGains) - sum(../ct:AllowableLosses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9159</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 220 must equal Box 210 minus Box 215</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[220] should equal [210] minus [215]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ProfitsBeforeOtherDeductions or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9331</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must be completed if Box 220 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should be present if [220] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M45" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M45" priority="-1"/>
  <axsl:template match="@*|node()" mode="M45" priority="-2">
    <axsl:apply-templates mode="M45" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p45-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:LossesBroughtForward" mode="M46" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../ct:Income/ct:NonTradingLoanProfitsAndGains) + sum(../ct:Income/ct:NonLoanAnnuitiesAnnualPaymentsDiscounts) + sum(../ct:Income/ct:NonUKdividends) + sum(../ct:Income/ct:DeductedIncome) + sum(../ct:Income/ct:PropertyBusinessIncome) + sum(../ct:Income/ct:NonTradingGainsIntangibles) + sum(../ct:Income/ct:TonnageTaxProfits) + sum(../ct:Income/ct:OtherIncome) + sum(../ct:ChargeableGains/ct:NetChargeableGains))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9160</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 225 must not be greater than the sum of Boxes 170, 175, 180, 185, 190, 195, 200, 205 and 220</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[225] should not exceed the sum of [170], [175], [180], [185], [190], [195], [200], [205] and [220]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M46" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M46" priority="-1"/>
  <axsl:template match="@*|node()" mode="M46" priority="-2">
    <axsl:apply-templates mode="M46" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p46-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:NonTradeDeficitsOnLoans" mode="M47" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (((sum(../ct:Income/ct:NonTradingLoanProfitsAndGains) + sum(../ct:Income/ct:NonLoanAnnuitiesAnnualPaymentsDiscounts) + sum(../ct:Income/ct:NonUKdividends) + sum(../ct:Income/ct:DeductedIncome) + sum(../ct:Income/ct:PropertyBusinessIncome) + sum(../ct:Income/ct:NonTradingGainsIntangibles) + sum(../ct:Income/ct:TonnageTaxProfits) + sum(../ct:Income/ct:OtherIncome) + sum(../ct:ChargeableGains/ct:NetChargeableGains)) - sum(../ct:LossesBroughtForward))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9161</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 230 must not be greater than (the sum of Boxes 170, 175, 180, 185, 190, 195, 200, 205 and 220) minus Box 225</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[230] should not exceed the sum of [170], [175], [180], [185], [190], [195], [200], [205] and [220] minus [225]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M47" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M47" priority="-1"/>
  <axsl:template match="@*|node()" mode="M47" priority="-2">
    <axsl:apply-templates mode="M47" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p47-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ProfitsBeforeOtherDeductions" mode="M48" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../ct:Income/ct:Trading/ct:NetProfits) + sum(../ct:Income/ct:NonTradingLoanProfitsAndGains) + sum(../ct:Income/ct:NonLoanAnnuitiesAnnualPaymentsDiscounts) + sum(../ct:Income/ct:NonUKdividends) + sum(../ct:Income/ct:DeductedIncome) + sum(../ct:Income/ct:PropertyBusinessIncome) + (sum(../ct:Income/ct:NonTradingGainsIntangibles) + sum(../ct:Income/ct:TonnageTaxProfits) + sum(../ct:Income/ct:OtherIncome)) + sum(../ct:ChargeableGains/ct:NetChargeableGains)) - (sum(../ct:LossesBroughtForward) + sum(../ct:NonTradeDeficitsOnLoans))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9332</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 235 must equal (the sum of Boxes 165, 170, 175, 180, 185, 190, 195, 200, 205 and 220 ) minus (the sum of Boxes 225 and 230 ) )</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[235] should equal the sum of [165], [170], [175], [180], [185], [190], [195], [200], [205] and [220] minus ( [225] plus [230] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M48" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M48" priority="-1"/>
  <axsl:template match="@*|node()" mode="M48" priority="-2">
    <axsl:apply-templates mode="M48" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p49-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UnquotedShares" mode="M49" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:ProfitsBeforeOtherDeductions)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9166</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 240 must not be greater than Box 235</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[240] should not exceed [235]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M49" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M49" priority="-1"/>
  <axsl:template match="@*|node()" mode="M49" priority="-2">
    <axsl:apply-templates mode="M49" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p50-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:ManagementExpenses" mode="M50" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - sum(../ct:UnquotedShares))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9167</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 245 must not be greater than Box 235 minus Box 240</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[245] should not exceed [235] minus [240]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M50" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M50" priority="-1"/>
  <axsl:template match="@*|node()" mode="M50" priority="-2">
    <axsl:apply-templates mode="M50" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p51-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses" mode="M51" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9169</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 250 must not be greater than Box 235 minus (the sum of Boxes 240 and 245)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[250] should not exceed [235] minus ( [240] plus [245] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M51" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M51" priority="-1"/>
  <axsl:template match="@*|node()" mode="M51" priority="-2">
    <axsl:apply-templates mode="M51" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p52-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CapitalAllowances" mode="M52" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9170</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 255 must not be greater than Box 235 minus (the sum of Boxes 240, 245 and 250</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[255] should not exceed [235] minus the sum of [240], [245] and [250]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M52" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M52" priority="-1"/>
  <axsl:template match="@*|node()" mode="M52" priority="-2">
    <axsl:apply-templates mode="M52" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p53-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeDeficits" mode="M53" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9171</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 260 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250 and 255)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[260] should not exceed [235] minus the sum of [240], [245], [250] and [255]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M53" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M53" priority="-1"/>
  <axsl:template match="@*|node()" mode="M53" priority="-2">
    <axsl:apply-templates mode="M53" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p54-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits" mode="M54" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9371</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 263 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255 and 260)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[263] should not exceed [235] minus the sum of [240], [245], [250], [255], and [260]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M54" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M54" priority="-1"/>
  <axsl:template match="@*|node()" mode="M54" priority="-2">
    <axsl:apply-templates mode="M54" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p55-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles" mode="M55" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits) + sum(../ct:CarriedForwardNonTradeDeficits)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9173</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 265 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260 and 263)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[265] should not exceed [235] minus the sum of [240], [245], [250], [255], [260] and [263]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M55" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M55" priority="-1"/>
  <axsl:template match="@*|node()" mode="M55" priority="-2">
    <axsl:apply-templates mode="M55" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p56-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLosses" mode="M56" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:TradingLossesCarriedBack  or (. &lt;= sum(../../../ct:LossesDeficitsAndExcess/ct:AmountArising/ct:LossesOfTradesUK/ct:Arising))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9175</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 280 is not completed then Box 275 must be less than or equal to Box 780</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [280] is not 'yes' then [275] must be less than or equal to the 'Arising' element of [780/785]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits) + sum(../ct:CarriedForwardNonTradeDeficits) + sum(../ct:NonTradingLossIntangibles)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9176</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 275 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263 and 265)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[275] should not exceed [235] minus the sum of [240], [245], [250], [255], [260], [263] and [265]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M56" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M56" priority="-1"/>
  <axsl:template match="@*|node()" mode="M56" priority="-2">
    <axsl:apply-templates mode="M56" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p57-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedBack" mode="M57" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:TradingLosses) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9174</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 280 is completed then Box 275 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[275] should exceed 0 if [280] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M57" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M57" priority="-1"/>
  <axsl:template match="@*|node()" mode="M57" priority="-2">
    <axsl:apply-templates mode="M57" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p58-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward" mode="M58" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits) + sum(../ct:CarriedForwardNonTradeDeficits) + sum(../ct:NonTradingLossIntangibles) + sum(../ct:TradingLosses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9372</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 285 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265 and 275)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[285] should not exceed [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], and [275]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M58" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M58" priority="-1"/>
  <axsl:template match="@*|node()" mode="M58" priority="-2">
    <axsl:apply-templates mode="M58" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p59-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances" mode="M59" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits) + sum(../ct:CarriedForwardNonTradeDeficits) + sum(../ct:NonTradingLossIntangibles) + sum(../ct:TradingLosses) + sum(../ct:TradingLossesCarriedForward)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9178</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 290 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275 and 285)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[290] should not exceed [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275] and [285]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M59" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M59" priority="-1"/>
  <axsl:template match="@*|node()" mode="M59" priority="-2">
    <axsl:apply-templates mode="M59" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p60-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:Total" mode="M60" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:ProfitsBeforeOtherDeductions)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9179</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 295 must not be greater than Box 235</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[295] should not exceed [235]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:UnquotedShares) + sum(../ct:ManagementExpenses) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:CapitalAllowances) + sum(../ct:NonTradeDeficits) + sum(../ct:CarriedForwardNonTradeDeficits) + sum(../ct:NonTradingLossIntangibles) + sum(../ct:TradingLosses) + sum(../ct:TradingLossesCarriedForward) + sum(../ct:NonTradeCapitalAllowances)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9180</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 295 must equal the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285 and 290</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[295] should equal the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M60" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M60" priority="-1"/>
  <axsl:template match="@*|node()" mode="M60" priority="-2">
    <axsl:apply-templates mode="M60" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p48-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:DeductionsAndReliefs" mode="M61" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(               (((sum(ct:UnquotedShares) +                   sum(ct:ManagementExpenses) +                   sum(ct:UKpropertyBusinessLosses) +                   sum(ct:CapitalAllowances) +                   sum(ct:NonTradeDeficits) +                   sum(ct:CarriedForwardNonTradeDeficits) +                   sum(ct:NonTradingLossIntangibles) +                   sum(ct:TradingLosses) +                   sum(ct:TradingLossesCarriedForward) +                   sum(ct:NonTradeCapitalAllowances))) - (0) &gt;= 0.001)             )           or             ct:Total"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9318</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 295 must be completed if the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285 and 290 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[295] should be present if the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M61" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M61" priority="-1"/>
  <axsl:template match="@*|node()" mode="M61" priority="-2">
    <axsl:apply-templates mode="M61" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p61-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief" mode="M62" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:QualifyingDonations) &lt;= ."/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9334</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 300 is completed then Box 305 must not be greater than Box 300</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [300] present then [305] must not exceed [300]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((../../ct:ChargeableProfits) - (((.) - (sum(../ct:QualifyingDonations) + sum(../ct:GroupRelief) + sum(../ct:GroupReliefForCarriedForwardLosses))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9335</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 300 is completed then Box 315 must equal Box 300 minus (the sum of Boxes 305, 310 and 312)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [300] is present then [315] must equal [300] minus ( [305] + [310] + [312] ).</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../../ct:DeductionsAndReliefs/ct:UnquotedShares) + sum(../../ct:DeductionsAndReliefs/ct:ManagementExpenses) + sum(../../ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses) + sum(../../ct:DeductionsAndReliefs/ct:CapitalAllowances) + sum(../../ct:DeductionsAndReliefs/ct:NonTradeDeficits) + sum(../../ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits) + sum(../../ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles) + sum(../../ct:DeductionsAndReliefs/ct:TradingLosses) + sum(../../ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward) + sum(../../ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9333</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 300 must equal Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285 and 290)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[300] should equal [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M62" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M62" priority="-1"/>
  <axsl:template match="@*|node()" mode="M62" priority="-2">
    <axsl:apply-templates mode="M62" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p62-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:QualifyingDonations" mode="M63" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ProfitsBeforeDonationsAndGroupRelief                  or                    ((.) - ((                       sum(../../ct:ProfitsBeforeOtherDeductions)                       - ( sum(../../ct:DeductionsAndReliefs/ct:UnquotedShares)                           + sum(../../ct:DeductionsAndReliefs/ct:ManagementExpenses)                           + sum(../../ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses)                           + sum(../../ct:DeductionsAndReliefs/ct:CapitalAllowances)                           + sum(../../ct:DeductionsAndReliefs/ct:NonTradeDeficits)                           + sum(../../ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits)                           + sum(../../ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles)                           + sum(../../ct:DeductionsAndReliefs/ct:TradingLosses)                           + sum(../../ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward)                           + sum(../../ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances)                       )                     )) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9336</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 300 is absent then Box 305 must not be greater than Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285 and 290)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [300] is absent then [305] should not exceed [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M63" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M63" priority="-1"/>
  <axsl:template match="@*|node()" mode="M63" priority="-2">
    <axsl:apply-templates mode="M63" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p63-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief" mode="M64" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../@ReturnType = 'new') or (.) &lt;= 0 or ../../../ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:CompanyInformation/ct:TotalAmountClaimed"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9954</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C10 must be completed if the return type is New and Box 310 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N003] equals 'new' and [310] is greater than zero then [C10] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600C = 'yes') or (../../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9185</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 310 can only be completed if Box 105 is completed or the return type is Amended</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[105] should equal 'yes' or [N003] should equal 'amended' if [310] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../@ReturnType = 'new') or (.) &lt;= 0 or ../../../ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:ClaimAuthorisation/ct:CopyOfNoticesOfConsentAttached or ../../../ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:ClaimAuthorisation/ct:AuthorisationForSimplifiedArrangements"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9955</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New and Box 310 is greater than 0 (zero) then 'Copy of Notices of Consent Attached' must be Yes or 'Authorisation of claim to group relief for simplified arrangements' must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N003] is 'new' and [310] is greater than zero then [SC161] or [AUTHORISATION] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - (((sum(../../ct:ProfitsBeforeOtherDeductions) - (sum(../../ct:DeductionsAndReliefs/ct:UnquotedShares) + sum(../../ct:DeductionsAndReliefs/ct:ManagementExpenses) + sum(../../ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses) + sum(../../ct:DeductionsAndReliefs/ct:CapitalAllowances) + sum(../../ct:DeductionsAndReliefs/ct:NonTradeDeficits) + sum(../../ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits) + sum(../../ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles) + sum(../../ct:DeductionsAndReliefs/ct:TradingLosses) + sum(../../ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward) + sum(../../ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances))) - sum(../ct:QualifyingDonations))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9337</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 310 must not be greater than (Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285 and 290)) minus Box 305</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[310] should not exceed ( [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290] ) minus [305]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M64" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M64" priority="-1"/>
  <axsl:template match="@*|node()" mode="M64" priority="-2">
    <axsl:apply-templates mode="M64" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p64-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses" mode="M65" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600C = 'yes') or (../../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9373</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 312 can only be completed if Box 105 is completed or the return type is Amended</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [312] is present the following should be true: ( [105] equals 'yes' ) or ( [N003] equals 'amended' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((                     ( sum(../../ct:ProfitsBeforeOtherDeductions)                       -                       ( sum(../../ct:DeductionsAndReliefs/ct:UnquotedShares)                         + sum(../../ct:DeductionsAndReliefs/ct:ManagementExpenses)                         + sum(../../ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses)                         + sum(../../ct:DeductionsAndReliefs/ct:CapitalAllowances)                         + sum(../../ct:DeductionsAndReliefs/ct:NonTradeDeficits)                         + sum(../../ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits)                         + sum(../../ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles)                         + sum(../../ct:DeductionsAndReliefs/ct:TradingLosses)                         + sum(../../ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward)                         + sum(../../ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances)                       )                     )                     - sum(../ct:QualifyingDonations)                     - sum(../ct:GroupRelief)                   )) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9374</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 312 must not be greater than (Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 265, 275, 285 and 290)) minus (the sum of Boxes 305 and 310)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[312] should not exceed ( [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285] and [290] ) minus [305] minus [310]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not( ../../../@ReturnType = 'new' and (.) &gt; 0 ) or ../../../ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:CompanyInformation/ct:TotalAmountClaimed"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9375</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C130 must be completed if the return type is New and Box 312 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N003] is 'new' and there is an entry greater than zero in [312] then [C130] must be submitted.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not( ../../../@ReturnType = 'new' and (.) &gt; 0 ) or ../../../ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:ClaimAuthorisation/ct:CopyOfNoticesOfConsentAttached or ../../../ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:ClaimAuthorisation/ct:AuthorisationForSimplifiedArrangements"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9376</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New and Box 312 is greater than 0 (zero) then 'Copy of Notices of Consent Attached' must be Yes or 'Authorisation of claim to group relief for carried forward losses' must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N003] is 'new' and [312] is greater than zero then [SC172] or [AUTHORISATION2] must be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M65" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M65" priority="-1"/>
  <axsl:template match="@*|node()" mode="M65" priority="-2">
    <axsl:apply-templates mode="M65" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p65-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:ChargeableProfits" mode="M66" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Details/ct:Profit) + sum(../ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Details/ct:Profit)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9186</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 315 must equal the sum of Boxes 335, 350, 365, 385, 400 and 415</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[315] must equal the sum of all iterations of [335] plus the sum of all iterations of [385]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:ProfitsBeforeOtherDeductions)                   - ( sum(../ct:DeductionsAndReliefs/ct:UnquotedShares)                       + sum(../ct:DeductionsAndReliefs/ct:ManagementExpenses)                       + sum(../ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses)                       + sum(../ct:DeductionsAndReliefs/ct:CapitalAllowances)                       + sum(../ct:DeductionsAndReliefs/ct:NonTradeDeficits)                       + sum(../ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits)                       + sum(../ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles)                       + sum(../ct:DeductionsAndReliefs/ct:TradingLosses)                       + sum(../ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward)                       + sum(../ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances)                       + sum(../ct:ChargesAndReliefs/ct:QualifyingDonations)                       + sum(../ct:ChargesAndReliefs/ct:GroupRelief)                       + sum(../ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses)                     ))) &lt; 0.001)               or                 ../ct:ChargesAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9338</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 300 is absent then Box 315 must equal Box 235 minus (the sum of Boxes 240, 245, 250, 255, 260, 263, 265, 275, 285, 290, 305, 310 and 312)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [300] is absent then [315] should equal [235] minus the sum of [240], [245], [250], [255], [260], [263], [265], [275], [285], [290], [305], [310] and [312]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(date:year(normalize-space(date:add(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('-P3M')))) - date:year(normalize-space(date:add(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From),normalize-space('-P3M')))) != 1) or ../ct:CorporationTaxChargeable/ct:FinancialYearTwo or not((.) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9188</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Financial year two information must be provided if Box 315 is greater than 0 (zero) and the return period To date in Box 35 falls in the financial year following that of the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[N052b] must be submitted if [315] is greater than 0 and [35] falls in the financial year following the financial year of [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M66" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M66" priority="-1"/>
  <axsl:template match="@*|node()" mode="M66" priority="-2">
    <axsl:apply-templates mode="M66" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p66-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:RingFenceProfitsIncluded" mode="M67" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../ct:ChargeableProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9190</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 320 must not be greater than Box 315</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[320] should not exceed [315]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I = 'yes') or (../../@ReturnType = 'amended')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9956</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 320 can only be completed if Box 135 is completed or return type is Amended</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[135] should equal 'yes' or [N003] should equal 'amended' if [320] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M67" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M67" priority="-1"/>
  <axsl:template match="@*|node()" mode="M67" priority="-2">
    <axsl:apply-templates mode="M67" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p67-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:NorthernIrelandProfitsIncluded" mode="M68" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9138</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 325 can only be completed if Box 5 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [325] is present then [5] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../ct:ChargeableProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9139</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 325 must not be greater than Box 315</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[325] must not exceed [315]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M68" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M68" priority="-1"/>
  <axsl:template match="@*|node()" mode="M68" priority="-2">
    <axsl:apply-templates mode="M68" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p69-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:AssociatedCompanies/ct:AssociatedCompaniesFinancialYears" mode="M69" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:ThisPeriod)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9397</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 327 and 328 must not be completed if Box 326 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[N054] should not be present if [326] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M69" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M69" priority="-1"/>
  <axsl:template match="@*|node()" mode="M69" priority="-2">
    <axsl:apply-templates mode="M69" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p70-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate" mode="M70" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 1)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9398</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company is 1 (Unit trust or open-ended investment company)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 1</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 2)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9399</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company is 2 (Close investment-holding company)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 2</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 3)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9415</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company is 3 (Company in liquidation)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 3</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 9)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9416</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company is 9 (Real Estate Investment Trust C - residual company)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 9</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 10)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9873</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company in Box 4 is 10 (Real Estate Investment Trust C - tax-exempt company)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 10</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../ct:CompanyInformation/ct:CompanyType = 11)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9874</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 329 must not be completed if the type of company in Box 4 is 11 (Non-UK resident company)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[329] should not be present if [4] equals 11</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M70" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M70" priority="-1"/>
  <axsl:template match="@*|node()" mode="M70" priority="-2">
    <axsl:apply-templates mode="M70" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p68-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:AssociatedCompanies" mode="M71" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:ThisPeriod or ct:AssociatedCompaniesFinancialYears"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9240</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the associated companies section is present then either Box 326 or Boxes 327 and 328 must be completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N049] is present the following should be true: [326] is present or [N054] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9389</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The associated companies section can only be completed if the return period end date in Box 35 is on or after 01/04/2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N049] is present the following should be true: [35] on or after '2023-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M71" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M71" priority="-1"/>
  <axsl:template match="@*|node()" mode="M71" priority="-2">
    <axsl:apply-templates mode="M71" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p71-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Year" mode="M72" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) = date:year(normalize-space(date:add(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)),normalize-space('-P3M'))))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9195</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 330 must equal the equivalent financial year of the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[330] should equal the equivalent financial year of the date in [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not (                     date:year(normalize-space(date:add(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)),normalize-space('-P3M')))) = date:year(normalize-space(date:add(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)),normalize-space('-P3M'))))                   )                   or (                     sum(../ct:Details/ct:Profit) = ../../../ct:ChargeableProfits                   )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9197</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Where the return period From date in Box 30 and the return period To date in Box 35 are in the same financial year then the sum of Boxes 335, 350 and 365 must equal Box 315</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Where [30] and [35] are in the same financial year, the sum of all iterations of [335] must equal [315].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="date:year(normalize-space(date:add(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)),normalize-space('-P3M')))) = date:year(normalize-space(date:add(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)),normalize-space('-P3M'))))                     or                       sum(../ct:Details/ct:Profit) = round(../../../ct:ChargeableProfits * round((date:seconds(normalize-space(date:difference(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)),normalize-space(concat( (.) + 1 , '-03-31'))))) div 86400) + 1) div round((date:seconds(normalize-space(date:difference(normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)),normalize-space(string(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))))) div 86400) + 1))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9198</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Where the return period From date in Box 30 and the return period To date in Box 35 are in different financial years then the sum of Boxes 335, 350 and 365 must equal Box 315 apportioned to the first financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Where [30] and [35] are in different financial years, the sum of all iterations of [335] must equal [315] divided by the number of days between [30] and [35] inclusive multiplied by the number of days between [30] and the end of financial year [330] inclusive. Rounding is applied such that values from x.5 upwards are rounded up, and values less than x.5 are rounded down (where x represents a whole number).</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M72" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M72" priority="-1"/>
  <axsl:template match="@*|node()" mode="M72" priority="-2">
    <axsl:apply-templates mode="M72" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p72-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Details/ct:TaxRate" mode="M73" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 5)                     or         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)       or                       ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))                     or                       ((math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001))                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9199</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 5 (Insurance) than an applicable tax rate from one of  [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT] or [RF SMALL CO RATE OF CT] must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '5' then [340] should equal an applicable value from [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT] or [RF SMALL CO RATE OF CT]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 0)                     or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)                     or        ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))        or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                     or        (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))                     or                       ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9200</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 0 then an applicable tax rate from one of [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT], [RF SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '0' then [340] should equal an applicable value from [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT], [RF SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 4) or         ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001)) or         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001) or         ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9201</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 4 (Qualifying asset holding company) then an applicable tax rate from one of [FULL RATE OF CT], [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '4' then [340] should equal [FULL RATE OF CT] or [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 1) or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9202</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the company type is 1 (Unit trust or open-ended investment company) than the [EQUIV. LOW CT RATE] of tax must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '1' then [340] should equal [EQUIV. LOW CT RATE]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 2) or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9203</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 2 (Close investment-holding company) then the [FULL RATE OF CT] of tax must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '2' then [340] should equal [FULL RATE OF CT]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((../../../../../ct:CompanyInformation/ct:CompanyType = 3) or (../../../../../ct:CompanyInformation/ct:CompanyType = 9) or (../../../../../ct:CompanyInformation/ct:CompanyType = 10) or (../../../../../ct:CompanyInformation/ct:CompanyType = 11)) or                         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001) or                        ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9143</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company in Box 4 is 3 (Company in liquidation) or 9 (Real Estate Investment Trust C — residual company) or 10 (Real Estate Investment Trust C – tax-exempt company) or 11 (Non-UK resident company) then an applicable tax rate from one of [FULL RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '3' or '9' or '10' or '11' then [340] should equal an applicable value from [FULL RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 6 or ../../../../../ct:CompanyInformation/ct:CompanyType = 7 or ../../../../../ct:CompanyInformation/ct:CompanyType = 8)                     or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)       or         ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))                     or                       ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9145</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 6 (Members’ club or voluntary association), 7 (Property management company) or 8 (Charity or owned by a charity) then an applicable tax rate from one of [FULL RATE OF CT], [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '6', '7' or '8' then [340] should equal [FULL RATE OF CT] or [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 3 or ../../../../../ct:CompanyInformation/ct:CompanyType = 4 or ../../../../../ct:CompanyInformation/ct:CompanyType = 6 or ../../../../../ct:CompanyInformation/ct:CompanyType = 7 or ../../../../../ct:CompanyInformation/ct:CompanyType = 8 or ../../../../../ct:CompanyInformation/ct:CompanyType = 9 or ../../../../../ct:CompanyInformation/ct:CompanyType = 0)                       or                         ../../../../../ct:TaxReconciliation/ct:NIcorporationTaxIncluded                       or                         not((round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)))                       or                         not((math:abs((.) - (19)) &lt; 0.001))                       or                         (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)                       or                         (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)                       or                         ( (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                       or                         ( (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9147</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 0 (UK trading or Professional Services or CASC), 3 (Company in liquidation), 4 (Asset holding company), 6 (Members' club or voluntary association), 7 (Property management company), 8 (Charity or owed by a charity) or 9 (Real Estate Investment Trust C - residual company) and the [CT RATE FOR NI TRADING PROFITS] of tax is different to all other CT rates and has been used then Box 586 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '3', '4', '6', '7', '8', '9', or '0' and [CT RATE FOR NI TRADING PROFITS] is different to all other CT rates and [CT RATE FOR NI TRADING PROFITS] appears in [340] then [586] must be completed.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M73" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M73" priority="-1"/>
  <axsl:template match="@*|node()" mode="M73" priority="-2">
    <axsl:apply-templates mode="M73" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p73-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Details/ct:Tax" mode="M74" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (( round ( (../ct:Profit * (translate(string(../ct:TaxRate),'.',''))) div 100 ) * 100) div 10000)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9204</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The amount of Tax must equal the Amount of profit multiplied by the Rate of tax e.g. Box 345 must equal Box 335 multiplied by Box 340</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>For each iteration of [N053], [345] should equal [335] multiplied by ([340] divided by 100) rounded to two decimal places (round up if third decimal is greater than or equal to 5, otherwise round down)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M74" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M74" priority="-1"/>
  <axsl:template match="@*|node()" mode="M74" priority="-2">
    <axsl:apply-templates mode="M74" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p75-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Year" mode="M75" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((../../ct:FinancialYearOne/ct:Year + 1))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9207</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 380 must equal Box 330 plus one.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[380] should equal [330] plus 1</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M75" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M75" priority="-1"/>
  <axsl:template match="@*|node()" mode="M75" priority="-2">
    <axsl:apply-templates mode="M75" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p76-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Details/ct:TaxRate" mode="M76" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 5)                     or         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)       or                       ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))                     or                       ((math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001))                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9208</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 5 (Insurance) than an applicable tax rate from one of  [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT] or [RF SMALL CO RATE OF CT] must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '5' then [390] should equal an applicable value from [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT] or [RF SMALL CO RATE OF CT]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 0)                     or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)                     or                             ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))                             or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)                     or                       (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                     or                             (((../../../../ct:RingFenceProfitsIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded or ../../../../../ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded or ../../../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)) and (../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))                     or                       ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9209</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 0 then an applicable tax rate from one of [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT], [RF SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '0' then [390] should equal an applicable value from [FULL RATE OF CT], [SMALL CO RATE OF CT], [EQUIV. LOW CT RATE], [FULL RF RATE OF CT], [RF SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 4) or                       ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001)) or         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001) or         ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9210</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 4 (Qualifying asset holding company) then an applicable tax rate from one of [FULL RATE OF CT] or [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '4' then [390] should equal [FULL RATE OF CT], [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 1) or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9211</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the company type is 1 (Unit trust or open-ended investment company) than the [EQUIV. LOW CT RATE] of tax must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '1' then [390] should equal [EQUIV. LOW CT RATE]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 2) or                       (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9212</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 2 (Close investment-holding company) then the [FULL RATE OF CT] of tax must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '2' then [390] should equal [FULL RATE OF CT]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((../../../../../ct:CompanyInformation/ct:CompanyType = 3) or (../../../../../ct:CompanyInformation/ct:CompanyType = 9) or (../../../../../ct:CompanyInformation/ct:CompanyType = 10) or (../../../../../ct:CompanyInformation/ct:CompanyType = 11)) or                        (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001) or                        ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9152</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company in Box 4 is 3 (Company in liquidation) or 9 (Real Estate Investment Trust C — residual company) or 10 (Real Estate Investment Trust C – tax-exempt company) or 11 (Non-UK resident company) then an applicable tax rate from one of [FULL RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '3' or '9' or '10' or '11' then [340] should equal an applicable value from [FULL RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 6 or ../../../../../ct:CompanyInformation/ct:CompanyType = 7 or ../../../../../ct:CompanyInformation/ct:CompanyType = 8)                     or         (math:abs((.) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)       or                       ((../../../ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate) and (round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)) and (math:abs((.) - (19)) &lt; 0.001))                     or                       ((../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity and (not(../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SME) or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:NIemployer or ../../../../../ct:CompanyInformation/ct:NorthernIreland/ct:SpecialCircumstances) and (round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) and (math:abs((.) - (19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9153</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 6 (Members’ club or voluntary association), 7 (Property management company) or 8 (Charity or owned by a charity) then an applicable tax rate from one of [FULL RATE OF CT], [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS] must be used for the second financial year</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '6', '7' or '8' then [390] should equal [FULL RATE OF CT] or [SMALL CO RATE OF CT] or [CT RATE FOR NI TRADING PROFITS]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../../../../ct:CompanyInformation/ct:CompanyType = 3 or ../../../../../ct:CompanyInformation/ct:CompanyType = 4 or ../../../../../ct:CompanyInformation/ct:CompanyType = 6 or ../../../../../ct:CompanyInformation/ct:CompanyType = 7 or ../../../../../ct:CompanyInformation/ct:CompanyType = 8 or ../../../../../ct:CompanyInformation/ct:CompanyType = 9 or ../../../../../ct:CompanyInformation/ct:CompanyType = 0)                       or                         ../../../../../ct:TaxReconciliation/ct:NIcorporationTaxIncluded                       or                         not((round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400)))                       or                         not((math:abs((.) - (19)) &lt; 0.001))                       or                         (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     20)) &lt; 0.001)                       or                         (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2017-04-01')) div 86400))) *     20  +     number((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     25)) &lt; 0.001)                       or                         ( (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     30  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     30)) &lt; 0.001))                       or                         ( (math:abs((19) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *      number((round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *     19  +     number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(concat(normalize-space(../../ct:Year), '-04-01'))) div 86400))) *     19)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9156</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the type of company is 0 (UK trading or Professional Services or CASC), 3 (Company in liquidation), 4 (Asset holding company),  6 (Members' club or voluntary association), 7 (Property management company), 8 (Charity or owed by a charity) or 9 (Real Estate Investment Trust C - residual company) and the [CT RATE FOR NI TRADING PROFITS] of tax is different to all other CT rates and has been used for the second financial year, then Box 586 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [4] equals '3', '4', '6', '7', '8', '9', or '0' and [CT RATE FOR NI TRADING PROFITS] is different to all other CT rates and [CT RATE FOR NI TRADING PROFITS] appears in [390] then [586] must be completed.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M76" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M76" priority="-1"/>
  <axsl:template match="@*|node()" mode="M76" priority="-2">
    <axsl:apply-templates mode="M76" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p77-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Details/ct:Tax" mode="M77" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (( round ( (../ct:Profit * (translate(string(../ct:TaxRate),'.',''))) div 100 ) * 100) div 10000)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9213</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">For the second financial year the amount of Tax must equal the Amount of profit multiplied by the Rate of tax e.g. Box 395 must equal Box 385 multiplied by Box 390</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>For each iteration of [N053b] [395] should equal [385] multiplied by ([390] divided by 100) rounded to two decimal places (round up if third decimal is greater than or equal to 5, otherwise round down)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M77" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M77" priority="-1"/>
  <axsl:template match="@*|node()" mode="M77" priority="-2">
    <axsl:apply-templates mode="M77" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p74-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTaxChargeable/ct:FinancialYearTwo" mode="M78" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="date:year(normalize-space(date:add(normalize-space(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From),normalize-space('-P3M')))) != date:year(normalize-space(date:add(normalize-space(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('-P3M'))))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9206</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Financial year two information must not be completed if the accounting period falls within the same financial year.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[N052b] should not be present if [30] and [35] both fall within the same financial year</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M78" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M78" priority="-1"/>
  <axsl:template match="@*|node()" mode="M78" priority="-2">
    <axsl:apply-templates mode="M78" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p78-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CorporationTax" mode="M79" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Details/ct:Tax) + sum(../ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Details/ct:Tax))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9214</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 430 must equal the sum of Boxes 345, 360, 375, 395, 410 and 425</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[430] should equal the sum all iterations of [345] plus all iterations of [395]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M79" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M79" priority="-1"/>
  <axsl:template match="@*|node()" mode="M79" priority="-2">
    <axsl:apply-templates mode="M79" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p79-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:MarginalReliefForRingFenceTrades" mode="M80" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt; sum(../ct:CorporationTax)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9216</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 435 must be less than Box 430</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[435] should be less than [430]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../ct:CorporationTaxChargeable/ct:AssociatedCompanies/ct:StartingOrSmallCompaniesRate = 'yes') or ((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2023-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9417</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 435 can only be completed if Box 329 is completed or the return period end date in Box 35 is on or before 31/03/2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [435] is present the following should be true: ( [329] equals 'yes' ) or ( [35] on or before '2023-03-31' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I = 'yes') or ((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9350</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 435 can only be completed if Box 135 is completed or the return period end date in Box 35 is on or after 01/04/2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [435] is present, either [135] should equal 'yes' or [35] should be on or after '2023-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M80" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M80" priority="-1"/>
  <axsl:template match="@*|node()" mode="M80" priority="-2">
    <axsl:apply-templates mode="M80" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p80-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable" mode="M81" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:CorporationTax) - sum(../ct:MarginalReliefForRingFenceTrades)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9234</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 440 must equal Box 430 minus Box 435</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[440] should equal [430] minus [435]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M81" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M81" priority="-1"/>
  <axsl:template match="@*|node()" mode="M81" priority="-2">
    <axsl:apply-templates mode="M81" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p82-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:CommunityInvestmentRelief" mode="M82" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../../ct:NetCorporationTaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9241</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 445 must not be greater than Box 440</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[445] should not exceed [440]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M82" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M82" priority="-1"/>
  <axsl:template match="@*|node()" mode="M82" priority="-2">
    <axsl:apply-templates mode="M82" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p83-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:DoubleTaxation/ct:DoubleTaxationRelief" mode="M83" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((../../../ct:NetCorporationTaxChargeable - sum(../../ct:CommunityInvestmentRelief))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9242</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 450 must not be greater than Box 440 minus Box 445</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[450] should not exceed [440] minus [445]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M83" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M83" priority="-1"/>
  <axsl:template match="@*|node()" mode="M83" priority="-2">
    <axsl:apply-templates mode="M83" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p84-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:DoubleTaxation/ct:UnderlyingRate" mode="M84" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:DoubleTaxationRelief) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9244</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 455 is completed then Box 450 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[450] should exceed 0 if [455] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M84" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M84" priority="-1"/>
  <axsl:template match="@*|node()" mode="M84" priority="-2">
    <axsl:apply-templates mode="M84" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p85-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:DoubleTaxation/ct:AmountCarriedBack" mode="M85" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:DoubleTaxationRelief) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9245</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 460 is completed then Box 450 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[450] should exceed 0 if [460] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M85" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M85" priority="-1"/>
  <axsl:template match="@*|node()" mode="M85" priority="-2">
    <axsl:apply-templates mode="M85" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p86-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:AdvancedCorporationTax" mode="M86" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((../../ct:NetCorporationTaxChargeable - (sum(../ct:CommunityInvestmentRelief) + sum(../ct:DoubleTaxation/ct:DoubleTaxationRelief)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9246</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 465 must not be greater than Box 440 minus (the sum of Boxes 445 and 450)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[465] should not exceed [440] minus ( [445] plus [450] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M86" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M86" priority="-1"/>
  <axsl:template match="@*|node()" mode="M86" priority="-2">
    <axsl:apply-templates mode="M86" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p87-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions" mode="M87" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:CommunityInvestmentRelief) + sum(../ct:DoubleTaxation/ct:DoubleTaxationRelief) + sum(../ct:AdvancedCorporationTax)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9247</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 470 must equal the sum of Boxes 445, 450 and 465</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[470] should equal the sum of [445], [450] and [465]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M87" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M87" priority="-1"/>
  <axsl:template match="@*|node()" mode="M87" priority="-2">
    <axsl:apply-templates mode="M87" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p81-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions" mode="M88" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CommunityInvestmentRelief) or ct:TotalReliefsAndDeductions"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9236</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 470 must be completed if Box 445 is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[470] should be present if [445] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:DoubleTaxation/ct:DoubleTaxationRelief) or ct:TotalReliefsAndDeductions"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9237</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 470 must be completed if Box 450 is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[470] should be present if [450] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not( ct:AdvancedCorporationTax) or ct:TotalReliefsAndDeductions"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9238</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 470 must be completed if Box 465 is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[470] should be present if [465] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M88" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M88" priority="-1"/>
  <axsl:template match="@*|node()" mode="M88" priority="-2">
    <axsl:apply-templates mode="M88" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p88-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation/ct:CJRS/ct:CJRSreceived" mode="M89" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((.) - ((sum(../ct:CJRSdue) + sum(../ct:CJRSoverpaymentAlreadyAssessed))) &gt; -0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9381</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 471 must be equal to or greater than the sum of Boxes 472 and 473</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[471] should be at least ( [472] plus [473] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.)) or ../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:CJRSoverpaymentsNowDue"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9382</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 471 is completed then Box 526 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[526] should be present if [471] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M89" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M89" priority="-1"/>
  <axsl:template match="@*|node()" mode="M89" priority="-2">
    <axsl:apply-templates mode="M89" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p32-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CompanyTaxCalculation" mode="M90" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:TonnageTax/ct:TonnageTax/ct:OffshoreTrainingAllowance/ct:OffsetAgainstCorpTax)               or                 (                   ct:TaxReliefsAndDeductions/ct:DoubleTaxation/ct:DoubleTaxationRelief                 and                   ((sum(ct:TaxReliefsAndDeductions/ct:DoubleTaxation/ct:DoubleTaxationRelief)) - (sum(../ct:TonnageTax/ct:TonnageTax/ct:OffshoreTrainingAllowance/ct:OffsetAgainstCorpTax)) &gt; -0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9140</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box F45 is completed then Box 450 must be greater than or equal to that entry</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [F45] is present then [450] must be present and greater than or equal to [F45]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:ChargeableProfits &gt; 0) or ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Year"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9144</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 330 must be completed if Box 315 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[330] should be present if [315] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CorporationTaxChargeable/ct:FinancialYearOne/ct:Details/ct:Tax or ct:CorporationTaxChargeable/ct:FinancialYearTwo/ct:Details/ct:Tax) or ct:CorporationTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9146</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 430 must be completed if Box 345 or Box 395 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[430] should be present if [345] or [395] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:ProfitsBeforeOtherDeductions) &gt; 0) or ct:ChargesAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9320</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 300 must be completed if Box 235 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[300] should be present if [235] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M90" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M90" priority="-1"/>
  <axsl:template match="@*|node()" mode="M90" priority="-2">
    <axsl:apply-templates mode="M90" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p90-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnergyProfitsLevy/ct:EOGPLamounts" mode="M91" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:EOGPLpayable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9420</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 501 must be completed if Box 986 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[501] should be present if [986] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M91" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M91" priority="-1"/>
  <axsl:template match="@*|node()" mode="M91" priority="-2">
    <axsl:apply-templates mode="M91" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p91-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnergyProfitsLevy/ct:EGLamounts" mode="M92" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:EGLpayable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9867</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 502 must be completed if Box 987 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[502] should be present if [987] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M92" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M92" priority="-1"/>
  <axsl:template match="@*|node()" mode="M92" priority="-2">
    <axsl:apply-templates mode="M92" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p89-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnergyProfitsLevy" mode="M93" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:EOGPLamounts or ct:EGLamounts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9866</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the Energy Levies section is present, then at least one of Boxes 986 or 987 should be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[986] or [987] should be present if [F092] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M93" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M93" priority="-1"/>
  <axsl:template match="@*|node()" mode="M93" priority="-2">
    <axsl:apply-templates mode="M93" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p93-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:NetCorporationTaxLiability" mode="M94" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable - sum(../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9248</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 475 must equal Box 440 minus Box 470</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[475] should equal [440] minus [470]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:TaxChargeable) or (math:abs((sum(../ct:TaxChargeable)) - (((.) + sum(../ct:LoansToParticipators) + sum(../ct:CFCandBankLevyTotal) + sum(../ct:EOGPLpayable) + sum(../ct:EGLpayable) + sum(../ct:SupplementaryCharge)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9339</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 475 is completed then Box 510 must equal (the sum of Boxes 475, 480, 500, 501, 502 and 505)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [475] is present then [510] should equal the sum of [475], [480], [500], [501], [502] and [505]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M94" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M94" priority="-1"/>
  <axsl:template match="@*|node()" mode="M94" priority="-2">
    <axsl:apply-templates mode="M94" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p94-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:LoansToParticipators" mode="M95" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((../../@ReturnType = 'new') and not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600A = 'yes')) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9252</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 480 can only be completed if Box 95 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[480] should not be present if [N003] equals 'new' and [95] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M95" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M95" priority="-1"/>
  <axsl:template match="@*|node()" mode="M95" priority="-2">
    <axsl:apply-templates mode="M95" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p95-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:CT600AreliefDue" mode="M96" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:LoansToParticipators"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9249</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 480 must be completed if Box 485 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[480] should be present if [485] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(                   (../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600A = 'yes') and not(../../ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:ReliefDue)                 ) or (                   not((.) = 'yes')                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9250</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 485 can only be completed if Box A70 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [95] equals 'yes' and [A70] is absent then [485] should not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(                   (../../@ReturnType = 'new') and not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600A = 'yes')                 ) or (                   not((.))                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9251</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 485 can only be completed if Box 95 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N003] equals 'new' and [95] does not equal 'yes' then [485] must not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M96" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M96" priority="-1"/>
  <axsl:template match="@*|node()" mode="M96" priority="-2">
    <axsl:apply-templates mode="M96" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p96-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:CFCtaxPayable" mode="M97" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((../../@ReturnType = 'new') and (not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600B = 'yes')))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9353</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 490 must not be completed if the return type is New and Box 100 is not completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[490] should not be present if [N003] equals 'new' and [100] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M97" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M97" priority="-1"/>
  <axsl:template match="@*|node()" mode="M97" priority="-2">
    <axsl:apply-templates mode="M97" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p97-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:RPDTpayable" mode="M98" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../../ct:ResidentialPropertyDeveloperTax/ct:Section4/ct:RPDTpayable))) &lt; 0.001) or not(../../ct:ResidentialPropertyDeveloperTax/ct:Section4/ct:RPDTpayable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9433</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 497 must equal Box N285 if Box N285 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[497] must equal [N285] if [N285] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M98" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M98" priority="-1"/>
  <axsl:template match="@*|node()" mode="M98" priority="-2">
    <axsl:apply-templates mode="M98" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p98-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:CFCandBankLevyTotal" mode="M99" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:CFCtaxPayable) + sum(../ct:BankLevyPayable) + sum(../ct:BankSurchargePayable) + sum(../ct:RPDTpayable)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9434</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 500 must equal the sum of Boxes 490, 495, 496 and 497</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[500] is valid only if this equals ( The sum of [490], [495], [496], and [497] )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M99" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M99" priority="-1"/>
  <axsl:template match="@*|node()" mode="M99" priority="-2">
    <axsl:apply-templates mode="M99" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p99-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:EOGPLpayable" mode="M100" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:EnergyProfitsLevy/ct:EOGPLamounts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9435</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 986 must be completed if Box 501 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [501] is present the following should be true: [986] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M100" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M100" priority="-1"/>
  <axsl:template match="@*|node()" mode="M100" priority="-2">
    <axsl:apply-templates mode="M100" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p100-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:EGLpayable" mode="M101" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:EnergyProfitsLevy/ct:EGLamounts"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9869</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 987 should be completed if Box 502 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[987] should be present if [502] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M101" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M101" priority="-1"/>
  <axsl:template match="@*|node()" mode="M101" priority="-2">
    <axsl:apply-templates mode="M101" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p101-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge" mode="M102" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((../../@ReturnType = 'new') and (not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I = 'yes'))) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9254</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 505 can only be completed if Box 135 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[505] should not be present if [N003] equals 'new' and [135] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M102" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M102" priority="-1"/>
  <axsl:template match="@*|node()" mode="M102" priority="-2">
    <axsl:apply-templates mode="M102" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p102-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxChargeable" mode="M103" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NetCorporationTaxLiability or (math:abs((.) - (((../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable - sum(../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions)) + sum(../ct:LoansToParticipators) + sum(../ct:CFCandBankLevyTotal) + sum(../ct:EOGPLpayable) + sum(../ct:EGLpayable) + sum(../ct:SupplementaryCharge)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9344</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 475 is not completed then Box 510 must equal (the sum of Boxes 440, 480, 500, 501, 502 and 505) minus Box 470</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [475] is absent then [510] should equal the sum of [440], [480], [501], [502], [500] and [505] minus [470]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:IncomeTax/ct:TaxRepayable) or (math:abs((sum(../ct:IncomeTax/ct:TaxRepayable)) - ((sum(../ct:IncomeTax/ct:DeductedIncomeTax) - (.)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9345</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 510 is completed then Box 520 must equal Box 515 minus Box 510</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [510] is present then [520] should equal [515] minus [510]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M103" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M103" priority="-1"/>
  <axsl:template match="@*|node()" mode="M103" priority="-2">
    <axsl:apply-templates mode="M103" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p103-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:IncomeTax/ct:TaxRepayable" mode="M104" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:TaxChargeable or (math:abs(((.)) - ((sum(../ct:DeductedIncomeTax) + sum(../../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions) - (../../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable + sum(../../ct:LoansToParticipators) + sum(../../ct:CFCandBankLevyTotal) + sum(../../ct:SupplementaryCharge))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9346</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 510 is not completed then Box 520 must equal Box 515 plus Box 470 minus (the sum of Boxes 440, 480, 500 and 505)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [510] is absent then [520] should equal [515] plus [470] minus the sum of [440], [480], [500] and [505]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M104" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M104" priority="-1"/>
  <axsl:template match="@*|node()" mode="M104" priority="-2">
    <axsl:apply-templates mode="M104" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p104-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable" mode="M105" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:TaxChargeable) or ((((sum(../ct:TaxChargeable) - sum(../ct:IncomeTax/ct:DeductedIncomeTax))) - (0) &gt; -0.001) and (math:abs((.) - ((sum(../ct:TaxChargeable) - sum(../ct:IncomeTax/ct:DeductedIncomeTax)))) &lt; 0.001)) or ((((sum(../ct:TaxChargeable) - sum(../ct:IncomeTax/ct:DeductedIncomeTax))) - (0) &lt;= -0.001) and (. = 0))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9347</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 510 is completed then Box 525 must equal Box 510 minus Box 515. If the result is negative please enter 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [510] is present then [525] should equal [510] minus [515], where the result is equal to or greater than zero. Enter 0.00 if [510] minus [515] is negative</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:TaxChargeable or ((((../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable + sum(../ct:LoansToParticipators) + sum(../ct:CFCandBankLevyTotal) + sum(../ct:SupplementaryCharge) - (sum(../ct:IncomeTax/ct:DeductedIncomeTax) + sum(../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions)))) - (0) &gt; -0.001) and (math:abs((.) - ((../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable + sum(../ct:LoansToParticipators) + sum(../ct:CFCandBankLevyTotal) + sum(../ct:SupplementaryCharge) - (sum(../ct:IncomeTax/ct:DeductedIncomeTax) + sum(../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions))))) &lt; 0.001)) or ((((../../ct:CompanyTaxCalculation/ct:NetCorporationTaxChargeable + sum(../ct:LoansToParticipators) + sum(../ct:CFCandBankLevyTotal) + sum(../ct:SupplementaryCharge) - (sum(../ct:IncomeTax/ct:DeductedIncomeTax) + sum(../../ct:CompanyTaxCalculation/ct:TaxReliefsAndDeductions/ct:TotalReliefsAndDeductions)))) - (0) &lt;= -0.001) and (. = 0))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9348</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 510 is completed then Box 525 must equal (the sum of Boxes 440, 480, 500 and 505) minus (the sum of Boxes 515 and Box 470 ). If the result is negative please enter 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [510] is absent then [525] should equal the sum of [440], [480], [500] and [505] minus ( [515] plus [470] ), where the result is equal to or greater than zero. Enter 0.00 if that sum is negative.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M105" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M105" priority="-1"/>
  <axsl:template match="@*|node()" mode="M105" priority="-2">
    <axsl:apply-templates mode="M105" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p105-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:CJRSoverpaymentsNowDue" mode="M106" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (((sum(../../ct:CompanyTaxCalculation/ct:CJRS/ct:CJRSreceived) + sum(../../ct:CompanyTaxCalculation/ct:CJRS/ct:JobRetentionBonusOverpayment)) - (sum(../../ct:CompanyTaxCalculation/ct:CJRS/ct:CJRSdue) + sum(../../ct:CompanyTaxCalculation/ct:CJRS/ct:CJRSoverpaymentAlreadyAssessed))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9384</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 526 must equal (the sum of Boxes 471 and 474) minus (the sum of Boxes 472 and 473)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[526] should equal ( ( [471] plus [474] ) minus ( [472] plus [473] ) )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M106" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M106" priority="-1"/>
  <axsl:template match="@*|node()" mode="M106" priority="-2">
    <axsl:apply-templates mode="M106" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p106-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:RestitutionTax" mode="M107" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../@ReturnType = 'new') or ../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600K = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9368</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 527 can only be completed if Box 141 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[527] should not be present if [N003] equals 'new' and [141] does not equal 'yes'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:RestitutionTax/ct:TaxCalculation/ct:RestitutionTaxNowPayable or ../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600K = 'yes' or (math:abs((.) - (0)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9369</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box K35 is not completed and Box 141 is not completed then Box 527 must be 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [K35] is not submitted and [141] is not equal to 'yes' then [527] must equal zero.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M107" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M107" priority="-1"/>
  <axsl:template match="@*|node()" mode="M107" priority="-2">
    <axsl:apply-templates mode="M107" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p107-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayableIncludingRestitutionTax" mode="M108" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((../ct:TaxPayable + sum(../ct:CJRSoverpaymentsNowDue) + sum(../ct:RestitutionTax)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9370</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 528 must equal the sum of Boxes 525, 526 and 527</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[528] should equal the sum of [525], [526], and [527]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M108" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M108" priority="-1"/>
  <axsl:template match="@*|node()" mode="M108" priority="-2">
    <axsl:apply-templates mode="M108" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p92-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:CalculationOfTaxOutstandingOrOverpaid" mode="M109" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:CFCtaxPayable) &gt; 0) or ct:CFCandBankLevyTotal"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9351</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 500 must be completed if Box 490 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[500] should be present if [490] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:BankLevyPayable) &gt; 0) or ct:CFCandBankLevyTotal"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9352</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 500 must be completed if Box 495 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[500] should be present if [495] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:NetCorporationTaxLiability) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9340</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 475 is completed then Box 510 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [475] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:LoansToParticipators) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9341</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 480 is completed then Box 510 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [480] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CFCandBankLevyTotal) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9342</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 500 is completed then Box 510 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [500] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:SupplementaryCharge) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9343</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 505 is completed then Box 510 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [505] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:BankSurchargePayable) &gt; 0) or ct:CFCandBankLevyTotal"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9366</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 500 must be completed if Box 496 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[500] should be present if [496] exceeds 0.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:RestitutionTax) or ct:TaxPayableIncludingRestitutionTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9367</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 527 is completed then Box 528 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[528] should be present if [527] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CJRSoverpaymentsNowDue) or ct:TaxPayableIncludingRestitutionTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9383</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 526 is completed then Box 528 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[528] should be present if [526] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:RPDTpayable) &gt; 0) or ct:CFCandBankLevyTotal"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9424</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 500 must be completed if Box 497 is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[500] should be present if [497] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:EOGPLpayable) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9432</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 510 must be completed if Box 501 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [501] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:EGLpayable) or ct:TaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9868</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 510 must be completed if Box 502 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[510] should be present if [502] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M109" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M109" priority="-1"/>
  <axsl:template match="@*|node()" mode="M109" priority="-2">
    <axsl:apply-templates mode="M109" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p109-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:ResearchAndDevelopmentCredit" mode="M110" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600L = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9385</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 530 must only be completed if Box 142 equals 'yes'</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[530] should only be present if [142] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../ct:ResearchAndDevelopment/ct:TotalRandDSetOffAgainstLiabilities/ct:Total)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9386</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 530 must equal Box L210</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[530] is valid only if it equals [L210]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M110" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M110" priority="-1"/>
  <axsl:template match="@*|node()" mode="M110" priority="-2">
    <axsl:apply-templates mode="M110" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p110-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:VaccineCredit" mode="M111" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9141</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 535 must not be used</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[535] must not be used.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M111" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M111" priority="-1"/>
  <axsl:template match="@*|node()" mode="M111" priority="-2">
    <axsl:apply-templates mode="M111" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p111-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit" mode="M112" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:ResearchAndDevelopmentCredit) + sum(../ct:VaccineCredit) + sum(../ct:CreativeCredit) + sum(../ct:AVECandVGEC)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9360</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 545 must equal the sum of Boxes 530, 535, 540 and 541</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[545] should equal the sum of [530], [535], [540] and [541]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M112" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M112" priority="-1"/>
  <axsl:template match="@*|node()" mode="M112" priority="-2">
    <axsl:apply-templates mode="M112" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p112-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:LandOrLifeCredit" mode="M113" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:LandRemediationCredit) + sum(../ct:LifeAssuranceCompanyCredit)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9361</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 560 must equal the sum of 550 and 555</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[560] should equal [550] plus [555]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M113" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M113" priority="-1"/>
  <axsl:template match="@*|node()" mode="M113" priority="-2">
    <axsl:apply-templates mode="M113" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p113-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:CapitalAllowancesFirstYearCredit" mode="M114" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt;= round(date:seconds(normalize-space('2020-03-31')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9257</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 565 can only be completed if the date in box 30 is on or before 31 March 2020</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[565] can only be present if [30] on or before '2020-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M114" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M114" priority="-1"/>
  <axsl:template match="@*|node()" mode="M114" priority="-2">
    <axsl:apply-templates mode="M114" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p114-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable" mode="M115" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) - ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable) - (0) &lt;= -0.001) and (. = 0)) or (((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) - ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable) - (0) &gt; -0.001) and (math:abs((.) - (sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) - ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9261</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 570 must equal Box 545 minus Box 525. If the result is negative please enter 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[570] must equal [545] minus [525], where the result is equal to or greater than zero. Enter 0.00 if [545] minus [525] is negative</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M115" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M115" priority="-1"/>
  <axsl:template match="@*|node()" mode="M115" priority="-2">
    <axsl:apply-templates mode="M115" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p115-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:LandOrLifeCreditPayable" mode="M116" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) - (../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable))) - (0) &lt;= -0.001) and (. = 0)) or (((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) - (../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable))) - (0) &gt; -0.001) and (math:abs((.) - (sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) - (../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable)))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9263</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 575 must equal (the sum of Boxes 545 and 560) minus (the sum of Boxes 525 and 570). If the result is negative please enter 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[575] must equal ( [545] plus [560] ) minus ( [525] plus [570] ), where the result is equal to or greater than zero. Enter 0.00 if ( [545] plus [560] ) minus ( [525] plus [570] ) is negative</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:LandOrLifeCredit)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9264</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 575 must not be greater than Box 560</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[575] should not exceed [560]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M116" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M116" priority="-1"/>
  <axsl:template match="@*|node()" mode="M116" priority="-2">
    <axsl:apply-templates mode="M116" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p116-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:CapitalAllowancesFirstYearCreditPayable" mode="M117" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:CapitalAllowancesFirstYearCredit)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9267</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 580 must not be greater than Box 565</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[580] should not exceed [565]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) + sum(../ct:CapitalAllowancesFirstYearCredit) - ( ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable) + sum(../ct:LandOrLifeCreditPayable) )) - (0) &lt;= -0.001) and ((.) = 0)) or (((sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) + sum(../ct:CapitalAllowancesFirstYearCredit) - ( ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable) + sum(../ct:LandOrLifeCreditPayable) )) - (0) &gt; -0.001) and (math:abs((.) - (sum(../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../ct:LandOrLifeCredit) + sum(../ct:CapitalAllowancesFirstYearCredit) - ( ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable + sum(../ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable) + sum(../ct:LandOrLifeCreditPayable) ))) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9268</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 580 must equal (the sum of Boxes 545, 560 and 565) minus (the sum of Boxes 525, 570 and 575). If the result is negative please enter 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[580] should equal the sum of [545], [560] and [565] minus the sum of [525], [570] and [575], where the result is equal to or greater than zero. Enter 0.00 if the sum of [545], [560] and [565] minus the sum of [525], [570] and [575] is negative.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt;= round(date:seconds(normalize-space('2020-03-31')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9258</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 580 can only be completed if the date in box 30 is on or before 31 March 2020</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[580] can only be present if [30] on or before '2020-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M117" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M117" priority="-1"/>
  <axsl:template match="@*|node()" mode="M117" priority="-2">
    <axsl:apply-templates mode="M117" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p117-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:RingFenceCorpTaxIncluded" mode="M118" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((../../@ReturnType = 'new') and (not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I = 'yes'))) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9269</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 585 can only be completed if Box 135 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[585] should not be present if [N003] equals 'new' and [135] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9270</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 585 must not be greater than Box 525</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[585] should not exceed [525]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../@ReturnType = 'new')                 or  (../../ct:RingFenceTrade/ct:NetRingFenceTrade/ct:RingFenceCorpTaxIncluded and (sum(../../ct:RingFenceTrade/ct:NetRingFenceTrade/ct:RingFenceCorpTaxIncluded) = .))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9271</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 585 is completed and the return type is New then Box I80 must be completed and equal to Box 585.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [585] is present and [N003] is 'new' then [I80] must be present and equal to [585].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M118" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M118" priority="-1"/>
  <axsl:template match="@*|node()" mode="M118" priority="-2">
    <axsl:apply-templates mode="M118" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p118-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:NIcorporationTaxIncluded" mode="M119" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9142</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 586 can only be completed if Box 5 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [586] is present then [5] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M119" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M119" priority="-1"/>
  <axsl:template match="@*|node()" mode="M119" priority="-2">
    <axsl:apply-templates mode="M119" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p119-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:RingFenceSupplementaryChargeIncluded" mode="M120" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:SupplementaryCharge)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9272</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 590 must not be greater than Box 505</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[590] should not exceed [505]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((../../@ReturnType = 'new') and (not(../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600I = 'yes'))) and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9273</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If return type is New then Box 590 can only be completed if Box 135 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[590] should not be present if [N003] equals 'new' and [135] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../@ReturnType = 'new')                 or  (../../ct:RingFenceTrade/ct:NetRingFenceTrade/ct:SupplementaryChargeTax and (sum(../../ct:RingFenceTrade/ct:NetRingFenceTrade/ct:SupplementaryChargeTax) = .))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9274</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the return type is New and Box 590 is completed then Box I85 must be completed and equal to Box 590.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [590] is present and [N003] equals 'new' then [I85] should be present and equal to [590]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M120" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M120" priority="-1"/>
  <axsl:template match="@*|node()" mode="M120" priority="-2">
    <axsl:apply-templates mode="M120" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p121-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:TaxOutstandingOrOverpaid/ct:TaxOutstanding" mode="M121" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable - (sum(../../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../../ct:LandOrLifeCredit) + sum(../../ct:CapitalAllowancesFirstYearCredit) + sum(../../ct:TaxAlreadyPaid))) - (0) &gt; -0.001) and (math:abs((.) - (../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable - (sum(../../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../../ct:LandOrLifeCredit) + sum(../../ct:CapitalAllowancesFirstYearCredit) + sum(../../ct:TaxAlreadyPaid)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9276</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 600 must equal Box 525 minus (the sum of Boxes 545, 560, 565 and 595). If the result is negative them Box 600 must not be completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[600] must equal [525] minus the sum of [545], [560], [565] and [595], where the result is equal to or greater than zero. Must not be present if [525] minus the sum of [545], [560], [565] and [595] is negative</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M121" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M121" priority="-1"/>
  <axsl:template match="@*|node()" mode="M121" priority="-2">
    <axsl:apply-templates mode="M121" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p122-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:TaxOutstandingOrOverpaid/ct:TaxOverpaid" mode="M122" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../../ct:LandOrLifeCredit) + sum(../../ct:CapitalAllowancesFirstYearCredit) + sum(../../ct:TaxAlreadyPaid) - ../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable) - (0) &gt; -0.001) and (math:abs((.) - (sum(../../ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit) + sum(../../ct:LandOrLifeCredit) + sum(../../ct:CapitalAllowancesFirstYearCredit) + sum(../../ct:TaxAlreadyPaid) - ../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:TaxPayable)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9277</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 605 must equal (the sum of Boxes 545, 560, 565 and 595) minus Box 525. If the result is negative Box 605 must not be completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[605] must equal the sum of [545], [560], [565] and [595] minus [525], where the result is equal to or greater than zero. Must not be present if the sum of [545], [560], [565] and [595] minus [525] is negative</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M122" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M122" priority="-1"/>
  <axsl:template match="@*|node()" mode="M122" priority="-2">
    <axsl:apply-templates mode="M122" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p120-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:TaxOutstandingOrOverpaid" mode="M123" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:TaxOutstanding)                       or                     not(ct:TaxOverpaid)                       or                     (ct:TaxOutstanding = 0 and ct:TaxOverpaid = 0 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9275</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Only one of Boxes 600 and 605 can be completed unless both are zero (0). </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[600] and [605] should not both be present unless both are zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M123" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M123" priority="-1"/>
  <axsl:template match="@*|node()" mode="M123" priority="-2">
    <axsl:apply-templates mode="M123" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p124-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:ExporterInformation/ct:NeitherGoodsNorServicesExported" mode="M124" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:GoodsExported)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9602</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 618 must not be completed if Box 616 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[618] should not be present if [616] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:ServicesExported)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9603</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 618 must not be completed if Box 617 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[618] should not be present if [617] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M124" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M124" priority="-1"/>
  <axsl:template match="@*|node()" mode="M124" priority="-2">
    <axsl:apply-templates mode="M124" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p123-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation/ct:ExporterInformation" mode="M125" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:GoodsExported or ct:ServicesExported or ct:NeitherGoodsNorServicesExported"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9601</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the 'Exporter information' section is present then at least one of Boxes 616, 617 or 618 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N118] is present the following should be true: [616] is present or [617] is present or [618] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M125" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M125" priority="-1"/>
  <axsl:template match="@*|node()" mode="M125" priority="-2">
    <axsl:apply-templates mode="M125" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p108-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TaxReconciliation" mode="M126" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:ResearchAndDevelopmentCredit) or ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9355</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 530 is completed then Box 545 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[545] should be present if [530] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:VaccineCredit) or ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9356</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 535 is completed then Box 545 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[545] should be present if [535] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CreativeCredit) or ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9357</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 540 is completed then Box 545 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[545] should be present if [540] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:LandRemediationCredit) or ct:LandOrLifeCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9358</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 550 is completed then Box 560 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[560] should be present if [550] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:LifeAssuranceCompanyCredit) or ct:LandOrLifeCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9359</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 555 is completed then Box 560 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[560] should be present if [555] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:AVECandVGEC) or ct:ResearchAndDevelopmentVaccineOrCreativeTaxCredit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9875</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 545 must be completed if Box 541 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[545] should be present if [541] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M126" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M126" priority="-1"/>
  <axsl:template match="@*|node()" mode="M126" priority="-2">
    <axsl:apply-templates mode="M126" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p125-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:IndicatorsAndInformation/ct:NumberOf51groupCompanies" mode="M127" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9436</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 625 must not be completed if the return period end date in Box 35 is on or after 01/04/2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[625] should not be present if [35] on or after '2023-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M127" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M127" priority="-1"/>
  <axsl:template match="@*|node()" mode="M127" priority="-2">
    <axsl:apply-templates mode="M127" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p126-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:IndicatorsAndInformation/ct:VeryLargeQIPs" mode="M128" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:InstalmentPayments)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9122</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 631 must not be completed if Box 630 is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[631] should not be present if [630] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M128" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M128" priority="-1"/>
  <axsl:template match="@*|node()" mode="M128" priority="-2">
    <axsl:apply-templates mode="M128" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p128-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:SMEclaim" mode="M129" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((../ct:LargeCompanyClaim = 'yes') and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9282</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 650 must not be completed if Box 655 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[650] should not be present if [655] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M129" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M129" priority="-1"/>
  <axsl:template match="@*|node()" mode="M129" priority="-2">
    <axsl:apply-templates mode="M129" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p129-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:RAndDIntensiveSMEclaim" mode="M130" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2023-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9876</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 653 must not be completed if the return period end date in Box 35 is on or before 31/03/2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[653] should not be present if [35] on or before '2023-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:SMEclaim = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9877</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 653 can only be completed if Box 650 completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[653] should not be present if [650] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M130" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M130" priority="-1"/>
  <axsl:template match="@*|node()" mode="M130" priority="-2">
    <axsl:apply-templates mode="M130" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p130-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:LargeCompanyClaim" mode="M131" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((../ct:SMEclaim = 'yes') and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9284</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 655 must not be completed if Box 650 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[655] should not be present if [650] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M131" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M131" priority="-1"/>
  <axsl:template match="@*|node()" mode="M131" priority="-2">
    <axsl:apply-templates mode="M131" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p131-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:AdditionalRAndDForm" mode="M132" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../ct:SMEclaim = 'yes') or (../ct:LargeCompanyClaim = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9437</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 657 is completed then either Box 650 or Box 655 must be completed </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [657] is present the following should be true: ( [650] equals 'yes' ) or ( [655] equals 'yes' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M132" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M132" priority="-1"/>
  <axsl:template match="@*|node()" mode="M132" priority="-2">
    <axsl:apply-templates mode="M132" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p132-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:AdditionalCreativesForm" mode="M133" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../ct:SMEclaim = 'yes') or (../ct:LargeCompanyClaim = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9878</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 658 can only be completed if either Box 650 or Box 655 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [658] is present the following should be true: ( [650] equals 'yes' ) or ( [655] equals 'yes' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M133" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M133" priority="-1"/>
  <axsl:template match="@*|node()" mode="M133" priority="-2">
    <axsl:apply-templates mode="M133" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p133-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:RAndDExpenditureSME" mode="M134" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:SMEclaim = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9438</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 659 must not be completed if Box 650 isn't completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[659] should not be present if [650] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../ct:ResearchAndDevelopment/ct:SME/ct:RandDexpenditure)               or (round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2023-04-01')) div 86400))               or (math:abs((.) - (sum(../../ct:ResearchAndDevelopment/ct:SME/ct:RandDexpenditure))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9439</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box L166 is completed and the return period start date in Box 30 is on or after 01/04/2023 then Box 659 must equal Box L166</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [L166] is present and [30] onOrAfter '2023-04-01' [659] must equal [L166]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((round(date:seconds(normalize-space('2024-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) and (not(../ct:RAndDIntensiveSMEclaim = 'yes')))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9879</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 659 must not be completed if Box 653 is not completed and the return period start date in Box 30 is on or after 01/04/2024</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[659] should not be present if ( [30] on or after '2024-04-01' ) and ( [653] does not equal 'yes' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M134" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M134" priority="-1"/>
  <axsl:template match="@*|node()" mode="M134" priority="-2">
    <axsl:apply-templates mode="M134" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p134-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:RandDEnhancedExpenditure" mode="M135" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:SMEclaim = 'yes' or ../ct:LargeCompanyClaim = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9364</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 660 must only be completed if either Box 650 or Box 655 are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [660] is present then [650] should equal 'yes' or [655] should equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not(../ct:RAndDExpenditureSME) and ((round(date:seconds(normalize-space('2023-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9440</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 660 must not be completed if Box 659 is not completed and the return period start date in Box 30 is on or after 01/04/2023 </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[660] should not be present if [659] is not present and [30] is on or after '2023-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(((round(date:seconds(normalize-space('2024-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) and (not(../ct:RAndDIntensiveSMEclaim = 'yes')))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9880</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 660 must not be completed if Box 653 is not completed and the return period start date in Box 30 is on or after 01/04/2024</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[660] should not be present if ( [30] on or after '2024-04-01' ) and ( [653] does not equal 'yes' )</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M135" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M135" priority="-1"/>
  <axsl:template match="@*|node()" mode="M135" priority="-2">
    <axsl:apply-templates mode="M135" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p135-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:RandDAndCreativeEnhancedExpenditure" mode="M136" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:RandDEnhancedExpenditure) + sum(../ct:CreativeEnhancedExpenditure)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9365</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 670 must equal the sum of Boxes 660 and 665</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[670] should equal [660] plus [665]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M136" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M136" priority="-1"/>
  <axsl:template match="@*|node()" mode="M136" priority="-2">
    <axsl:apply-templates mode="M136" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p136-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:SMEclaimAsLargeCompany" mode="M137" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:SMEclaim = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9287</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 675 can only be completed if Box 650 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[650] should equal 'yes' if [675] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2024-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9881</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 675 must not be completed if the return period start date in Box 30 is on or after 01/04/2024</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[675] should not be present if [30] on or after '2024-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M137" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M137" priority="-1"/>
  <axsl:template match="@*|node()" mode="M137" priority="-2">
    <axsl:apply-templates mode="M137" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p137-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure/ct:VaccineResearch" mode="M138" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(../ct:SMEclaim = 'yes') or (../ct:LargeCompanyClaim = 'yes')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9286</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 680 must only be completed if either Box 650 or Box 655 are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [680] is present then [650] should equal 'yes' or [655] should equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9285</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 680 must not be completed if the return period start date in Box 30 is on or after 1 April 2017</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[680] should not be present if [30] is on or after '2017-04-01'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M138" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M138" priority="-1"/>
  <axsl:template match="@*|node()" mode="M138" priority="-2">
    <axsl:apply-templates mode="M138" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p127-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:EnhancedExpenditure" mode="M139" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:RandDEnhancedExpenditure) or ct:RandDAndCreativeEnhancedExpenditure"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9362</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 660 is completed then Box 670 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[670] should be present if [660] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CreativeEnhancedExpenditure) or ct:RandDAndCreativeEnhancedExpenditure"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9363</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box 665 is completed then Box 670 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[670] should be present if [665] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M139" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M139" priority="-1"/>
  <axsl:template match="@*|node()" mode="M139" priority="-2">
    <axsl:apply-templates mode="M139" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p139-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:FullExpensing" mode="M140" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2023-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9870</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 688 and 689 must not be completed if the return period end date in Box 35 is on or before 31 March 2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[688/689] should not be present if [35] on or before '2023-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M140" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M140" priority="-1"/>
  <axsl:template match="@*|node()" mode="M140" priority="-2">
    <axsl:apply-templates mode="M140" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p140-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:MachineryAndPlantSuperDeduction" mode="M141" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9606</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 691 and 692 must not completed if the return period end date in Box 35 is on before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[691/692] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (../../ct:QualifyingExpenditure/ct:MachineryAndPlantSuperDeduction)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9607</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 772 must be completed if Box 691 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[772] must be submitted if the "CapitalAllowances" component of [691/692] is submitted</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M141" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M141" priority="-1"/>
  <axsl:template match="@*|node()" mode="M141" priority="-2">
    <axsl:apply-templates mode="M141" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p141-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:MachineryAndPlantSpecialRateAllowance" mode="M142" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9608</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 693 and 694 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[693/694] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (../../ct:QualifyingExpenditure/ct:MachineryAndPlantSpecialRateAllowance)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9609</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 773 must be completed if Box 693 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[773] must be submitted if the "CapitalAllowances" component of [693/694] is submitted</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M142" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M142" priority="-1"/>
  <axsl:template match="@*|node()" mode="M142" priority="-2">
    <axsl:apply-templates mode="M142" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p142-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:StructuresAndBuildingsCapitalAllowances" mode="M143" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2018-10-29')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9260</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 711 can only be completed if the return period end date in Box 35 is on or after 29 October 2018</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[711] can only be present if [35] on or after '2018-10-29'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M143" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M143" priority="-1"/>
  <axsl:template match="@*|node()" mode="M143" priority="-2">
    <axsl:apply-templates mode="M143" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p143-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:ElectricChargePoints" mode="M144" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2016-11-23')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9278</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 713 and 714 can only be completed if the return period end date in Box 35 is on or after 23 November 2016</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[713/714] can only be present if [35] on or after '2016-11-23'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M144" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M144" priority="-1"/>
  <axsl:template match="@*|node()" mode="M144" priority="-2">
    <axsl:apply-templates mode="M144" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p144-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:BusinessPremisesRenovationIncluded" mode="M145" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9289</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 715 and 720 must not be completed if the return period start date in Box 30 is on or after 1 April 2017</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[715/720] should not be present if [30] is on or after '2017-04-01'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M145" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M145" priority="-1"/>
  <axsl:template match="@*|node()" mode="M145" priority="-2">
    <axsl:apply-templates mode="M145" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p145-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:ZeroEmissionsGoodsVehicles" mode="M146" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2025-04-01')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9387</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 723 must not be completed if the return period start date in Box 30 is on or after 1 April 2025</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The "CapitalAllowances" component of [723/724] must not be submitted if [30] is on or after '2025-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M146" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M146" priority="-1"/>
  <axsl:template match="@*|node()" mode="M146" priority="-2">
    <axsl:apply-templates mode="M146" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p146-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges/ct:ZeroEmissionsCars" mode="M147" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2025-04-01')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9388</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 726 must not be completed if the return period start date in Box 30 is on or after 1 April 2025</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The "CapitalAllowances" component of [726/727] must not be submitted if [30] is on or after '2025-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9839</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 726 and 727 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[726/727] should not be present if [35] is on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M147" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M147" priority="-1"/>
  <axsl:template match="@*|node()" mode="M147" priority="-2">
    <axsl:apply-templates mode="M147" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p138-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:AllowancesAndCharges" mode="M148" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(                 (((sum(ct:AIACapitalAllowancesInc) + sum(../ct:NotIncluded/ct:AIACapitalAllowancesNotInc))) - (( (   ceiling(     (   number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *   (     (       number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space('2015-04-01')) div 86400))     ) + (       number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (round(date:seconds(normalize-space('2016-01-01')) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (round(date:seconds(normalize-space('2016-01-01')) div 86400) - round(date:seconds(normalize-space('2015-04-01')) div 86400))     )   ) * 500000     div       (366 -   number(     (       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))       and         (round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )     )     or ((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)) + 1 &lt; 366)   ))      )   )   +   ceiling(     (   number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *   (     (       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space('2016-01-01')) div 86400))     ) + (       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (round(date:seconds(normalize-space('2019-01-01')) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (round(date:seconds(normalize-space('2019-01-01')) div 86400) - round(date:seconds(normalize-space('2016-01-01')) div 86400))     )   ) * 200000     div       (366 -   number(     (       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))       and         (round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )     )     or ((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)) + 1 &lt; 366)   ))      )   )   +   ceiling(     (   number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    (     (       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (round(date:seconds(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D')))) div 86400) - round(date:seconds(normalize-space('2019-01-01')) div 86400))     )  ) * 1000000     div       (366 -   number(     (       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))       and         (round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )       or       (         (round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))       and         (round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))       )     )     or ((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) - round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)) + 1 &lt; 366)   ))      )   ) ) )) &lt; 0.001)               )                 or               (                 (                   date:day-in-month(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) = 1 and date:day-in-month(normalize-space(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1DT12H')))) = 1                 )                   and                 (                   (((sum(ct:AIACapitalAllowancesInc) + sum(../ct:NotIncluded/ct:AIACapitalAllowancesNotInc))) - (((   ceiling(     (   number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *   (     (       number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year(../ct:CompanyInformation/ct:PeriodCovered/ct:From))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year('2015-04-01')) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year('2015-04-01'))     ) + (       number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (12 * (date:year('2016-01-01') - date:year(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) + date:month-in-year('2016-01-01') - date:month-in-year(../ct:CompanyInformation/ct:PeriodCovered/ct:From))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2015-04-01')) div 86400))) *       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (12 * (date:year('2016-01-01') - date:year('2015-04-01')) + date:month-in-year('2016-01-01') - date:month-in-year('2015-04-01'))     )   ) * 500000     div     12     )   )   +   ceiling(     (   number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *   (     (       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year(../ct:CompanyInformation/ct:PeriodCovered/ct:From))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year('2016-01-01')) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year('2016-01-01'))     ) + (       number((round(date:seconds(normalize-space('2016-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (12 * (date:year('2019-01-01') - date:year(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) + date:month-in-year('2019-01-01') - date:month-in-year(../ct:CompanyInformation/ct:PeriodCovered/ct:From))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2016-01-01')) div 86400))) *       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *       (12 * (date:year('2019-01-01') - date:year('2016-01-01')) + date:month-in-year('2019-01-01') - date:month-in-year('2016-01-01'))     )   ) * 200000     div     12     )   )   +   ceiling(     (   number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))) *    (     (       number((round(date:seconds(normalize-space('2019-01-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year(../ct:CompanyInformation/ct:PeriodCovered/ct:From))     ) + (       number((round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2019-01-01')) div 86400))) *       (12 * (date:year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:year('2019-01-01')) + date:month-in-year(date:add(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To),normalize-space('P1D'))) - date:month-in-year('2019-01-01'))     )  ) * 1000000     div     12     )   ) ) )) &lt; 0.001)                 )                )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9288</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The sum of Boxes 690 and 735 must not exceed the apportioned AIA limit</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The sum of [690] and [735] must not exceed the apportioned AIA limit (see Appendix C)</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M148" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M148" priority="-1"/>
  <axsl:template match="@*|node()" mode="M148" priority="-2">
    <axsl:apply-templates mode="M148" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p147-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:FullExpensing" mode="M149" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2023-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9871</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 733 and 734 must not be completed if the return period end date in Box 35 is on or before 31 March 2023</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[733/734] should not be present if [35] on or before '2023-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M149" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M149" priority="-1"/>
  <axsl:template match="@*|node()" mode="M149" priority="-2">
    <axsl:apply-templates mode="M149" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p148-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:StructuresAndBuildingsCapitalAllowances" mode="M150" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2018-10-29')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9291</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 736 can only be completed if the date in box 35 is on or after 29 October 2018</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[736] can only be present if [35] on or after '2018-10-29'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M150" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M150" priority="-1"/>
  <axsl:template match="@*|node()" mode="M150" priority="-2">
    <axsl:apply-templates mode="M150" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p149-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:ElectricChargePoints" mode="M151" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2016-11-23')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9377</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 737/738 can only be completed if the date in box 35 is on or after 23 November 2016</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[737/738] can only be present if [35] on or after '2016-11-23'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M151" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M151" priority="-1"/>
  <axsl:template match="@*|node()" mode="M151" priority="-2">
    <axsl:apply-templates mode="M151" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p150-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:BusinessPremisesRenovationNotIncluded" mode="M152" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2017-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9290</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 740 and 745 must not be completed if the return period start date in Box 30 is on or after 1 April 2017</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[740/745] should not be present if [30] is on or after '2017-04-01'.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M152" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M152" priority="-1"/>
  <axsl:template match="@*|node()" mode="M152" priority="-2">
    <axsl:apply-templates mode="M152" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p151-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:MachineryAndPlantSuperDeduction" mode="M153" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400))) or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9610</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 741 and 742 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[741/742] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (../../ct:QualifyingExpenditure/ct:MachineryAndPlantSuperDeduction)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9616</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 772 must be completed if Box 741 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[772] must be submitted if the "CapitalAllowances" component of [741/742] is submitted</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M153" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M153" priority="-1"/>
  <axsl:template match="@*|node()" mode="M153" priority="-2">
    <axsl:apply-templates mode="M153" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p152-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:MachineryAndPlantSpecialRateAllowance" mode="M154" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400))) or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9617</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 743 and 744 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[743/744] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (../../ct:QualifyingExpenditure/ct:MachineryAndPlantSpecialRateAllowance)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9618</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 773 must be completed if Box 743 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[773] must be submitted if the "CapitalAllowances" component of [743/744] is submitted</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M154" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M154" priority="-1"/>
  <axsl:template match="@*|node()" mode="M154" priority="-2">
    <axsl:apply-templates mode="M154" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p153-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:ZeroEmissionsGoodsVehicles" mode="M155" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2025-04-01')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9390</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 748 must not be completed if the return period start date in Box 30 is on or after 1 April 2025</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The "CapitalAllowances" component of [748/749] must not be submitted if [30] is on or after '2025-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M155" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M155" priority="-1"/>
  <axsl:template match="@*|node()" mode="M155" priority="-2">
    <axsl:apply-templates mode="M155" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p154-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NotIncluded/ct:ZeroEmissionsCars" mode="M156" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CapitalAllowances) or (round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2025-04-01')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9391</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 751 must not be completed if the return period start date in Box 30 is on or after 1 April 2025</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The "CapitalAllowances" component of [751/752] should not be present if [30] is on or after '2025-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9392</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 751 and 752 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[751/752] should not be present if [35] is on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M156" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M156" priority="-1"/>
  <axsl:template match="@*|node()" mode="M156" priority="-2">
    <axsl:apply-templates mode="M156" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p155-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:QualifyingExpenditure/ct:DesignatedEnvironmentallyFriendlyMachineryAndPlant" mode="M157" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt;= round(date:seconds(normalize-space('2020-03-31')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9379</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 765 can only be completed if the return period start date in Box 30 is on or before 31 March 2020</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[765] can only be present if [30] on or before '2020-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M157" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M157" priority="-1"/>
  <axsl:template match="@*|node()" mode="M157" priority="-2">
    <axsl:apply-templates mode="M157" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p156-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:QualifyingExpenditure/ct:StructuresAndBuildings" mode="M158" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2018-10-29')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9412</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 771 can only be completed if the return period end date in Box 35 is on or after 29 October 2018</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[771] can only be present if [35] on or after '2018-10-29'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M158" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M158" priority="-1"/>
  <axsl:template match="@*|node()" mode="M158" priority="-2">
    <axsl:apply-templates mode="M158" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p157-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:QualifyingExpenditure/ct:MachineryAndPlantSuperDeduction" mode="M159" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400))) or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9619</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 772 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[772] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M159" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M159" priority="-1"/>
  <axsl:template match="@*|node()" mode="M159" priority="-2">
    <axsl:apply-templates mode="M159" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p158-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:QualifyingExpenditure/ct:MachineryAndPlantSpecialRateAllowance" mode="M160" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space('2021-03-31')) div 86400))) or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9620</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 773 must not be completed if the return period end date in Box 35 is on or before 31 March 2021</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[773] should not be present if [35] on or before '2021-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M160" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M160" priority="-1"/>
  <axsl:template match="@*|node()" mode="M160" priority="-2">
    <axsl:apply-templates mode="M160" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p159-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LossesDeficitsAndExcess/ct:AmountArising/ct:LossesOfTradesUK/ct:SurrenderMaximum" mode="M161" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Arising) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9952</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' is completed so the amount 'Arising' must be greater than zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the arising and maximum pair, there must be an entry greater than zero in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Arising)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9953</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' must not be greater than the amount 'Arising'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the pair, it must not be greater than the entry in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M161" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M161" priority="-1"/>
  <axsl:template match="@*|node()" mode="M161" priority="-2">
    <axsl:apply-templates mode="M161" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p160-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LossesDeficitsAndExcess/ct:AmountArising/ct:Loans/ct:SurrenderMaximum" mode="M162" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Arising) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9952</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' is completed so the amount 'Arising' must be greater than zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the arising and maximum pair, there must be an entry greater than zero in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Arising)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9953</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' must not be greater than the amount 'Arising'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the pair, it must not be greater than the entry in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M162" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M162" priority="-1"/>
  <axsl:template match="@*|node()" mode="M162" priority="-2">
    <axsl:apply-templates mode="M162" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p161-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LossesDeficitsAndExcess/ct:AmountArising/ct:UKpropertyBusinessLosses/ct:SurrenderMaximum" mode="M163" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Arising) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9952</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' is completed so the amount 'Arising' must be greater than zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the arising and maximum pair, there must be an entry greater than zero in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Arising)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9953</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' must not be greater than the amount 'Arising'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the pair, it must not be greater than the entry in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M163" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M163" priority="-1"/>
  <axsl:template match="@*|node()" mode="M163" priority="-2">
    <axsl:apply-templates mode="M163" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p162-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LossesDeficitsAndExcess/ct:AmountArising/ct:NonTradingLossesIntangibles/ct:SurrenderMaximum" mode="M164" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Arising) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9952</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' is completed so the amount 'Arising' must be greater than zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the arising and maximum pair, there must be an entry greater than zero in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Arising)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9953</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' must not be greater than the amount 'Arising'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the pair, it must not be greater than the entry in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M164" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M164" priority="-1"/>
  <axsl:template match="@*|node()" mode="M164" priority="-2">
    <axsl:apply-templates mode="M164" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p163-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LossesDeficitsAndExcess/ct:ExcessAmounts/ct:ManagementExpenses/ct:SurrenderMaximum" mode="M165" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../ct:Arising) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9952</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' is completed so the amount 'Arising' must be greater than zero.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the arising and maximum pair, there must be an entry greater than zero in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:Arising)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9953</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Maximum available for surrender as group relief' must not be greater than the amount 'Arising'.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If there is an entry in the second box of the pair, it must not be greater than the entry in the first box of the pair.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M165" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M165" priority="-1"/>
  <axsl:template match="@*|node()" mode="M165" priority="-2">
    <axsl:apply-templates mode="M165" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p165-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIrelandInformation/ct:NIagainstUK" mode="M166" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9163</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 856 can only be completed if Box 310 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [856] is present, [310] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M166" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M166" priority="-1"/>
  <axsl:template match="@*|node()" mode="M166" priority="-2">
    <axsl:apply-templates mode="M166" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p166-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIrelandInformation/ct:NIagainstNI" mode="M167" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9164</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 857 can only be completed if Box 310 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [857] is present, [310] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M167" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M167" priority="-1"/>
  <axsl:template match="@*|node()" mode="M167" priority="-2">
    <axsl:apply-templates mode="M167" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p167-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIrelandInformation/ct:UKagainstNI" mode="M168" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9165</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 858 can only be completed if Box 310 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [858] is present, [310] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M168" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M168" priority="-1"/>
  <axsl:template match="@*|node()" mode="M168" priority="-2">
    <axsl:apply-templates mode="M168" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p164-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIrelandInformation" mode="M169" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space('2050-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9162</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes 856, 857 and 858 can only be completed if the 'To' date in Box 35 is on or after 01 April 2050</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N203] is present then [35] must be on or after '2050-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M169" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M169" priority="-1"/>
  <axsl:template match="@*|node()" mode="M169" priority="-2">
    <axsl:apply-templates mode="M169" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p168-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:IncomeTax" mode="M170" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:IncomeTax/ct:TaxRepayable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9296</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 870 must equal Box 520</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[870] should equal [520]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M170" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M170" priority="-1"/>
  <axsl:template match="@*|node()" mode="M170" priority="-2">
    <axsl:apply-templates mode="M170" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p169-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDTaxCredit" mode="M171" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600L = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9393</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 875 must only be completed if Box 142 equals 'yes'</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[875] should only be present if [142] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:ResearchAndDevelopment/ct:SME/ct:RandDBalancePayableTaxCredit)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9394</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 875 must equal Box L180</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[875] should equal [L180]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M171" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M171" priority="-1"/>
  <axsl:template match="@*|node()" mode="M171" priority="-2">
    <axsl:apply-templates mode="M171" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p170-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDExpenditureCredit" mode="M172" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600L = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9395</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 880 must only be completed if Box 142 equals 'yes'</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[880] should only be present if [142] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:ResearchAndDevelopment/ct:Step7/ct:PayableRDEC)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9396</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 880 must equal Box L125</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[880] should equal [L125]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M172" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M172" priority="-1"/>
  <axsl:template match="@*|node()" mode="M172" priority="-2">
    <axsl:apply-templates mode="M172" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p171-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:CreativeCredit" mode="M173" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../../ct:TaxReconciliation/ct:SurplusResearchAndDevelopmentCreditsOrCreativeCreditPayable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9300</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 885 must not be greater than Box 570</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[885] should not exceed [570]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M173" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M173" priority="-1"/>
  <axsl:template match="@*|node()" mode="M173" priority="-2">
    <axsl:apply-templates mode="M173" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p172-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:LandRemediationCredit" mode="M174" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:TaxReconciliation/ct:LandOrLifeCreditPayable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9301</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 890 must equal Box 575</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[890] should equal [575]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M174" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M174" priority="-1"/>
  <axsl:template match="@*|node()" mode="M174" priority="-2">
    <axsl:apply-templates mode="M174" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p173-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RepaymentsForThePeriodCoveredByThisReturn/ct:PayableCapitalAllowancesFirstYearCredit" mode="M175" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:TaxReconciliation/ct:CapitalAllowancesFirstYearCreditPayable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9302</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 895 must equal Box 580</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[895] should equal [580]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt;= round(date:seconds(normalize-space('2020-03-31')) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9413</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 895 can only be completed if the return period start date in Box 30 is on or before 31 March 2020</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[895] can only be present if [30] on or before '2020-03-31'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M175" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M175" priority="-1"/>
  <axsl:template match="@*|node()" mode="M175" priority="-2">
    <axsl:apply-templates mode="M175" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p174-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:Surrender/ct:JointNotice/ct:Attached" mode="M176" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:AttachedFiles/ct:Attachment"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9303</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">You must attach the Joint Notice if Box 905 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[N106] should be present if [905] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M176" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M176" priority="-1"/>
  <axsl:template match="@*|node()" mode="M176" priority="-2">
    <axsl:apply-templates mode="M176" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p175-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:Surrender/ct:StopUntilNotice" mode="M177" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= ../ct:Amount"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9304</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 915 must not be greater than Box 900</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[915] should not exceed [900]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M177" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M177" priority="-1"/>
  <axsl:template match="@*|node()" mode="M177" priority="-2">
    <axsl:apply-templates mode="M177" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p176-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:RAndDCreditWithCondition" mode="M178" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2024-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)) and not(../ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDTaxCredit or ../ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDExpenditureCredit))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9882</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box 943 must not be completed if Box 875 and Box 880 are not completed and the return period start date in Box 30 is on or after 01/04/2024</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[943] should not be present if [875] is not present and [880] is not present and [30] is on or after '2024-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M178" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M178" priority="-1"/>
  <axsl:template match="@*|node()" mode="M178" priority="-2">
    <axsl:apply-templates mode="M178" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p177-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:OverpaymentsAndRepayments/ct:PaymentToPerson" mode="M179" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space('2024-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)) and not(../ct:RAndDCreditWithCondition = 'yes') and (../ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDTaxCredit or ../ct:RepaymentsForThePeriodCoveredByThisReturn/ct:RandDExpenditureCredit))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9883</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If either of Boxes 875 or 880 are completed and the return period start date in Box 30 is on or after 01/04/2024 then the section 'Payments to a person other than the company' can only be completed if Box 943 completed. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[N087] should not be present if [943] is absent and either [875] or [880] are present and [30] is on or after '2024-04-01'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M179" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M179" priority="-1"/>
  <axsl:template match="@*|node()" mode="M179" priority="-2">
    <axsl:apply-templates mode="M179" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p180-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoansInformation/ct:TotalLoans" mode="M180" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Loan/ct:AmountOfLoan))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9401</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A15 must equal the sum of all 'Amount of loan' amounts in column A10B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A15] should equal the sum of all iterations of [A10B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M180" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M180" priority="-1"/>
  <axsl:template match="@*|node()" mode="M180" priority="-2">
    <axsl:apply-templates mode="M180" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p181-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoansInformation/ct:TaxChargeable" mode="M181" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001))               or             (math:abs((.) - (round((../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 )) * 100) div 100)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9466</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate does not change in the accounting period of the return then Box A20 must equal Box A15 multiplied by the loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] does not change in the period [30] to [35] inclusive: [A20] should equal [A15] at [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9467</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A20 must be equal to or greater than Box A15 multiplied by the lowest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A20] should be at least ([A15] at the lowest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards).</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9468</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A20 must be equal to or less than Box A15 multiplied by the highest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A20] should be at most [A15] at the highest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M181" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M181" priority="-1"/>
  <axsl:template match="@*|node()" mode="M181" priority="-2">
    <axsl:apply-templates mode="M181" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p179-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoansInformation" mode="M182" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(ct:Loan) &lt;= 999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9400</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The maximum number of loans has been exceeded in Part 1</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The group [LOAN] may occur up to 999 times</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M182" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M182" priority="-1"/>
  <axsl:template match="@*|node()" mode="M182" priority="-2">
    <axsl:apply-templates mode="M182" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p184-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:Loan/ct:Date" mode="M183" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(date:add(normalize-space((.)),normalize-space('-P9M1D')))) div 86400) &lt; round(date:seconds(normalize-space(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9406</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Date of repayment, release or write-off' in Box A25D must be less than nine months and one day after the period To date in Box 35. </axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A25D] must be before nine months and one day after [35]. If [35] is on the last day of the month, [A25D] must be before the first day of the month ten months after [35].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt; round(date:seconds(normalize-space((.))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9429</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Date of repayment, release or write-off' in Box A25D must be after the period To date in Box 35.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A25D] should be after [35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(date:date())) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9884</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Date of repayment, release or write-off' in Box A25D must not be later than today.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A25D] should be no later than today.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M183" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M183" priority="-1"/>
  <axsl:template match="@*|node()" mode="M183" priority="-2">
    <axsl:apply-templates mode="M183" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p183-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:Loan" mode="M184" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(sum(ct:AmountRepaid) &gt; 0) or (sum(ct:AmountReleasedOrWrittenOff) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9404</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">At least one of 'Amount repaid/return repayments made' in Box A25B or 'Amount released or written off' in Box A25C must be greater than 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Within each iteration of [A25] at least one of [A25B] and [A25C] should be greater than 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:LoansInformation"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9405</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Part 2: Relief for return payments and/or amounts repaid, released or written off within 9 months' is completed then 'Part 1: Outstanding loans and arrangements' made must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[LOANSINFORMATION] should be present if [A25] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M184" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M184" priority="-1"/>
  <axsl:template match="@*|node()" mode="M184" priority="-2">
    <axsl:apply-templates mode="M184" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p185-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:TotalAmountRepaid" mode="M185" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Loan/ct:AmountRepaid))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9407</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A30 must equal the sum of all 'Amounts repaid/return repayments made' in Boxes A25B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A30] should equal the sum of all iterations of [A25B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M185" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M185" priority="-1"/>
  <axsl:template match="@*|node()" mode="M185" priority="-2">
    <axsl:apply-templates mode="M185" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p186-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:TotalAmountReleasedOrWritten" mode="M186" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Loan/ct:AmountReleasedOrWrittenOff))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9408</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A35 must equal the sum of all 'Amounts released or written off' made in Boxes A25C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A35] should equal the sum of all iterations of [A25C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M186" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M186" priority="-1"/>
  <axsl:template match="@*|node()" mode="M186" priority="-2">
    <axsl:apply-templates mode="M186" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p187-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:TotalLoans" mode="M187" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TotalAmountRepaid) + sum(../ct:TotalAmountReleasedOrWritten)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9409</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A40 must equal the sum of Boxes A30 and A35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A40] should equal [A30] plus [A35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M187" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M187" priority="-1"/>
  <axsl:template match="@*|node()" mode="M187" priority="-2">
    <axsl:apply-templates mode="M187" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p188-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan/ct:ReliefDue" mode="M188" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:LoansInformation/ct:TaxChargeable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9411</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A45 must not be greater than Box A20</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A45] should not exceed [A20]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001))               or             (math:abs((.) - (round((../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 )) * 100) div 100)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9469</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate does not change in the accounting period of the return then Box A45 must equal Box A40 multiplied by the loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] does not change in the period [30] to [35] inclusive: [A45] should equal [A40] at [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9470</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A45 must be equal to or greater than Box A40 multiplied by the lowest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A45] should be at least [A40] at the lowest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9471</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A45 must be equal to or less than Box A40 multiplied by the highest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A45] should be at most [A40] at the highest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M188" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M188" priority="-1"/>
  <axsl:template match="@*|node()" mode="M188" priority="-2">
    <axsl:apply-templates mode="M188" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p182-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:ReliefEarlierThan" mode="M189" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(ct:Loan) &lt;= 999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9403</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The maximum number of loans has been exceeded in Part 2</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A25] may occur up to 999 times</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M189" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M189" priority="-1"/>
  <axsl:template match="@*|node()" mode="M189" priority="-2">
    <axsl:apply-templates mode="M189" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p191-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:Loan/ct:Date" mode="M190" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400) &lt;= round(date:seconds(normalize-space(date:add(normalize-space((.)),normalize-space('-P9M1D')))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9430</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Date of repayment, release or write-off' in Box A50D must be at least nine months after the period To date in Box 35.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Must be after the date nine months after [35]. If [35] is on the last day of the month, [A50D] must be later than the last day of the month nine months after [35].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(.)) div 86400) &lt;= round(date:seconds(normalize-space(date:date())) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9431</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Date of repayment, release or write-off' in Box A50D cannot be later than today</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A50D] cannot be later than today</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M190" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M190" priority="-1"/>
  <axsl:template match="@*|node()" mode="M190" priority="-2">
    <axsl:apply-templates mode="M190" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p190-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:Loan" mode="M191" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(sum(ct:AmountRepaid) &gt; 0) or (sum(ct:AmountReleasedOrWrittenOff) &gt; 0)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9419</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">At least one of 'Amount repaid/return repayments made' in Box A50B or 'Amount released or written off' in Box A50C must be greater than 0 (zero).</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Within each iteration of [A50], at least one of [A50B] and [A50C] should be greater than 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M191" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M191" priority="-1"/>
  <axsl:template match="@*|node()" mode="M191" priority="-2">
    <axsl:apply-templates mode="M191" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p192-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:TotalAmountRepaid" mode="M192" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Loan/ct:AmountRepaid))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9421</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A55 must equal the sum of all 'Amounts repaid/return repayments made' in Boxes A50B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A55] should equal the sum of all iterations of [A50B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M192" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M192" priority="-1"/>
  <axsl:template match="@*|node()" mode="M192" priority="-2">
    <axsl:apply-templates mode="M192" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p193-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:TotalAmountReleasedOrWritten" mode="M193" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Loan/ct:AmountReleasedOrWrittenOff))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9422</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A60 must equal the sum of all 'Amounts released or written off' made in Boxes A50C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A60] should equal the sum of all iterations of [A50C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M193" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M193" priority="-1"/>
  <axsl:template match="@*|node()" mode="M193" priority="-2">
    <axsl:apply-templates mode="M193" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p194-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:TotalLoans" mode="M194" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TotalAmountRepaid) + sum(../ct:TotalAmountReleasedOrWritten)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9423</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A65 must equal the sum of Boxes A55 and A60</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A65] should equal [A55] plus [A60]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M194" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M194" priority="-1"/>
  <axsl:template match="@*|node()" mode="M194" priority="-2">
    <axsl:apply-templates mode="M194" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p195-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow/ct:ReliefDue" mode="M195" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:LoansInformation/ct:TaxChargeable)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9425</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A70 must not be greater than Box A20</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A70] should not exceed [A20]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:CT600AreliefDue = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9426</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box A70 is completed then Box 485 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[485] should be 'yes' if [A70] is greater than 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001))               or             (math:abs((.) - (round((../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 )) * 100) div 100)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9472</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate does not change in the accounting period of the return then Box A65 must equal Box A70 multiplied by the loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] does not change in the period [30] to [35] inclusive: [A70] should equal [A65] at [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &gt; -0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9473</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A65 must be equal to or greater than Box A70 multiplied by the lowest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A70] should be at least [A65] at the lowest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(not((math:abs((number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375) - (number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375)) &lt; 0.001)))                 or                 (                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:From))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 or                   ((.) - (round(../ct:TotalLoans * (    number((round(date:seconds(normalize-space('2015-04-01')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2016-04-06')) div 86400))) *     0.25  +     number((round(date:seconds(normalize-space('2016-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *      number((round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400) &lt; round(date:seconds(normalize-space('2022-04-06')) div 86400))) *     0.325  +     number((round(date:seconds(normalize-space('2022-04-06')) div 86400) &lt;= round(date:seconds(normalize-space(string(../../../ct:CompanyInformation/ct:PeriodCovered/ct:To))) div 86400))) *     0.3375 ) * 100) div 100) &lt; 0.001)                 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9474</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the loans to participator rate changes in the accounting period of the return then Box A65 must be equal to or less than Box A70 multiplied by the highest loans to participator rate for that period. Round down for fractions less than half a penny and round up for fractions of half a penny or greater</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [LOANS-PARTICIPATOR-RATE] changes in the period [30] to [35] inclusive: [A70] should be at most [A65] at the highest value of [LOANS-PARTICIPATOR-RATE] for that period, rounded to the nearest penny, with half-penny rounding upwards.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M195" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M195" priority="-1"/>
  <axsl:template match="@*|node()" mode="M195" priority="-2">
    <axsl:apply-templates mode="M195" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p189-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:LoanLaterReliefNow" mode="M196" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(ct:Loan) &lt;= 999"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9418</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The maximum number of loans has been exceeded in Part 3</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A50] may occur up to 999 times</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M196" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M196" priority="-1"/>
  <axsl:template match="@*|node()" mode="M196" priority="-2">
    <axsl:apply-templates mode="M196" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p196-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies/ct:TaxPayable" mode="M197" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((((sum(../ct:LoansInformation/ct:TaxChargeable) - sum(../ct:ReliefEarlierThan/ct:ReliefDue) - sum(../ct:LoanLaterReliefNow/ct:ReliefDue))) - (0) &gt;= 0.001)       and     (math:abs((.) - ((sum(../ct:LoansInformation/ct:TaxChargeable) - sum(../ct:ReliefEarlierThan/ct:ReliefDue) - sum(../ct:LoanLaterReliefNow/ct:ReliefDue)))) &lt; 0.001))     or     ((((sum(../ct:LoansInformation/ct:TaxChargeable) - sum(../ct:ReliefEarlierThan/ct:ReliefDue) - sum(../ct:LoanLaterReliefNow/ct:ReliefDue))) - (0) &lt; 0.001)       and (math:abs((.) - (0.00)) &lt; 0.001))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9427</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box A80 must equal Box A20 minus (the sum of Boxes A45 and A70). If the result is negative then enter 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[A80] should equal ([A20]-([A45]+[A70]))if the result is positive, otherwise [A80] should equal 0.00</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:LoansToParticipators and sum(../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:LoansToParticipators) = (.)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9428</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box A80 is completed then Box 480 must be completed and equal to Box A80</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[480] should be present and equal to [A80] if [A80] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M197" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M197" priority="-1"/>
  <axsl:template match="@*|node()" mode="M197" priority="-2">
    <axsl:apply-templates mode="M197" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p178-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:LoansByCloseCompanies" mode="M198" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600A = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9305</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600A is present so Box 95 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[95] should equal 'yes' if [N095] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M198" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M198" priority="-1"/>
  <axsl:template match="@*|node()" mode="M198" priority="-2">
    <axsl:apply-templates mode="M198" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p198-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:CompanyInformation/ct:CFCTaxCalculation/ct:CFCchargeDue" mode="M199" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((../ct:TaxOnChargeable - (sum(../ct:CreditableTax) + sum(../ct:ReliefsInTaxTerms) + sum(../ct:ACTrestricted))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9455</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">CFC charge due' in Box B5J must equal 'Tax on chargeable profits' in Box B5F minus (the sum of 'Creditable tax' in Box B5G, 'Reliefs in terms of tax' in Box B5H and 'ACT as restricted' in Box B5I)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B5J] should equal [B5F] minus the sum of [B5G], [B5H] and [B5I]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M199" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M199" priority="-1"/>
  <axsl:template match="@*|node()" mode="M199" priority="-2">
    <axsl:apply-templates mode="M199" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p199-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:TotalTaxChargeable" mode="M200" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:CompanyInformation/ct:CFCTaxCalculation/ct:TaxOnChargeable))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9456</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B10 must equal the sum of 'Tax on chargeable profits' in Boxes B5F</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B10] should equal the sum of all entries in [B5F]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M200" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M200" priority="-1"/>
  <axsl:template match="@*|node()" mode="M200" priority="-2">
    <axsl:apply-templates mode="M200" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p200-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:TotalCreditableTax" mode="M201" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:CompanyInformation/ct:CFCTaxCalculation/ct:CreditableTax))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9457</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B15 must equal the sum of 'Creditable tax' in Boxes B5G</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B15] should equal the sum of all entries in [B5G]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M201" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M201" priority="-1"/>
  <axsl:template match="@*|node()" mode="M201" priority="-2">
    <axsl:apply-templates mode="M201" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p201-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:TotalReliefInTaxTerms" mode="M202" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:CompanyInformation/ct:CFCTaxCalculation/ct:ReliefsInTaxTerms))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9458</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B20 must equal the sum of 'Reliefs in terms of tax' in Boxes B5H</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B20] should equal the sum of all entries in [B5H]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M202" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M202" priority="-1"/>
  <axsl:template match="@*|node()" mode="M202" priority="-2">
    <axsl:apply-templates mode="M202" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p202-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:TotalACTrestricted" mode="M203" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:CompanyInformation/ct:CFCTaxCalculation/ct:ACTrestricted))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9459</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B25 must equal the sum of 'ACT as restricted' in Boxes B5I</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B25] should equal the sum of all entries in [B5I]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M203" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M203" priority="-1"/>
  <axsl:template match="@*|node()" mode="M203" priority="-2">
    <axsl:apply-templates mode="M203" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p203-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:TotalCFCtaxChargeble" mode="M204" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs(((.)) - (sum(../ct:CompanyInformation/ct:CFCTaxCalculation/ct:CFCchargeDue))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9463</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B30 must equal the sum of 'CFC charge due' amounts in Boxes B5J</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B30] should equal the sum of all entries in [B5J]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:CFCtaxPayable             and           (math:abs(((.)) - (../../ct:CalculationOfTaxOutstandingOrOverpaid/ct:CFCtaxPayable)) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9465</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box B30 is completed then Box 490 must be completed and equal to Box B30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[490] should be present and equal to [B30] if [B30] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M204" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M204" priority="-1"/>
  <axsl:template match="@*|node()" mode="M204" priority="-2">
    <axsl:apply-templates mode="M204" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p204-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies/ct:HybridAndOtherMismatches" mode="M205" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:Part6Acounteraction) or ct:TotalCounteraction"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9621</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B70 must be completed if Box B65 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B70] should be present if [B65] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:HybridEntity     or ct:TransactionsWithHybridEntities     or ct:HybridDeductionMismatches     or ct:ExcessivePEdeduction     or ct:MultinationalDeductionMismatch     or ct:Part6Acounteraction     or ct:TotalCounteraction     or ct:TotalS259LAdeduction     or ct:TotalAllocationDIIsurplus     or ct:TotalDIIsurplusConsentedTo"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9622</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Hybrid and other mismatches' group is present then at least one of Boxes B40 to B85 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>Group must not be empty</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M205" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M205" priority="-1"/>
  <axsl:template match="@*|node()" mode="M205" priority="-2">
    <axsl:apply-templates mode="M205" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p197-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:ControlledForeignCompanies" mode="M206" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(ct:CompanyInformation/ct:CFCTaxCalculation/ct:TaxOnChargeable) = 0            or            ct:TotalTaxChargeable"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9450</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B10 must be completed if the sum of 'Tax on chargeable profits' in Boxes B5F is greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B10] should be present if the sum of all iterations of [B5F] is greater than zero</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CompanyInformation/ct:CFCTaxCalculation/ct:CreditableTax) or ct:TotalCreditableTax"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9451</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B15 must be completed if 'Creditable tax' in Box B5G is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B15] should be present if [B5G] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CompanyInformation/ct:CFCTaxCalculation/ct:ReliefsInTaxTerms) or ct:TotalReliefInTaxTerms"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9452</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B20 must be completed if 'Reliefs in terms of tax' in Box B5H is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B20] should be present if [B5H] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CompanyInformation/ct:CFCTaxCalculation/ct:ACTrestricted) or ct:TotalACTrestricted"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9453</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B25 must be completed if 'ACT as restricted' in Box B5I is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B25] should be present if [B5I] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:CompanyInformation/ct:CFCTaxCalculation) or ct:TotalCFCtaxChargeble"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9454</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box B30 must be completed if any of 'Tax on chargeable profits' in Box B5F, 'Creditable tax' in Box B5G, 'Reliefs in terms of tax' in Box B5H, 'ACT as restricted' in Box B5I or 'CFC charge due' in Box B5J are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[B30] should be present if [SB010b] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:CompanyInformation or ct:ForeignPermanentEstablishmentExemption or ct:HybridAndOtherMismatches"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9460</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600B is present so at least one of Boxes B5, B35 or within the range B40 to B85 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [N096] is present, then at least one of [COMPANYINFORMATIONPAGEB], [B35] or [HYBRID] should be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600B = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9306</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600B is present so Box 100 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[100] should equal 'yes' if [N096] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M206" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M206" priority="-1"/>
  <axsl:template match="@*|node()" mode="M206" priority="-2">
    <axsl:apply-templates mode="M206" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p207-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:CompanyInformation/ct:Company/ct:AccountingPeriod" mode="M207" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(ct:From)) div 86400) &lt;= round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9502</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period From date of surrendering company' in Box C5B must be on or before the return period To date in Box 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' date of [C5B] should be on or before [35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate(date:add(normalize-space(string(ct:To)),normalize-space('-P12M')),'-','') &lt; translate(ct:From,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9503</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' in Box C5B must not be longer than 12 months.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The period covered by [C5B] should not be longer than 12 months</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9504</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' To date must not be before the From date in Box C5B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C5B] should not be before the 'From' date</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9505</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' To date in Box C5B must be on or after the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C5B] should be on or after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M207" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M207" priority="-1"/>
  <axsl:template match="@*|node()" mode="M207" priority="-2">
    <axsl:apply-templates mode="M207" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p208-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:CompanyInformation/ct:TotalAmountClaimed" mode="M208" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief and (math:abs((sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief)) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9506</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box C10 is completed then Box 310 must be completed and equal to Box C10</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[310] should be present and equal to [C10] if [C10] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Company/ct:AmountClaimed))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9507</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C10 must equal the sum of 'Claims to group relief Amount Claimed' in Boxes C5D</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C10] should equal the sum of all iterations of [C5D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M208" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M208" priority="-1"/>
  <axsl:template match="@*|node()" mode="M208" priority="-2">
    <axsl:apply-templates mode="M208" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p209-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:ClaimToGroupRelief/ct:ClaimAuthorisation/ct:CopyOfNoticesOfConsentAttached" mode="M209" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../../ct:AttachedFiles/ct:Attachment[@Type='other' and @Format='pdf']) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9510</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is completed then a PDF attachment of type 'Other' must be included</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SC161] is 'yes' then there must be a PDF attachment of type 'other' in this submission.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief)) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9973</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is completed then Box 310 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[310] should exceed 0 if [SC161] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M209" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M209" priority="-1"/>
  <axsl:template match="@*|node()" mode="M209" priority="-2">
    <axsl:apply-templates mode="M209" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p206-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:ClaimToGroupRelief" mode="M210" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:ClaimAuthorisation               or             not((.))                or             not(../../@ReturnType = 'new')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9518</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The Claim authorisation section must be completed if the return type is New and there is a claim to group relief</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CLAIMAUTHORISATION] should be present if [N003] equals 'new' and [CLAIMTOGROUPRELIEF] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M210" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M210" priority="-1"/>
  <axsl:template match="@*|node()" mode="M210" priority="-2">
    <axsl:apply-templates mode="M210" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p210-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:NItradingLosses" mode="M211" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9168</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C46 can only be completed if Box 5 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [C46] is present then [5] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:TradingLosses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9177</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C46 must not be greater than Box C45</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C46] must not exceed [C45]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M211" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M211" priority="-1"/>
  <axsl:template match="@*|node()" mode="M211" priority="-2">
    <axsl:apply-templates mode="M211" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p211-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:TotalSurrender" mode="M212" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TradingLosses) + sum(../ct:ExcessNonTrading) + sum(../ct:NonTradingDeficit) + sum(../ct:NonTradingLossesOnIntangibleFixedAssets) + sum(../ct:ExcessDonations) + sum(../ct:ExcessLosses) + sum(../ct:ExcessManagementExpenses)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9511</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C80 must equal the sum of Boxes C45, C50, C55, C60, C65, C70 and C75</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C80] should equal the sum of [C45], [C50], [C55], [C75], [C60], [C65] and [C70]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M212" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M212" priority="-1"/>
  <axsl:template match="@*|node()" mode="M212" priority="-2">
    <axsl:apply-templates mode="M212" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p212-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:SurrenderInformation/ct:Company/ct:AccountingPeriod" mode="M213" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(ct:From)) div 86400) &lt;= round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9513</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' From date in Box C85B must be on or before the return period To date in Box 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' date of [C85B] should be on or before [35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="translate(date:add(normalize-space(string(ct:To)),normalize-space('-P12M')),'-','') &lt; translate(ct:From,'-','')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9514</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' in Box C85B must not be longer than 12 months.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The period covered by [C85B] should not be longer than 12 months</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9515</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' To date must not be before the From date in Box C85B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C85B] should not be before the 'From' date</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9516</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' To date in Box C85B must be on or after the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C85B] should be on or after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M213" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M213" priority="-1"/>
  <axsl:template match="@*|node()" mode="M213" priority="-2">
    <axsl:apply-templates mode="M213" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p213-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:SurrenderInformation/ct:AmountSurrenderedTotal" mode="M214" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Company/ct:AmountSurrendered))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9517</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C90 must equal the sum of all 'Amount surrendered' in Boxes C85D</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C90] should equal the sum of all iterations of [C85D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M214" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M214" priority="-1"/>
  <axsl:template match="@*|node()" mode="M214" priority="-2">
    <axsl:apply-templates mode="M214" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p214-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:ConsentOptions/ct:SimplifiedArrangementInForce" mode="M215" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9974</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Simplified arrangement in force' is completed then Box C90 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C90] should exceed 0 if [SC150] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M215" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M215" priority="-1"/>
  <axsl:template match="@*|node()" mode="M215" priority="-2">
    <axsl:apply-templates mode="M215" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p215-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:ConsentOptions/ct:NoticeOfConsentCompleted" mode="M216" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:Declaration"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9519</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Amounts surrendered as group relief Declaration must be completed if Notice of consent is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[DECLARATION] should be present if [SC151] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:CopyOfNoticesOfConsentAttached)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9961</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Notice of consent completed' must not be Yes if 'Copy of notices of consent attached' is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SC151] should not be present if [SC152] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9975</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Notice of consent completed' is Yes then Box C90 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C90] should exceed 0 if [SC151] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M216" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M216" priority="-1"/>
  <axsl:template match="@*|node()" mode="M216" priority="-2">
    <axsl:apply-templates mode="M216" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p216-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:ConsentOptions/ct:CopyOfNoticesOfConsentAttached" mode="M217" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../ct:Declaration and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9521</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Copies of notices of consent' must not be completed if 'Amounts surrendered as group relief Declaration' is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SC152] should not be present if [DECLARATION] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../../../ct:AttachedFiles/ct:Attachment[@Type='other' and @Format='pdf']) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9522</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Amounts surrendered as group relief 'Copies of notices of consent' is Yes then a PDF attachment of type 'Other' must be included</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SC152] is 'yes' then there must be a PDF attachment of type 'other' in this submission</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9976</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is Yes then Box C90 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C90] should exceed 0 if [SC152] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M217" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M217" priority="-1"/>
  <axsl:template match="@*|node()" mode="M217" priority="-2">
    <axsl:apply-templates mode="M217" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p217-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:Declaration/ct:CompanyName" mode="M218" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../../ct:CompanyInformation/ct:CompanyName = (.)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9523</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The company name in Box C95 must equal the company name in Box 1</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C95] should equal [1]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M218" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M218" priority="-1"/>
  <axsl:template match="@*|node()" mode="M218" priority="-2">
    <axsl:apply-templates mode="M218" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p218-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:Declaration/ct:TaxReference" mode="M219" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../../../../../ct:CompanyInformation/ct:Reference"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9543</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The tax reference in Box C100 must equal the tax reference in Box 3</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C100] should equal [3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M219" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M219" priority="-1"/>
  <axsl:template match="@*|node()" mode="M219" priority="-2">
    <axsl:apply-templates mode="M219" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p219-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupRelief/ct:ConsentToSurrender/ct:Declaration/ct:AccountingPeriod" mode="M220" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="normalize-space(ct:From) = normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From) and normalize-space(ct:To) = normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9524</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Details of company surrendering relief Accounting period in Boxes C105 and C110 must match the Accounting period of the return in Boxes 30 and 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' and 'To' dates of [C105/C110] should equal [30] and [35] respectively</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M220" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M220" priority="-1"/>
  <axsl:template match="@*|node()" mode="M220" priority="-2">
    <axsl:apply-templates mode="M220" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p221-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:CompanyInformation/ct:Company/ct:AccountingPeriod" mode="M221" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(ct:From)) div 86400) &lt;= round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9546</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period From date of surrendering company' in Box C125B must be on or before the return period To date in Box 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' date of [C125B] should be on or before [35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(date:add(normalize-space(ct:To),normalize-space('-P12M')))) div 86400) &lt;= round(date:seconds(normalize-space(date:add(normalize-space(ct:From),normalize-space('-P1D')))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9547</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' in Box C125B must not be longer than 12 months.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The period covered by [C125B] should not be longer than 12 months</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9548</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' To date must not be before the From date in Box C125B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C125B] should not be before the 'From' date</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9549</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of surrendering company' To date in Box C125B must be on or after the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C125B] should be on or after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M221" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M221" priority="-1"/>
  <axsl:template match="@*|node()" mode="M221" priority="-2">
    <axsl:apply-templates mode="M221" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p222-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:CompanyInformation/ct:TotalAmountClaimed" mode="M222" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses and (math:abs((sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses)) - ((.))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9550</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box C130 is completed then Box 312 must be completed and equal to Box C130</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[312] should be present and equal to [C130] if [C130] is present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Company/ct:AmountClaimed))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9551</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C130 must equal the sum of 'Claims to group relief for carried forward losses Amount Claimed' in Boxes C125D</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C130] should equal the sum of all iterations of [C125D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M222" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M222" priority="-1"/>
  <axsl:template match="@*|node()" mode="M222" priority="-2">
    <axsl:apply-templates mode="M222" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p223-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses/ct:ClaimAuthorisation/ct:CopyOfNoticesOfConsentAttached" mode="M223" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../../ct:AttachedFiles/ct:Attachment[@Type='other' and @Format='pdf']) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9552</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is completed then a PDF attachment of type 'Other' must be included</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SC172] is 'yes' then there must be a PDF attachment of type 'other' in this submission.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses)) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9553</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is completed then Box 312 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[312] should exceed 0 if [SC172] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M223" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M223" priority="-1"/>
  <axsl:template match="@*|node()" mode="M223" priority="-2">
    <axsl:apply-templates mode="M223" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p220-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:GroupReliefForCarriedForwardLosses" mode="M224" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:ClaimAuthorisation               or             not((.))                or             not(../../@ReturnType = 'new')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9545</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The Claim authorisation section must be completed if the return type is New and there is a claim to group relief for carried forward losses</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[CLAIMAUTHORISATION2] should be present if [N003] equals 'new' and [GROUPRELIEFCFL] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M224" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M224" priority="-1"/>
  <axsl:template match="@*|node()" mode="M224" priority="-2">
    <axsl:apply-templates mode="M224" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p224-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:NItradingLosses" mode="M225" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:CompanyInformation/ct:NorthernIreland/ct:NItradingActivity"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9181</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C161 can only be completed if Box 5 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [C161] is present then [5] must be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../ct:TradingLosses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9182</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C161 must not be greater than Box C160</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C161] must not exceed [C160]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M225" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M225" priority="-1"/>
  <axsl:template match="@*|node()" mode="M225" priority="-2">
    <axsl:apply-templates mode="M225" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p225-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:TotalSurrender" mode="M226" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TradingLosses) + sum(../ct:NonTradingDeficit) + sum(../ct:UKpropertyBusinessLosses) + sum(../ct:ManagementExpenses) + sum(../ct:NonTradingDeficitsOnIntangibleFixedAssets)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9554</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C185 must equal the sum of Boxes C160, C165, C170, C175 and C180</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C185] should equal the sum of [C160], [C165], [C170], [C175] and [C180]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M226" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M226" priority="-1"/>
  <axsl:template match="@*|node()" mode="M226" priority="-2">
    <axsl:apply-templates mode="M226" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p226-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:SurrenderInformation/ct:Company/ct:AccountingPeriod" mode="M227" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(ct:From)) div 86400) &lt;= round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9555</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' From date in Box C190B must be on or before the return period To date in Box 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' date of [C190B] should be on or before [35]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(date:add(normalize-space(ct:To),normalize-space('-P12M')))) div 86400) &lt;= round(date:seconds(normalize-space(date:add(normalize-space(ct:From),normalize-space('-P1D')))) div 86400))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9556</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' in Box C190B must not be longer than 12 months.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The period covered by [C190B] should not be longer than 12 months</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9557</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' To date must not be before the From date in Box C190B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C190B] should not be before the 'From' date</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((round(date:seconds(normalize-space(ct:To)) div 86400) &lt; round(date:seconds(normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400)))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9558</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The 'Accounting period of claimant company' To date in Box C190B must be on or after the return period From date in Box 30</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'To' date of [C190B] should be on or after [30]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M227" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M227" priority="-1"/>
  <axsl:template match="@*|node()" mode="M227" priority="-2">
    <axsl:apply-templates mode="M227" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p227-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:SurrenderInformation/ct:AmountSurrenderedTotal" mode="M228" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - (sum(../ct:Company/ct:AmountSurrendered))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9559</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box C195 must equal the sum of all 'Amount surrendered' in Boxes C190D</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C195] should equal the sum of all iterations of [C190D]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M228" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M228" priority="-1"/>
  <axsl:template match="@*|node()" mode="M228" priority="-2">
    <axsl:apply-templates mode="M228" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p228-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:ConsentOptions/ct:SimplifiedArrangementInForce" mode="M229" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9560</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Simplified arrangement in force' is completed then Box C195 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C195] should exceed 0 if [SC188] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M229" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M229" priority="-1"/>
  <axsl:template match="@*|node()" mode="M229" priority="-2">
    <axsl:apply-templates mode="M229" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p229-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:ConsentOptions/ct:NoticeOfConsentCompleted" mode="M230" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../ct:Declaration"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9561</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Amounts surrendered as group relief for carried forward losses Declaration must be completed if Notice of consent is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[DECLARATION2] should be present if [SC189] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9562</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Simplified arrangement in force' is completed then Box C195 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C195] should exceed 0 if [SC189] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:CopyOfNoticesOfConsentAttached)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9563</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Notice of consent completed' must not be Yes if 'Copy of notices of consent attached' is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SC189] should not be present if [SC190] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M230" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M230" priority="-1"/>
  <axsl:template match="@*|node()" mode="M230" priority="-2">
    <axsl:apply-templates mode="M230" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p230-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:ConsentOptions/ct:CopyOfNoticesOfConsentAttached" mode="M231" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../../ct:Declaration)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9564</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Copies of notices of consent' must not be completed if 'Amounts surrendered as group relief for carried forward losses Declaration' is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[SC190] should not be present if [DECLARATION2] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="count(../../../../../ct:AttachedFiles/ct:Attachment[@Type='other' and @Format='pdf']) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9565</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Amounts surrendered as group relief for carried forward losses 'Copies of notices of consent' is Yes then a PDF attachment of type 'Other' must be included</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [SC190] is 'yes' then there must be a PDF attachment of type 'other' in this submission.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="((../../../ct:SurrenderInformation/ct:AmountSurrenderedTotal) - (0) &gt;= 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9566</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If 'Copy of notices of consent' is Yes then Box C195 must be greater than 0 (zero)</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C195] should exceed 0 if [SC190] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M231" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M231" priority="-1"/>
  <axsl:template match="@*|node()" mode="M231" priority="-2">
    <axsl:apply-templates mode="M231" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p231-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:Declaration/ct:CompanyName" mode="M232" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../../ct:CompanyInformation/ct:CompanyName = (.)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9567</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The company name in Box C200 must equal the company name in Box 1</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C200] should equal [1]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M232" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M232" priority="-1"/>
  <axsl:template match="@*|node()" mode="M232" priority="-2">
    <axsl:apply-templates mode="M232" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p232-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:Declaration/ct:TaxReference" mode="M233" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(.) = ../../../../../ct:CompanyInformation/ct:Reference"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9568</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">The tax reference in Box C205 must equal the tax reference in Box 3</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[C205] should equal [3]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M233" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M233" priority="-1"/>
  <axsl:template match="@*|node()" mode="M233" priority="-2">
    <axsl:apply-templates mode="M233" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p233-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium/ct:SurrenderedGroupReliefForCarriedForwardLosses/ct:ConsentToSurrender/ct:Declaration/ct:AccountingPeriod" mode="M234" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="normalize-space(ct:From) = normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From) and normalize-space(ct:To) = normalize-space(../../../../../ct:CompanyInformation/ct:PeriodCovered/ct:To)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9569</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Details of company surrendering relief Accounting period in Boxes C210 and C215 must match the Accounting period of the return in Boxes 30 and 35</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>The 'From' and 'To' dates of [C210/C215] should equal [30] and [35] respectively</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M234" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M234" priority="-1"/>
  <axsl:template match="@*|node()" mode="M234" priority="-2">
    <axsl:apply-templates mode="M234" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p205-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:GroupAndConsortium" mode="M235" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:ClaimToGroupRelief               or             ct:SurrenderedGroupRelief               or             ct:GroupReliefForCarriedForwardLosses               or             ct:SurrenderedGroupReliefForCarriedForwardLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9544</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">At least one of 'Part 1: Claims to group relief', 'Part 2: Amounts surrendered as group relief' must be completed, 'Part 3: Claims to group relief for carried forward losses' and 'Part 4: Amounts surrendered as group relief for carried forward losses' must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>At least one of [CLAIMTOGROUPRELIEF], [SURRENDEREDGROUPRELIEF], [GROUPRELIEFCFL] or [SURRGROUPRELIEFCFL] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600C = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9307</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600C is present so Box 105 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[105] should equal 'yes' if [N097] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M235" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M235" priority="-1"/>
  <axsl:template match="@*|node()" mode="M235" priority="-2">
    <axsl:apply-templates mode="M235" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p234-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Insurance" mode="M236" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600D = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9308</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600D is present so Box 110 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[110] should equal 'yes' if [N098] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M236" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M236" priority="-1"/>
  <axsl:template match="@*|node()" mode="M236" priority="-2">
    <axsl:apply-templates mode="M236" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p236-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity/ct:InformationRequired/ct:Income/ct:Total" mode="M237" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TotalTurnover) + sum(../ct:InvestmentIncome) + sum(../ct:UKlandBuildings) + sum(../ct:GiftAid) + sum(../ct:OtherCharities) + sum(../ct:GiftsOfShares) + sum(../ct:GiftOfRealProperty) + sum(../ct:OtherSources)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9614</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box E90 must equal the sum of Boxes E50, E55, E60, E65, E70, E75, E80 and E85</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[E90] should equal the sum of [E50], [E55], [E60], [E65], [E70], [E75], [E80] and [E85]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M237" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M237" priority="-1"/>
  <axsl:template match="@*|node()" mode="M237" priority="-2">
    <axsl:apply-templates mode="M237" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p237-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity/ct:InformationRequired/ct:Expenditure/ct:TradingCosts" mode="M238" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../../ct:Income/ct:TotalTurnover) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9611</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box E50 must be greater than 0 (zero) if Box E95 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[E50] should exceed 0 if [E95] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M238" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M238" priority="-1"/>
  <axsl:template match="@*|node()" mode="M238" priority="-2">
    <axsl:apply-templates mode="M238" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p238-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity/ct:InformationRequired/ct:Expenditure/ct:UKlandBuildings" mode="M239" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="sum(../../ct:Income/ct:UKlandBuildings) &gt; 0"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9612</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box E60 must be greater than 0 (zero) if Box E100 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[E60] should exceed 0 if [E100] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M239" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M239" priority="-1"/>
  <axsl:template match="@*|node()" mode="M239" priority="-2">
    <axsl:apply-templates mode="M239" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p239-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity/ct:InformationRequired/ct:Expenditure/ct:Total" mode="M240" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:TradingCosts) + sum(../ct:UKlandBuildings) + sum(../ct:GeneralAdminCosts) + sum(../ct:GrantsDonationsWithinUK) + sum(../ct:GrantsDonationsOutsideUK) + sum(../ct:OtherExpenditure)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9615</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box E125 must equal the sum of Boxes E95, E100, E105, E110, E115 and E120</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[E125] should equal the sum of [E95], [E100], [E105], [E110], [E115] and [E120]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M240" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M240" priority="-1"/>
  <axsl:template match="@*|node()" mode="M240" priority="-2">
    <axsl:apply-templates mode="M240" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p240-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity/ct:InformationRequired/ct:Assets/ct:InvestmentsOrLoans/ct:Qualifying" mode="M241" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:ValueOfNonQualifying and (.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9613</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box E180 must not be completed if Box E185 is completed.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[E180] should not be present if [E185] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M241" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M241" priority="-1"/>
  <axsl:template match="@*|node()" mode="M241" priority="-2">
    <axsl:apply-templates mode="M241" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p235-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:Charity" mode="M242" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600E = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9309</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600E is present so Box 115 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[115] should equal 'yes' if [N099] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M242" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M242" priority="-1"/>
  <axsl:template match="@*|node()" mode="M242" priority="-2">
    <axsl:apply-templates mode="M242" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p244-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:TonnageGroup/ct:GroupElection" mode="M243" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../ct:Name"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9651</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box F10 must be completed if Box F5A is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F10] should be present if [F5A/F5B] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../../ct:GroupMetCharteredInLimit"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9652</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box F25A, F25B of F25C must be completed if Box F5A is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F25A/F25B/F25C] should be present if [F5A/F5B] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M243" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M243" priority="-1"/>
  <axsl:template match="@*|node()" mode="M243" priority="-2">
    <axsl:apply-templates mode="M243" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p245-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:TonnageGroup/ct:Name" mode="M244" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:GroupElection = 'no') or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9653</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box F10 must not be completed if Box F5B is No</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F10] should not be present if [F5A/F5B] equals 'no'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M244" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M244" priority="-1"/>
  <axsl:template match="@*|node()" mode="M244" priority="-2">
    <axsl:apply-templates mode="M244" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p246-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:CompanyMetCharteredInLimit" mode="M245" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:TonnageGroup/ct:GroupElection = 'yes') or (. = 'na')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9656</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If Box F5A is Yes then Box F20C must be Not applicable</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F20A/F20B/F20C] should equal 'na' if [F5A/F5B] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M245" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M245" priority="-1"/>
  <axsl:template match="@*|node()" mode="M245" priority="-2">
    <axsl:apply-templates mode="M245" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p247-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:GroupMetCharteredInLimit" mode="M246" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:TonnageGroup/ct:GroupElection = 'no') or not((.))"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9659</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes F25A, F25B or F25C must not be completed if Box F5B is No</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F25A/F25B/F25C] should not be present if [F5A/F5B] equals 'no'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M246" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M246" priority="-1"/>
  <axsl:template match="@*|node()" mode="M246" priority="-2">
    <axsl:apply-templates mode="M246" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p248-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:NotRegistered" mode="M247" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(round(date:seconds(normalize-space(../../../../ct:CompanyInformation/ct:PeriodCovered/ct:From)) div 86400) &lt; round(date:seconds(normalize-space('2022-04-01')) div 86400))               or not((.) = 'yes' or (.) = 'no')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9464</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">If the return period start date in Box 30 is on or after 01/04/2022 then Boxes F30A and F30B must not be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [30] onOrAfter '2022-04-01' then [F30A/F30B/F30C] may not be 'yes' or 'no'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M247" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M247" priority="-1"/>
  <axsl:template match="@*|node()" mode="M247" priority="-2">
    <axsl:apply-templates mode="M247" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p249-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:Flagging" mode="M248" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NotRegistered = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9665</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Boxes F35A or F35B must not be completed unless F30A is Yes.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F35A/F35B] should not be present if [F30A/F30B/F30C] does not equal 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M248" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M248" priority="-1"/>
  <axsl:template match="@*|node()" mode="M248" priority="-2">
    <axsl:apply-templates mode="M248" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p250-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information/ct:OffshoreActivities" mode="M249" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) = 'yes') or ../../ct:OffshoreTrainingAllowance"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9660</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Part 2 Offshore training allowance must be completed if Box F40A is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[OFFSHORETRAININGALLOWANCE] should be present if [F40A/F40B] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M249" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M249" priority="-1"/>
  <axsl:template match="@*|node()" mode="M249" priority="-2">
    <axsl:apply-templates mode="M249" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p243-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:Information" mode="M250" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(ct:NotRegistered = 'yes') or ct:Flagging"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9664</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box F35A or F35B must be completed if Box F30A is Yes</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F35A/F35B] should be present if [F30A/F30B/F30C] equals 'yes'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M250" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M250" priority="-1"/>
  <axsl:template match="@*|node()" mode="M250" priority="-2">
    <axsl:apply-templates mode="M250" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p251-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:OffshoreTrainingAllowance" mode="M251" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(../ct:Information/ct:OffshoreActivities = 'no')"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9666</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Part 2 Offshore training allowance must not be present if Box F40B is No</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[OFFSHORETRAININGALLOWANCE] should not be present if [F40A/F40B] equals 'no'</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M251" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M251" priority="-1"/>
  <axsl:template match="@*|node()" mode="M251" priority="-2">
    <axsl:apply-templates mode="M251" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p252-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax/ct:QualifyingShips/ct:Total" mode="M252" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = floor(sum(../ct:Ship/ct:Profits) + 0.0001 )"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9663</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box F70 must equal the sum of 'Tonnage Tax profits' in boxes 70G rounded down to the nearest whole pound.</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[F70] should equal ( the sum of all iterations of [F70G] ) rounded down to the nearest whole pound</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M252" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M252" priority="-1"/>
  <axsl:template match="@*|node()" mode="M252" priority="-2">
    <axsl:apply-templates mode="M252" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p242-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax/ct:TonnageTax" mode="M253" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="ct:QualifyingShips or ct:RelevantShippingProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9650</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600F can only be present if at least one of 'Part 3 Relevant shipping profits' or 'Part 4: Computation of tonnage tax profits' is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[QUALIFYINGSHIPS] or [RELEVANTSHIPPINGPROFITS] should be present if [TONNAGETAX] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M253" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M253" priority="-1"/>
  <axsl:template match="@*|node()" mode="M253" priority="-2">
    <axsl:apply-templates mode="M253" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p241-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:TonnageTax" mode="M254" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:ReturnInfoSummary/ct:SupplementaryPages/ct:CT600F = 'yes'"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9310</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Supplementary form CT600F is present so Box 120 must be completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[120] should equal 'yes' if [N100] is present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M254" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M254" priority="-1"/>
  <axsl:template match="@*|node()" mode="M254" priority="-2">
    <axsl:apply-templates mode="M254" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p255-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:Trading/ct:Profits/ct:Total" mode="M255" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:Profits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9187</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G5C can only be completed if Box 155 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G5C] is present then [155] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9189</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G5C can only be completed if Box G5A or Box G5B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G5C] is present, at least one of [G5A] or [G5B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9191</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G5C must equal the sum of Boxes G5A and G5B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G5C] should equal [G5A] plus [G5B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:Profits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9192</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G5C must equal Box 155</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G5C] should equal [155].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M255" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M255" priority="-1"/>
  <axsl:template match="@*|node()" mode="M255" priority="-2">
    <axsl:apply-templates mode="M255" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p256-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:Trading/ct:LossesBroughtForward/ct:Total" mode="M256" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:LossesBroughtForward"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9194</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G10C can only be completed if Box 160 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G10C] is present, [160] should be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9196</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G10C can only be completed if Box G10A or Box G10B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G10C] is present then [G10A] or [G10B] should be present.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9205</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G10C must equal the sum of Boxes G10A and G10B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G10C] should equal [G10A] plus [G10B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:LossesBroughtForward)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9215</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G10C must equal Box 160</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G10C] should equal [160]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". &lt;= sum(../../ct:Profits/ct:Total)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9217</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G10C must not exceed Box G5C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G10C] should not exceed [G5C].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M256" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M256" priority="-1"/>
  <axsl:template match="@*|node()" mode="M256" priority="-2">
    <axsl:apply-templates mode="M256" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p257-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:Trading/ct:LossesBroughtForwardUsed/ct:Total" mode="M257" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9219</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G15C must equal Box G15B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G15C] is valid only if this equals [G15B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M257" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M257" priority="-1"/>
  <axsl:template match="@*|node()" mode="M257" priority="-2">
    <axsl:apply-templates mode="M257" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p258-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:Trading/ct:NetProfits/ct:Total" mode="M258" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:NetProfits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9243</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G20C can only be completed if Box 165 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G20C] is present, [165] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9253</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G20C can only be completed if Box G20A or Box G20B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G20C] is present then [G20A] or [G20B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../ct:Profits/ct:Total) - sum(../../ct:LossesBroughtForward/ct:Total)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9255</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G20C must equal Box G5C minus Box G10C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G20C] should equal [G5C] minus [G10C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:Income/ct:Trading/ct:NetProfits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9256</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G20C must equal Box 165</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G20C] should equal [165]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M258" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M258" priority="-1"/>
  <axsl:template match="@*|node()" mode="M258" priority="-2">
    <axsl:apply-templates mode="M258" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p254-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:Trading" mode="M259" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not(sum(ct:Profits/ct:Total) &gt; 0) or ct:NetProfits/ct:Total"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9184</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G20 must be completed if Box G5 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G20C] should be present if [G5C] is positive.</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M259" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M259" priority="-1"/>
  <axsl:template match="@*|node()" mode="M259" priority="-2">
    <axsl:apply-templates mode="M259" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p259-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:TotalProfits/ct:NonTradeProfitsAndGains/ct:Total" mode="M260" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9259</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G25C must equal Box G25B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G25C] should equal [G25B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M260" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M260" priority="-1"/>
  <axsl:template match="@*|node()" mode="M260" priority="-2">
    <axsl:apply-templates mode="M260" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p260-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:TotalProfits/ct:TotalProfitsAndGains/ct:Total" mode="M261" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9262</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G30C can only be completed if Box G30A or Box G30B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G30C] is present, [G30A] or [G30B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9265</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G30C must equal the sum of Boxes G30A and G30B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G30C] should equal [G30A] plus [G30B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) &gt; 0) or ../../../ct:ProfitsBeforeDeductions/ct:ProfitsBeforeOtherDeductionsAndReliefs/ct:Total"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9266</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45C must be completed if Box G30C is greater than zero</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G45C] should be present if [G30C] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M261" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M261" priority="-1"/>
  <axsl:template match="@*|node()" mode="M261" priority="-2">
    <axsl:apply-templates mode="M261" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p261-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:ProfitsBeforeDeductions/ct:LossesBroughtForward/ct:Total" mode="M262" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:LossesBroughtForward"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9292</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G35C can only be completed if Box 225 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G35C] is present, [225] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9293</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G35C must equal Box G35B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G35C] should equal [G35B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:LossesBroughtForward)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9090</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G35C must equal Box 225</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G35C] should equal [225]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M262" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M262" priority="-1"/>
  <axsl:template match="@*|node()" mode="M262" priority="-2">
    <axsl:apply-templates mode="M262" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p262-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:ProfitsBeforeDeductions/ct:DeficitsBroughtForward/ct:Total" mode="M263" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:NonTradeDeficitsOnLoans"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9091</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G40C can only be completed if Box 230 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G40C] is present, [230] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9092</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G40C must equal Box G40B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G40C] should equal [G40B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:NonTradeDeficitsOnLoans)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9093</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G40C must equal Box 230</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G40C] should equal [230]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M263" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M263" priority="-1"/>
  <axsl:template match="@*|node()" mode="M263" priority="-2">
    <axsl:apply-templates mode="M263" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p263-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:ProfitsBeforeDeductions/ct:ProfitsBeforeOtherDeductionsAndReliefs/ct:NorthernIreland" mode="M264" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../ct:TotalProfits/ct:TotalProfitsAndGains/ct:NorthernIreland)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9095</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45A must equal Box G30A</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G45A] should equal [G30A]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M264" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M264" priority="-1"/>
  <axsl:template match="@*|node()" mode="M264" priority="-2">
    <axsl:apply-templates mode="M264" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p264-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:ProfitsBeforeDeductions/ct:ProfitsBeforeOtherDeductionsAndReliefs/ct:RestOfUK" mode="M265" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../../ct:TotalProfits/ct:TotalProfitsAndGains/ct:RestOfUK) - (sum(../../ct:LossesBroughtForward/ct:RestOfUK) + sum(../../ct:DeficitsBroughtForward/ct:RestOfUK))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9096</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45B must equal Box G30B minus the sum of Boxes G35B and G40B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G45B] must equal [G30B] minus ([G35B] plus [G40B])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M265" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M265" priority="-1"/>
  <axsl:template match="@*|node()" mode="M265" priority="-2">
    <axsl:apply-templates mode="M265" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p265-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:ProfitsBeforeDeductions/ct:ProfitsBeforeOtherDeductionsAndReliefs/ct:Total" mode="M266" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ProfitsBeforeOtherDeductions"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9097</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45C can only be completed if Box 235 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G45C] is present, [235] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9098</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45C can only be completed if Box G45A or Box G45B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G45C] is present, [G45A] or [G45B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../../ct:TotalProfits/ct:TotalProfitsAndGains/ct:Total) - (sum(../../ct:LossesBroughtForward/ct:Total) + sum(../../ct:DeficitsBroughtForward/ct:Total))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9280</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45C must equal Box G30C minus the sum of Boxes G35C and G40C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G45C] must equal [G30C] minus ([G35C] plus [G40C])</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:ProfitsBeforeOtherDeductions)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9294</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G45C must equal Box 235</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G45C] should equal [235]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="not((.) &gt; 0) or ../../../ct:DeductionsAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief/ct:Total"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9295</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C must be completed if Box G45C is greater than zero</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G105C] should be present if [G45C] exceeds 0</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M266" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M266" priority="-1"/>
  <axsl:template match="@*|node()" mode="M266" priority="-2">
    <axsl:apply-templates mode="M266" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p267-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:LossesUnquotedShares/ct:Total" mode="M267" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UnquotedShares"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9299</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G50C can only be completed if Box 240 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G50C] is present, [240] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9311</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G50C can only be completed if Box G50A or Box G50B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G50C] is present, [G50A] or [G50B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9317</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G50C must equal the sum of Boxes G50A and G50B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G50C] should equal [G50A] plus [G50B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UnquotedShares)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9402</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G50C must equal Box 240</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G50C] should equal [240].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M267" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M267" priority="-1"/>
  <axsl:template match="@*|node()" mode="M267" priority="-2">
    <axsl:apply-templates mode="M267" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p268-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:ManagementExpenses/ct:Total" mode="M268" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:ManagementExpenses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9410</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G55C can only be completed if Box 245 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G55C] is present, [245] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9441</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G55C can only be completed if Box G55A or Box G55B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G55C] is present, [G55A] or [G55B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9442</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G55C must equal the sum of Boxes G55A and G55B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G55C] should equal [G55A] plus [G55B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:ManagementExpenses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9443</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G55C must equal Box 245</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G55C] should equal [245].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M268" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M268" priority="-1"/>
  <axsl:template match="@*|node()" mode="M268" priority="-2">
    <axsl:apply-templates mode="M268" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p269-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses/ct:Total" mode="M269" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9444</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G60C can only be completed if Box 250 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G60C] is present, [250] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9445</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G60C can only be completed if Box G60A or Box G60B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G60C] is present, [G60A] or [G60B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9446</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G60C must equal the sum of Boxes G60A and G60B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G60C] should equal [G60A] plus [G60B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:UKpropertyBusinessLosses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9447</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G60C must equal Box 250</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G60C] should equal [250].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M269" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M269" priority="-1"/>
  <axsl:template match="@*|node()" mode="M269" priority="-2">
    <axsl:apply-templates mode="M269" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p270-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:CapitalAllowancesManagement/ct:Total" mode="M270" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9448</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G65C can only be completed if Box 255 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G65C] is present, [255] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9449</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G65C can only be completed if Box G65A or Box G65B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G65C] is present, [G65A] or [G65B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9530</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G65C must equal the sum of Boxes G65A and G65B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G65C] should equal [G65A] plus [G65B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CapitalAllowances)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9531</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G65C must equal Box 255</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G65C] should equal [255].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M270" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M270" priority="-1"/>
  <axsl:template match="@*|node()" mode="M270" priority="-2">
    <axsl:apply-templates mode="M270" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p271-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:NonTradeDeficits/ct:Total" mode="M271" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeDeficits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9532</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G70C can only be completed if Box 260 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G70C] is present, [260] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9533</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G70C can only be completed if Box G70A or Box G70B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G70C] is present, [G70A] or [G70B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9534</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G70C must equal the sum of Boxes G70A and G70B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G70C] should equal [G70A] plus [G70B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeDeficits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9535</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G70C must equal Box 260</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G70C] should equal [260].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M271" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M271" priority="-1"/>
  <axsl:template match="@*|node()" mode="M271" priority="-2">
    <axsl:apply-templates mode="M271" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p272-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits/ct:Total" mode="M272" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9536</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G73C can only be completed if Box 263 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G73C] is present, [263] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9537</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G73C can only be completed if Box G73A or Box G73B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G73C] is present, [G73A] or [G73B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9538</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G73C must equal the sum of Boxes G73A and G73B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G73C] should equal [G73A] plus [G73B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:CarriedForwardNonTradeDeficits)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9539</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G73C must equal Box 263</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G73C] should equal [263].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M272" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M272" priority="-1"/>
  <axsl:template match="@*|node()" mode="M272" priority="-2">
    <axsl:apply-templates mode="M272" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p273-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles/ct:Total" mode="M273" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9540</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G75C can only be completed if Box 265 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G75C] is present, [265] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9541</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G75C can only be completed if Box G75A or Box G75B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G75C] is present, [G75A] or [G75B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9542</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G75C must equal the sum of Boxes G75A and G75B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G75C] should equal [G75A] plus [G75B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradingLossIntangibles)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9570</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G75C must equal Box 265</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G75C] should equal [265].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M273" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M273" priority="-1"/>
  <axsl:template match="@*|node()" mode="M273" priority="-2">
    <axsl:apply-templates mode="M273" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p274-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLosses/ct:Total" mode="M274" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9571</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G80C can only be completed if Box 275 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G80C] is present, [275] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9572</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G80C can only be completed if Box G80A or Box G80B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G80C] is present, [G80A] or [G80B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9573</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G80C must equal the sum of Boxes G80A and G80B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G80C] should equal [G80A] plus [G80B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLosses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9574</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G80C must equal Box 275</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G80C] should equal [275].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M274" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M274" priority="-1"/>
  <axsl:template match="@*|node()" mode="M274" priority="-2">
    <axsl:apply-templates mode="M274" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p275-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLossesUsed/ct:Total" mode="M275" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9575</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G85C must equal Box G85B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G85C] should equal [G85B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M275" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M275" priority="-1"/>
  <axsl:template match="@*|node()" mode="M275" priority="-2">
    <axsl:apply-templates mode="M275" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p276-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLossesCarriedBack" mode="M276" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedBack"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9576</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G90 can only be completed if Box 280 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G90] is present, [280] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M276" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M276" priority="-1"/>
  <axsl:template match="@*|node()" mode="M276" priority="-2">
    <axsl:apply-templates mode="M276" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p277-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward/ct:Total" mode="M277" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9577</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G92C can only be completed if Box 285 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G92C] is present, [285] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9578</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G92C can only be completed if Box G92A or Box G92B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G92C] is present, [G92A] or [G92B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9579</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G92C must equal the sum of Boxes G92A and G92B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G92C] should equal [G92A] plus [G92B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:TradingLossesCarriedForward)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9580</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G92C must equal Box 285</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G92C] should equal [285].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M277" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M277" priority="-1"/>
  <axsl:template match="@*|node()" mode="M277" priority="-2">
    <axsl:apply-templates mode="M277" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p278-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TradingLossesCarriedForwardUsed/ct:Total" mode="M278" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9581</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G93C must equal Box G93B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G93C] should equal [G93B].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M278" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M278" priority="-1"/>
  <axsl:template match="@*|node()" mode="M278" priority="-2">
    <axsl:apply-templates mode="M278" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p279-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances/ct:Total" mode="M279" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9582</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G95C can only be completed if Box 290 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G95C] is present, [290] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9583</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G95C can only be completed if Box G95A or Box G95B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G95C] is present, [G95A] or [G95B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9584</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G95C must equal the sum of Boxes G95A and G95B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G95C] should equal [G95A] plus [G95B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:NonTradeCapitalAllowances)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9585</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G95C must equal Box 290</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G95C] should equal [290].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M279" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M279" priority="-1"/>
  <axsl:template match="@*|node()" mode="M279" priority="-2">
    <axsl:apply-templates mode="M279" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p280-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:TotalOfDeductionsAndReliefs/ct:Total" mode="M280" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:Total"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9586</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G100C can only be completed if Box 295 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G100C] is present, [295] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9587</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G100C can only be completed if Box G100A or Box G100B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G100C] is present, [G100A] or [G100B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../ct:LossesUnquotedShares/ct:Total) + sum(../../ct:ManagementExpenses/ct:Total) + sum(../../ct:UKpropertyBusinessLosses/ct:Total) + sum(../../ct:CapitalAllowancesManagement/ct:Total) + sum(../../ct:NonTradeDeficits/ct:Total) + sum(../../ct:CarriedForwardNonTradeDeficits/ct:Total) + sum(../../ct:NonTradingLossIntangibles/ct:Total) + sum(../../ct:TradingLosses/ct:Total) + sum(../../ct:TradingLossesCarriedForward/ct:Total) + sum(../../ct:NonTradeCapitalAllowances/ct:Total)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9588</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G100C must equal the sum of Boxes G50C, G55C, G60C, G65C, G70C, G73C, G75C, G80C, G92C and G95C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G100C] must equal the sum of [G50C], [G55C], [G60C], [G65C], [G70C], [G73C], [G75C], [G80C], [G92C] and [G95C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:DeductionsAndReliefs/ct:Total)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9589</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G100C must equal Box 295</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G100C] should equal [295].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9590</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G100C must equal the sum of Boxes G100A and G100B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G100C] should equal [G100A] plus [G100B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M280" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M280" priority="-1"/>
  <axsl:template match="@*|node()" mode="M280" priority="-2">
    <axsl:apply-templates mode="M280" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p281-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief/ct:Total" mode="M281" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9591</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C can only be completed if Box 300 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G105C] is present, [300] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9592</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C can only be completed if Box G105A or Box G105B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G105C] is present, [G105A] or [G105B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../../ct:ProfitsBeforeDeductions/ct:ProfitsBeforeOtherDeductionsAndReliefs/ct:Total) - sum(../../ct:TotalOfDeductionsAndReliefs/ct:Total)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9593</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C must equal Box G45C minus Box G100C</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G105C] must equal [G45C] minus [G100C]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:ProfitsBeforeDonationsAndGroupRelief)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9594</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C must equal Box 300</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G105C] should equal [300].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9595</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G105C must equal the sum of Boxes G105A and G105B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G105C] should equal [G105A] plus [G105B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M281" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M281" priority="-1"/>
  <axsl:template match="@*|node()" mode="M281" priority="-2">
    <axsl:apply-templates mode="M281" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p282-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:QualifyingDonations/ct:Total" mode="M282" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:QualifyingDonations"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9596</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G110C can only be completed if Box 305 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G110C] is present, [305] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9597</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G110C can only be completed if Box G110A or Box G110B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G110C] is present, [G110A] or [G110B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9598</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G110C must equal the sum of Boxes G110A and G110B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G110C] should equal [G110A] plus [G110B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:QualifyingDonations)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9599</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G110C must equal Box 305</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G110C] should equal [305].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M282" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M282" priority="-1"/>
  <axsl:template match="@*|node()" mode="M282" priority="-2">
    <axsl:apply-templates mode="M282" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p283-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:GroupRelief/ct:Total" mode="M283" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9701</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G115C can only be completed if Box 310 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G115C] is present, [310] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9702</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G115C can only be completed if Box G115A or Box G115B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G115C] is present, [G115A] or [G115B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9703</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G115C must equal the sum of Boxes G115A and G115B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G115C] should equal [G115A] plus [G115B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupRelief)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9704</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G115C must equal Box 310</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G115C] should equal [310].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M283" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M283" priority="-1"/>
  <axsl:template match="@*|node()" mode="M283" priority="-2">
    <axsl:apply-templates mode="M283" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p284-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:GroupReliefForCarriedForwardLosses/ct:Total" mode="M284" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9705</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G117C can only be completed if Box 312 is completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G117C] is present, [312] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9706</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G117C can only be completed if Box G117A or Box G117B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G117C] is present, [G117A] or [G117B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../ct:NorthernIreland) + sum(../ct:RestOfUK)))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9707</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G117C must equal the sum of Boxes G117A and G117B</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G117C] should equal [G117A] plus [G117B]</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test=". = sum(../../../../ct:CompanyTaxCalculation/ct:ChargesAndReliefs/ct:GroupReliefForCarriedForwardLosses)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9708</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G117C must equal Box 312</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>[G117C] should equal [312].</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>
    <axsl:apply-templates mode="M284" select="@*|*|comment()|processing-instruction()"/>
  </axsl:template>
  <axsl:template match="text()" mode="M284" priority="-1"/>
  <axsl:template match="@*|node()" mode="M284" priority="-2">
    <axsl:apply-templates mode="M284" select="@*|node()"/>
  </axsl:template>

<!--PATTERN p285-->


	<!--RULE -->
<axsl:template match="/hd:GovTalkMessage/hd:Body/ct:IRenvelope/ct:CompanyTaxReturn/ct:NorthernIreland/ct:DeductionsAndReliefs/ct:ChargeableProfits/ct:Total" mode="M285" priority="4000">

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="../ct:NorthernIreland or ../ct:RestOfUK"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9709</axsl:variable>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="defaultMessage">Box G120C can only be completed if Box G120A or Box G120B are completed</axsl:variable>
        <err:Error xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" xmlns:dsl="http://decisionsoft.com/rim/errorExtension">
          <err:RaisedBy>ChRIS</err:RaisedBy>
          <err:Number>
            <axsl:value-of select="normalize-space($errorCode)"/>
          </err:Number>
          <err:Type>business</err:Type>
          <err:Text>
            <axsl:choose>
              <axsl:when test="normalize-space($defaultMessage)">
                <axsl:copy-of select="$defaultMessage"/>
              </axsl:when>
              <axsl:otherwise>If [G120C] is present, [G120A] or [G120B] should be present</axsl:otherwise>
            </axsl:choose>
          </err:Text>
          <err:Location>
            <axsl:apply-templates mode="schematron-get-full-path" select="."/>
          </err:Location>
        </err:Error>
      </axsl:otherwise>
    </axsl:choose>

		<!--ASSERT -->
<axsl:choose>
      <axsl:when test="(math:abs((.) - ((sum(../../ct:ProfitsBeforeDonationsAndGroupRelief/ct:Total) - (sum(../../ct:QualifyingDonations/ct:Total) + sum(../../ct:GroupRelief/ct:Total) + sum(../../ct:GroupReliefForCarriedForwardLosses/ct:Total))))) &lt; 0.001)"/>
      <axsl:otherwise>
        <axsl:variable xmlns:err="http://www.govtalk.gov.uk/CM/errorresponse" name="errorCode">9808</axsl:variable>
        <a